/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import greenfoot.core.GProject;
import greenfoot.core.WorldHandler;
import greenfoot.export.Exporter;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.MessageDialog;
import greenfoot.gui.export.ExportAppPane;
import greenfoot.gui.export.ExportCompileDialog;
import greenfoot.gui.export.ExportPane;
import greenfoot.gui.export.ExportPublishPane;
import greenfoot.gui.export.ExportWebPagePane;
import greenfoot.gui.export.TabbedIconPane;
import greenfoot.gui.export.TabbedIconPaneListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDialog
extends EscapeDialog
implements TabbedIconPaneListener {
    private static final String dialogTitle = Config.getString((String)"export.dialog.title");
    private static final String noWorldDialogTitle = Config.getString((String)"export.noworld.dialog.title");
    private static final String noWorldDialogMsg = Config.getString((String)"export.noworld.dialog.msg");
    private Frame parent;
    private GProject project;
    private JPanel contentPane;
    private final JProgressBar progressBar = new JProgressBar();
    private final JLabel progressLabel = new JLabel();
    private JButton continueButton;
    private JButton closeButton;
    private HashMap<String, ExportPane> panes;
    private ExportPane selectedPane;
    private String selectedFunction;
    private int progress;

    public ExportDialog(GreenfootFrame parent) {
        super((Frame)parent, dialogTitle, false);
        this.parent = parent;
        this.project = parent.getProject();
        File projectDir = null;
        try {
            projectDir = this.project.getDir();
        }
        catch (ProjectNotOpenException e1) {
            e1.printStackTrace();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        this.createPanes(this.project, projectDir.getParentFile());
        this.makeDialog();
    }

    public void display() {
        boolean isCompiled;
        if (!this.project.isCompiled() && !(isCompiled = this.showCompileDialog(this.project))) {
            return;
        }
        if (WorldHandler.getInstance().getLastWorldClass() == null) {
            JButton[] buttons = new JButton[]{new JButton(Config.getString((String)"greenfoot.continue"))};
            MessageDialog errorDialog = new MessageDialog(this.parent, noWorldDialogMsg, noWorldDialogTitle, 50, buttons);
            errorDialog.display();
            return;
        }
        final ExportPublishPane publishPane = (ExportPublishPane)this.panes.get("PUBLISH");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BufferedImage snapShot = WorldHandler.getInstance().getSnapShot();
                if (snapShot != null) {
                    publishPane.setImage(snapShot);
                }
                ExportDialog.this.clearStatus();
                ExportDialog.this.setVisible(true);
            }
        });
    }

    public void setProgress(final boolean showProgress, final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExportDialog.this.progressBar.setVisible(showProgress);
                if (!showProgress) {
                    ExportDialog.this.progressBar.setIndeterminate(true);
                }
                if (text == null) {
                    ExportDialog.this.progressLabel.setVisible(false);
                } else {
                    ExportDialog.this.progressLabel.setText(text);
                    ExportDialog.this.progressLabel.setVisible(true);
                }
            }
        });
    }

    private void doOK() {
        boolean isCompiled;
        if (!this.project.isCompiled() && !(isCompiled = this.showCompileDialog(this.project))) {
            return;
        }
        this.doExport();
    }

    private void doClose() {
        this.setVisible(false);
    }

    private void doExport() {
        if (this.selectedPane.prePublish()) {
            ExportThread expThread = new ExportThread();
            this.enableButtons(false);
            expThread.start();
        }
    }

    private void clearStatus() {
        if (!this.progressBar.isVisible()) {
            this.progressLabel.setVisible(false);
        }
    }

    private String getSelectedFunction() {
        return this.selectedFunction;
    }

    private ExportPane getSelectedPane() {
        return this.selectedPane;
    }

    private void enableButtons(boolean enable) {
        this.continueButton.setEnabled(enable);
        this.closeButton.setEnabled(enable);
    }

    @Override
    public void tabSelected(String function) {
        this.showPane(function);
    }

    public void showPane(String function) {
        ExportPane chosenPane = this.panes.get(function);
        if (chosenPane != this.selectedPane) {
            if (this.selectedPane != null) {
                this.contentPane.remove(this.selectedPane);
            }
            this.continueButton.setText(Config.getString((String)"export.dialog.continue"));
            chosenPane.activated(this.continueButton);
            this.contentPane.add((Component)chosenPane, "Center");
            this.selectedPane = chosenPane;
            this.selectedFunction = function;
            this.clearStatus();
            this.pack();
            Config.putPropString((String)"greenfoot.lastExportPane", (String)function);
        }
    }

    private void createPanes(GProject project, File defaultExportDir) {
        this.panes = new HashMap();
        this.panes.put("PUBLISH", new ExportPublishPane(project));
        this.panes.put("WEB", new ExportWebPagePane(project.getName(), defaultExportDir));
        this.panes.put("APP", new ExportAppPane(project.getName(), defaultExportDir));
        this.fixSizes(this.panes);
    }

    private void makeDialog() {
        String preferredPane = Config.getPropString((String)"greenfoot.lastExportPane", (String)"PUBLISH");
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.setBorder(null);
        TabbedIconPane tabbedPane = new TabbedIconPane(preferredPane);
        tabbedPane.setListener(this);
        this.contentPane.add((Component)tabbedPane, "North");
        JPanel bottomPanel = new JPanel(new BorderLayout(12, 12));
        bottomPanel.setBorder(BlueJTheme.dialogBorder);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        Dimension size = this.progressBar.getPreferredSize();
        size.width = 100;
        this.progressBar.setPreferredSize(size);
        bottomPanel.add((Component)this.progressBar, "West");
        this.progressLabel.setVisible(false);
        bottomPanel.add((Component)this.progressLabel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        this.continueButton = new JButton(Config.getString((String)"export.dialog.continue"));
        this.continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.doOK();
            }
        });
        this.closeButton = BlueJTheme.getCloseButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.doClose();
            }
        });
        buttonPanel.add(this.continueButton);
        buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.continueButton);
        bottomPanel.add((Component)buttonPanel, "East");
        this.contentPane.add((Component)bottomPanel, "South");
        this.showPane(preferredPane);
        DialogManager.centreDialog((JDialog)((Object)this));
    }

    private void fixSizes(HashMap<String, ExportPane> panes) {
        Dimension size;
        int maxWidth = 0;
        for (ExportPane pane : panes.values()) {
            size = pane.getPreferredSize();
            maxWidth = Math.max(size.width, maxWidth);
        }
        for (ExportPane pane : panes.values()) {
            size = pane.getPreferredSize();
            size.width = maxWidth;
            pane.setPreferredSize(size);
        }
    }

    private boolean showCompileDialog(GProject project) {
        ExportCompileDialog dlg = this.isVisible() ? new ExportCompileDialog((Dialog)((Object)this), project) : new ExportCompileDialog(this.parent, project);
        project.addCompileListener(dlg);
        boolean compiled = dlg.display();
        project.removeCompileListener(dlg);
        return compiled;
    }

    public void publishFinished(boolean success, String msg) {
        this.selectedPane.postPublish(success);
        this.setProgress(false, msg);
    }

    public void gotUploadSize(int bytes) {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(bytes);
        this.progressBar.setValue(0);
        this.progress = 0;
        this.progressBar.setIndeterminate(false);
    }

    public void progressMade(int bytes) {
        this.progress += bytes;
        this.progressBar.setValue(this.progress);
    }

    class ExportThread
    extends Thread {
        ExportThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String function = ExportDialog.this.getSelectedFunction();
                ExportPane pane = ExportDialog.this.getSelectedPane();
                Exporter exporter = Exporter.getInstance();
                if (function.equals("PUBLISH")) {
                    exporter.publishToWebServer(ExportDialog.this.project, (ExportPublishPane)pane, ExportDialog.this);
                }
                if (function.equals("WEB")) {
                    exporter.makeWebPage(ExportDialog.this.project, (ExportWebPagePane)pane, ExportDialog.this);
                }
                if (function.equals("APP")) {
                    exporter.makeApplication(ExportDialog.this.project, (ExportAppPane)pane, ExportDialog.this);
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ExportDialog.this.enableButtons(true);
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

