/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import greenfoot.actions.CompileAllAction;
import greenfoot.core.GProject;
import greenfoot.event.CompileListener;
import greenfoot.gui.WrappingMultiLineLabel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import rmiextension.wrappers.event.RCompileEvent;

public class ExportCompileDialog
extends EscapeDialog
implements CompileListener {
    private String helpLine = Config.getString((String)"export.compile.help");
    private boolean ok;
    private GProject project;

    public ExportCompileDialog(Dialog parent, GProject project) {
        super(parent, Config.getString((String)"export.compile.notCompiled"), true);
        this.project = project;
        this.makeDialog();
    }

    public ExportCompileDialog(Frame parent, GProject project) {
        super(parent, Config.getString((String)"export.compile.notCompiled"), true);
        this.project = project;
        this.makeDialog();
    }

    public boolean display() {
        this.ok = false;
        this.setVisible(true);
        return this.ok;
    }

    private void makeDialog() {
        this.setDefaultCloseOperation(2);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        WrappingMultiLineLabel helpText = new WrappingMultiLineLabel(this.helpLine, 60);
        mainPanel.add((Component)((Object)helpText));
        mainPanel.add(Box.createVerticalStrut(17));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton compileButton = new JButton(new CompileAllAction(this.project));
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportCompileDialog.this.doCancel();
            }
        });
        buttonPanel.add(compileButton);
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(compileButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog((JDialog)((Object)this));
    }

    private void doCancel() {
        this.ok = false;
        this.dispose();
    }

    private void doOk() {
        this.ok = true;
        this.dispose();
    }

    public void compileError(RCompileEvent event) {
    }

    public void compileFailed(RCompileEvent event) {
        this.doCancel();
    }

    public void compileStarted(RCompileEvent event) {
    }

    public void compileSucceeded(RCompileEvent event) {
        if (this.project.isCompiled()) {
            this.doOk();
        }
    }

    public void compileWarning(RCompileEvent event) {
    }
}

