/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser.role;

import bluej.Config;
import bluej.debugmgr.ConstructAction;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.extensions.ProjectNotOpenException;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MemberView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import greenfoot.actions.EditClassAction;
import greenfoot.actions.InspectClassAction;
import greenfoot.actions.NewSubclassAction;
import greenfoot.actions.RemoveClassAction;
import greenfoot.core.GClass;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.WorldInvokeListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.localdebugger.LocalClass;
import java.awt.Color;
import java.awt.Dimension;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassRole
implements WorldListener {
    protected static final Dimension iconSize = new Dimension(16, 16);
    private final Color envOpColour = Config.getItemColour((String)"colour.menu.environOp");

    public abstract void buildUI(ClassView var1, GClass var2);

    public abstract String getTemplateFileName();

    public List<Action> createConstructorActions(Class<?> realClass, GProject project) {
        View view = View.getView(realClass);
        ArrayList<Action> actions = new ArrayList<Action>();
        ConstructorView[] constructors = view.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            try {
                String prefix;
                WorldInvokeListener invocListener;
                ConstructAction callAction;
                ConstructorView m = constructors[constructors.length - i - 1];
                ViewFilter filter = new ViewFilter(131073);
                if (!filter.accept((MemberView)m) || (callAction = new ConstructAction(m, (InvokeListener)(invocListener = new WorldInvokeListener(realClass, GreenfootMain.getInstance().getFrame(), project)), (prefix = "new ") + m.getLongDesc())) == null) continue;
                actions.add((Action)callAction);
                continue;
            }
            catch (Exception e) {
                Debug.reportError((String)("Exception accessing methods: " + e));
                e.printStackTrace();
            }
        }
        return actions;
    }

    public JPopupMenu createPopupMenu(ClassBrowser classBrowser, ClassView classView) {
        GClass gClass = classView.getGClass();
        JPopupMenu popupMenu = new JPopupMenu();
        GProject project = null;
        try {
            project = gClass.getPackage().getProject();
        }
        catch (ProjectNotOpenException pnoe) {
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        Class realClass = gClass.getJavaClass();
        if (realClass != null) {
            WorldInvokeListener invocListener;
            if (!Modifier.isAbstract(realClass.getModifiers())) {
                List<Action> constructorItems = this.createConstructorActions(realClass, project);
                boolean hasEntries = false;
                for (Action callAction : constructorItems) {
                    JMenuItem item = popupMenu.add(callAction);
                    item.setFont(PrefMgr.getPopupMenuFont());
                    hasEntries = true;
                }
                if (hasEntries) {
                    popupMenu.addSeparator();
                }
            }
            ViewFilter filter = new ViewFilter(9);
            View view = View.getView((Class)realClass);
            MethodView[] allMethods = view.getAllMethods();
            if (bluej.pkgmgr.target.role.ClassRole.createMenuItems((JPopupMenu)popupMenu, (CallableView[])allMethods, (ViewFilter)filter, (int)0, (int)allMethods.length, (String)"", (InvokeListener)(invocListener = new WorldInvokeListener(realClass, GreenfootMain.getInstance().getFrame(), project)))) {
                popupMenu.addSeparator();
            }
        }
        popupMenu.add(this.createMenuItem(new EditClassAction(classBrowser)));
        this.addPopupMenuItems(popupMenu, classView.isCoreClass());
        if (classView.getRealClass() != null) {
            popupMenu.add(this.createMenuItem(new InspectClassAction(new LocalClass(classView.getRealClass()), null, classBrowser.getFrame(), classBrowser.getFrame())));
        }
        if (!classView.isCoreClass()) {
            popupMenu.add(this.createMenuItem(new RemoveClassAction(classView, classBrowser.getFrame())));
        }
        popupMenu.addSeparator();
        popupMenu.add(this.createMenuItem(new NewSubclassAction(classView, classBrowser)));
        return popupMenu;
    }

    protected JMenuItem createMenuItem(Action action) {
        JMenuItem item = new JMenuItem(action);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(this.envOpColour);
        return item;
    }

    public void addPopupMenuItems(JPopupMenu menu, boolean coreClass) {
    }

    @Override
    public void worldCreated(WorldEvent e) {
    }

    @Override
    public void worldRemoved(WorldEvent e) {
    }

    public abstract void remove();
}

