/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser.role;

import bluej.Config;
import greenfoot.actions.SelectImageAction;
import greenfoot.core.GProject;
import greenfoot.event.WorldEvent;
import greenfoot.gui.classbrowser.role.ImageClassRole;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorClassRole
extends ImageClassRole {
    protected final Color envOpColour = Config.getItemColour((String)"colour.menu.environOp");
    private String template = "actorclass.tmpl";
    private static final String newline = System.getProperty("line.separator");
    public static final String imports = "import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)" + newline;
    private List<Action> constructorItems = new ArrayList<Action>();
    private boolean enableConstrutors = false;

    public ActorClassRole(GProject project) {
        super(project);
    }

    public List<Action> createConstructorActions(Class realClass, GProject project) {
        List<Action> realActions = super.createConstructorActions(realClass, project);
        this.constructorItems = new ArrayList<Action>();
        for (Action realAction : realActions) {
            Action tempAction = this.createDragProxyAction(realAction);
            tempAction.setEnabled(this.enableConstrutors);
            this.constructorItems.add(tempAction);
        }
        return this.constructorItems;
    }

    @Override
    public void addPopupMenuItems(JPopupMenu menu, boolean coreClass) {
        if (!coreClass) {
            menu.add(this.createMenuItem(new SelectImageAction(this.classView, this)));
        }
    }

    @Override
    public String getTemplateFileName() {
        return this.template;
    }

    @Override
    public void worldCreated(WorldEvent e) {
        this.enableConstrutors = true;
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                for (Action action : ActorClassRole.this.constructorItems) {
                    action.setEnabled(true);
                }
            }
        });
    }

    @Override
    public void worldRemoved(WorldEvent e) {
        this.enableConstrutors = false;
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                for (Action action : ActorClassRole.this.constructorItems) {
                    action.setEnabled(false);
                }
            }
        });
    }
}

