/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser;

import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.Utility;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.WorldHandler;
import greenfoot.event.ActorInstantiationListener;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.Selectable;
import greenfoot.gui.classbrowser.SelectionListener;
import greenfoot.gui.classbrowser.role.ActorClassRole;
import greenfoot.gui.classbrowser.role.ClassRole;
import greenfoot.gui.classbrowser.role.NormalClassRole;
import greenfoot.gui.classbrowser.role.WorldClassRole;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;

public class ClassView
extends JToggleButton
implements Selectable,
MouseListener {
    private final Color classColour = new Color(245, 204, 155);
    private static final Color stripeColor = new Color(152, 152, 152);
    public static final Color[] shadowColours = new Color[]{new Color(242, 242, 242), new Color(211, 211, 211), new Color(189, 189, 189), new Color(83, 83, 83)};
    private static final int SHADOW = 4;
    private static final int GAP = 2;
    private static final int SELECTED_BORDER = 3;
    private GClass gClass;
    private ClassRole role;
    private ClassBrowser classBrowser;
    private JPopupMenu popupMenu;
    private String superclass;
    private boolean coreClass;

    public ClassView(ClassBrowser classBrowser, GClass gClass) {
        this.coreClass = false;
        this.classBrowser = classBrowser;
        this.init(gClass);
    }

    public ClassView(ClassBrowser classBrowser, GClass gClass, boolean coreClass) {
        this.coreClass = coreClass;
        this.classBrowser = classBrowser;
        this.init(gClass);
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean isCoreClass() {
        return this.coreClass;
    }

    public void updateSuperClass() {
        String superClassGuess = this.gClass.getSuperclassGuess();
        if (superClassGuess == null || superClassGuess.equals(this.superclass)) {
            return;
        }
        this.superclass = this.gClass.getSuperclassGuess();
        if (this.classBrowser != null) {
            this.classBrowser.consolidateLayout(this);
        }
    }

    private ClassRole determineRole(GProject project) {
        ClassRole classRole = null;
        classRole = this.gClass.isActorClass() ? new ActorClassRole(project) : (this.gClass.isWorldClass() ? new WorldClassRole(project) : (this.gClass.isActorSubclass() ? new ActorClassRole(project) : (this.gClass.isWorldSubclass() ? new WorldClassRole(project) : NormalClassRole.getInstance())));
        return classRole;
    }

    private void init(GClass gClass) {
        this.gClass = gClass;
        gClass.setClassView(this);
        this.superclass = gClass.getSuperclassGuess();
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(7, 8, 10, 11));
        Font font = this.getFont();
        font = font.deriveFont(13.0f);
        this.setFont(font);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.update();
    }

    public Class getRealClass() {
        return this.gClass.getJavaClass();
    }

    public GClass getGClass() {
        return this.gClass;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.role.createPopupMenu(this.classBrowser, this);
            this.popupMenu.setInvoker(this);
        }
        return this.popupMenu;
    }

    private void setRole(ClassRole role) {
        WorldHandler.getInstance().removeWorldListener(this.role);
        this.role = role;
        WorldHandler.getInstance().addWorldListener(this.role);
    }

    private void update() {
        this.clearUI();
        this.setRole(this.determineRole(this.classBrowser.getProject()));
        this.role.buildUI(this, this.gClass);
        this.popupMenu = null;
        this.updateSuperClass();
    }

    public void updateView() {
        JRootPane rootPane;
        this.update();
        if (this.classBrowser != null) {
            this.classBrowser.updateLayout();
        }
        if ((rootPane = this.getRootPane()) != null) {
            this.getRootPane().revalidate();
        }
    }

    private void clearUI() {
        this.removeAll();
    }

    public void paintComponent(Graphics g) {
        if (this.gClass != null) {
            this.drawBackground(g);
            super.paintComponent(g);
            this.drawShadow((Graphics2D)g);
            this.drawBorders((Graphics2D)g);
        }
    }

    private void drawBackground(Graphics g) {
        int height = this.getHeight() - 4 - 2;
        int width = this.getWidth() - 4;
        g.setColor(this.classColour);
        g.fillRect(0, 2, width, height);
        if (!this.gClass.isCompiled()) {
            g.setColor(stripeColor);
            Utility.stripeRect((Graphics)g, (int)0, (int)2, (int)width, (int)height, (int)8, (int)3);
            g.setColor(this.classColour);
            g.fillRect(7, 9, width - 14, height - 14);
        }
    }

    protected void drawShadow(Graphics2D g) {
        int height = this.getHeight() - 4;
        int width = this.getWidth() - 4;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width + 4, 2);
        g.fillRect(0, height, 6, height + 4);
        g.fillRect(width, 0, width + 3, 10);
        g.setColor(shadowColours[3]);
        g.drawLine(3, height, width, height);
        g.setColor(shadowColours[2]);
        g.drawLine(4, height + 1, width, height + 1);
        g.drawLine(width + 1, height + 2, width + 1, 5);
        g.setColor(shadowColours[1]);
        g.drawLine(5, height + 2, width + 1, height + 2);
        g.drawLine(width + 2, height + 3, width + 2, 6);
        g.setColor(shadowColours[0]);
        g.drawLine(6, height + 3, width + 2, height + 3);
        g.drawLine(width + 3, height + 3, width + 3, 7);
    }

    protected void drawBorders(Graphics2D g) {
        g.setColor(Color.BLACK);
        int thickness = this.isSelected() ? 3 : 1;
        Utility.drawThickRect((Graphics)g, (int)0, (int)2, (int)(this.getWidth() - 4), (int)(this.getHeight() - 4 - 2 - 1), (int)thickness);
    }

    public ClassRole getRole() {
        return this.role;
    }

    public String getQualifiedClassName() {
        return this.gClass.getQualifiedName();
    }

    public String getClassName() {
        return this.gClass.getName();
    }

    public void select() {
        this.setSelected(true);
        this.fireSelectionChangeEvent();
    }

    public boolean deselect() {
        if (this.isSelected()) {
            this.setSelected(false);
            this.fireSelectionChangeEvent();
            return true;
        }
        return false;
    }

    protected void fireSelectionChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).selectionChange(this);
        }
    }

    public void addSelectionChangeListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public void removeSelectionChangeListener(SelectionListener l) {
        this.listenerList.remove(SelectionListener.class, l);
    }

    public Object createInstance() {
        Class realClass = this.getRealClass();
        try {
            if (realClass == null) {
                return null;
            }
            Constructor constructor = realClass.getConstructor(new Class[0]);
            Object newObject = constructor.newInstance(new Object[0]);
            ActorInstantiationListener invocationListener = GreenfootMain.getInstance().getInvocationListener();
            if (invocationListener != null) {
                invocationListener.localObjectCreated(newObject, LocationTracker.instance().getMouseButtonEvent());
            }
            return newObject;
        }
        catch (LinkageError le) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                StackTraceElement[] strace = cause.getStackTrace();
                for (int i = strace.length; i > 0; --i) {
                    if (!strace[i - 1].getClassName().equals(realClass.getName())) continue;
                    StackTraceElement[] newStrace = new StackTraceElement[i];
                    System.arraycopy(strace, 0, newStrace, 0, i);
                    cause.setStackTrace(newStrace);
                    break;
                }
                cause.printStackTrace();
            }
            e.printStackTrace();
        }
        return null;
    }

    public GClass createSubclass(String className) {
        try {
            GPackage pkg = this.gClass.getPackage().getProject().getDefaultPackage();
            File dir = pkg.getProject().getDir();
            File newJavaFile = new File(dir, className + ".java");
            String superClassName = this.getClassName();
            GreenfootUtil.createSkeleton(className, superClassName, newJavaFile, this.role.getTemplateFileName());
            GClass newClass = pkg.newClass(className);
            newClass.setSuperclassGuess(this.getQualifiedClassName());
            return newClass;
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return null;
    }

    public void nameChanged(String oldName) {
        this.classBrowser.renameClass(this, oldName);
        this.updateView();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && (e.getModifiers() & 0x10) != 0) {
            try {
                this.gClass.edit();
            }
            catch (ProjectNotOpenException e1) {
                e1.printStackTrace();
            }
            catch (PackageNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.select();
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void remove() {
        WorldHandler.getInstance().removeWorldListener(this.role);
        this.role.remove();
        this.classBrowser.removeClass(this);
        try {
            this.gClass.remove();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.gClass = null;
    }

    public String getSuperclassGuess() {
        return this.gClass.getSuperclassGuess();
    }
}

