/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser;

import greenfoot.gui.classbrowser.ClassView;
import greenfoot.util.GreenfootUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassForest {
    private SortedSet<TreeEntry> roots = new TreeSet<TreeEntry>();
    private Map<String, TreeEntry> treeEntryMap = new LinkedHashMap<String, TreeEntry>();

    public Set<TreeEntry> getRoots() {
        return this.roots;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        Iterator iter = this.roots.iterator();
        while (iter.hasNext()) {
            str.append(iter.next());
        }
        return str.toString();
    }

    public synchronized void add(ClassView cls) {
        String name = cls.getClassName();
        TreeEntry entry = new TreeEntry(cls, name);
        this.treeEntryMap.put(name, entry);
    }

    public synchronized boolean remove(ClassView cls) {
        String name = cls.getClassName();
        if (this.treeEntryMap.remove(name) != null) {
            this.rebuild();
            return true;
        }
        return false;
    }

    public synchronized void rename(ClassView cls, String oldName) {
        TreeEntry entry = this.treeEntryMap.remove(oldName);
        if (entry != null) {
            this.treeEntryMap.put(cls.getClassName(), entry);
        }
    }

    public synchronized void rebuild() {
        this.roots = new TreeSet<TreeEntry>();
        Collection<TreeEntry> values = this.treeEntryMap.values();
        for (TreeEntry entry : values) {
            entry.removeChildren();
        }
        for (TreeEntry entry : values) {
            this.addEntryToTree(entry.getData());
        }
    }

    private void addEntryToTree(ClassView clsView) {
        String superName = clsView.getSuperclassGuess();
        TreeEntry child = this.treeEntryMap.get(clsView.getClassName());
        if (superName == null || superName.equals("")) {
            this.roots.add(child);
        } else {
            TreeEntry parent = this.treeEntryMap.get(superName = GreenfootUtil.extractClassName(superName));
            if (parent != null) {
                parent.addChild(child);
            } else {
                this.roots.add(child);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TreeEntry
    implements Comparable<TreeEntry> {
        private List<TreeEntry> children = new ArrayList<TreeEntry>();
        private ClassView data;
        private String key;

        public TreeEntry(ClassView data, String key) {
            this.data = data;
            this.key = key;
        }

        public void addChild(TreeEntry child) {
            this.children.add(child);
        }

        public void removeChildren() {
            this.children.clear();
        }

        public List<TreeEntry> getChildren() {
            return this.children;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            for (TreeEntry element : this.children) {
                str.append(" " + element.toString());
            }
            return this.key + "(" + str + " )";
        }

        private String getKey() {
            return this.key;
        }

        public ClassView getData() {
            return this.data;
        }

        @Override
        public int compareTo(TreeEntry o) {
            String name1 = this.getKey();
            String name2 = o.getKey();
            return name1.compareTo(name2);
        }
    }
}

