/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.GreenfootImage;
import greenfoot.ImageVisitor;
import greenfoot.TreeActorSet;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.gui.DropTarget;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class WorldCanvas
extends JPanel
implements DropTarget,
Scrollable {
    private World world;
    private DropTarget dropTargetListener;
    private Actor dragActor;
    private Point dragLocation;
    private BufferedImage dragImage;

    public WorldCanvas(World world) {
        this.setWorld(world);
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    public void setWorld(World world) {
        this.world = world;
        if (world != null) {
            this.setSize(this.getPreferredSize());
            this.revalidate();
            this.repaint();
        } else {
            this.setSize(0, 0);
        }
    }

    public void paintObjects(Graphics g) {
        TreeActorSet objects = WorldVisitor.getObjectsListInPaintOrder(this.world);
        int paintSeq = 0;
        for (Actor thing : objects) {
            int cellSize = WorldVisitor.getCellSize(this.world);
            GreenfootImage image = ActorVisitor.getDisplayImage(thing);
            if (image == null) continue;
            ActorVisitor.setLastPaintSeqNum(thing, paintSeq++);
            double halfWidth = (double)image.getWidth() / 2.0;
            double halfHeight = (double)image.getHeight() / 2.0;
            double xCenter = (double)(thing.getX() * cellSize) + (double)cellSize / 2.0;
            int paintX = (int)Math.floor(xCenter - halfWidth);
            double yCenter = (double)(thing.getY() * cellSize) + (double)cellSize / 2.0;
            int paintY = (int)Math.floor(yCenter - halfHeight);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldTx = g2.getTransform();
            g2.rotate(Math.toRadians(thing.getRotation()), xCenter, yCenter);
            ImageVisitor.drawImage(image, g, paintX, paintY, this);
            g2.setTransform(oldTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        block12: {
            if (this.world == null) {
                return;
            }
            try {
                if (!this.world.lock.readLock().tryLock(500L, TimeUnit.MILLISECONDS)) break block12;
                try {
                    super.paintComponent(g);
                    this.paintBackground(g);
                    this.paintObjects(g);
                    this.paintDraggedObject(g);
                    WorldVisitor.paintDebug(this.world, g);
                }
                finally {
                    this.world.lock.readLock().unlock();
                    if (this.world.lock.writeLock().tryLock()) {
                        try {
                            this.world.lock.writeLock().newCondition().signalAll();
                        }
                        finally {
                            this.world.lock.writeLock().unlock();
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void paintDraggedObject(Graphics g) {
        if (this.dragImage != null) {
            int x = (int)this.dragLocation.getX();
            int y = (int)this.dragLocation.getY();
            int xCell = WorldVisitor.toCellFloor(this.world, x);
            int yCell = WorldVisitor.toCellFloor(this.world, y);
            int cellSize = WorldVisitor.getCellSize(this.world);
            x = (int)(((double)xCell + 0.5) * (double)cellSize - (double)(this.dragActor.getImage().getWidth() / 2));
            y = (int)(((double)yCell + 0.5) * (double)cellSize - (double)(this.dragActor.getImage().getHeight() / 2));
            g.drawImage(this.dragImage, x, y, null);
        }
    }

    public void paintBackground(Graphics g) {
        GreenfootImage backgroundImage;
        if (this.world != null && (backgroundImage = this.world.getBackground()) != null) {
            if (this.world.isTiled()) {
                this.paintTiledBackground(g, backgroundImage);
            } else {
                ImageVisitor.drawImage(backgroundImage, g, 0, 0, this);
            }
        }
    }

    private void paintTiledBackground(Graphics g, GreenfootImage backgroundImage) {
        if (backgroundImage == null || this.world == null) {
            return;
        }
        int imgWidth = backgroundImage.getWidth();
        int imgHeight = backgroundImage.getHeight();
        int width = WorldVisitor.getWidthInPixels(this.world);
        int height = WorldVisitor.getHeightInPixels(this.world);
        int xTiles = (int)Math.ceil((double)width / (double)imgWidth);
        int yTiles = (int)Math.ceil((double)height / (double)imgHeight);
        for (int x = 0; x < xTiles; ++x) {
            for (int y = 0; y < yTiles; ++y) {
                ImageVisitor.drawImage(backgroundImage, g, x * imgWidth, y * imgHeight, this);
            }
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension size = new Dimension();
        if (this.world != null) {
            size.width = WorldVisitor.getWidthInPixels(this.world);
            size.height = WorldVisitor.getHeightInPixels(this.world);
        }
        return size;
    }

    public void setDropTargetListener(DropTarget dropTargetListener) {
        this.dropTargetListener = dropTargetListener;
    }

    public boolean drop(Object o, Point p) {
        this.clearDragInfo();
        if (this.dropTargetListener != null) {
            return this.dropTargetListener.drop(o, p);
        }
        return false;
    }

    public boolean drag(Object o, Point p) {
        if (o instanceof Actor && ((Actor)o).getWorld() == null) {
            if (!this.getVisibleRect().contains(p)) {
                return false;
            }
            if (o != this.dragActor) {
                this.dragActor = (Actor)o;
                this.dragImage = GreenfootUtil.createDragShadow(this.dragActor.getImage().getAwtImage());
            }
            this.dragLocation = p;
            this.repaint();
            return true;
        }
        if (this.dropTargetListener != null) {
            return this.dropTargetListener.drag(o, p);
        }
        return false;
    }

    public void dragEnded(Object o) {
        this.clearDragInfo();
        if (this.dropTargetListener != null) {
            this.dropTargetListener.dragEnded(o);
        }
    }

    private void clearDragInfo() {
        this.dragLocation = null;
        this.dragActor = null;
        this.dragImage = null;
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int cellSize = this.world.getCellSize();
        double scrollPos = 0.0;
        if (orientation == 0) {
            if (direction < 0) {
                scrollPos = visibleRect.getMinX();
            } else if (direction > 0) {
                scrollPos = visibleRect.getMaxX();
            }
        } else if (direction < 0) {
            scrollPos = visibleRect.getMinY();
        } else if (direction > 0) {
            scrollPos = visibleRect.getMaxY();
        }
        int increment = Math.abs((int)Math.IEEEremainder(scrollPos, cellSize));
        if (increment == 0) {
            increment = cellSize;
        }
        return increment;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

