/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.EscapeDialog;
import greenfoot.core.GPackage;
import greenfoot.event.ValidityEvent;
import greenfoot.event.ValidityListener;
import greenfoot.gui.ClassNameVerifier;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewClassDialog
extends EscapeDialog {
    JTextField classNameTextField;
    private boolean okPressed = false;

    public NewClassDialog(JFrame parent, GPackage pkg) {
        super((Frame)parent, Config.getString((String)"newclass.dialog.title"), true);
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.generalBorder);
        JLabel helpLabel1 = GreenfootUtil.createHelpLabel();
        JLabel helpLabel2 = GreenfootUtil.createHelpLabel();
        helpLabel1.setText(Config.getString((String)"newclass.dialog.help1"));
        helpLabel2.setText(Config.getString((String)"newclass.dialog.help2"));
        helpLabel1.setAlignmentX(0.0f);
        helpLabel2.setAlignmentX(0.0f);
        mainPanel.add(helpLabel1);
        mainPanel.add(helpLabel2);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(GreenfootUtil.createSpacer(1, 10));
        JLabel label = new JLabel(Config.getString((String)"newclass.dialog.className"));
        label.setAlignmentX(0.0f);
        mainPanel.add(label);
        mainPanel.add(Box.createVerticalStrut(4));
        this.classNameTextField = new JTextField();
        this.classNameTextField.setAlignmentX(0.0f);
        Dimension classNameMax = this.classNameTextField.getMaximumSize();
        classNameMax.height = this.classNameTextField.getPreferredSize().height;
        this.classNameTextField.setMaximumSize(classNameMax);
        mainPanel.add(this.classNameTextField);
        final JLabel errorMsgLabel = new JLabel();
        errorMsgLabel.setAlignmentX(0.0f);
        errorMsgLabel.setVisible(false);
        errorMsgLabel.setForeground(Color.RED);
        mainPanel.add(errorMsgLabel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        final JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewClassDialog.this.ok();
            }
        });
        okButton.setEnabled(false);
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.setVerifyInputWhenFocusTarget(false);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewClassDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        buttonPanel.setAlignmentX(0.0f);
        Dimension buttonPanelMax = buttonPanel.getMaximumSize();
        buttonPanelMax.height = buttonPanel.getPreferredSize().height;
        buttonPanel.setMaximumSize(buttonPanelMax);
        ClassNameVerifier classNameVerifier = new ClassNameVerifier(this.classNameTextField, pkg);
        classNameVerifier.addValidityListener(new ValidityListener(){

            public void changedToInvalid(ValidityEvent e) {
                errorMsgLabel.setText(e.getReason());
                errorMsgLabel.setVisible(true);
                okButton.setEnabled(false);
            }

            public void changedToValid(ValidityEvent e) {
                errorMsgLabel.setVisible(false);
                okButton.setEnabled(true);
            }
        });
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(GreenfootUtil.createSpacer(1, 10));
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(buttonPanel);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void ok() {
        this.okPressed = true;
        this.dispose();
    }

    private void cancel() {
        this.okPressed = false;
        this.dispose();
    }

    public String getClassName() {
        return this.classNameTextField.getText();
    }

    public boolean okPressed() {
        return this.okPressed;
    }
}

