/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import greenfoot.util.GraphicsUtilities;
import greenfoot.util.GreenfootUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ImageLibList
extends JList {
    private DefaultListModel listModel = new DefaultListModel();

    public ImageLibList() {
        this.setModel(this.listModel);
        this.setCellRenderer(new MyCellRenderer());
        this.setLayoutOrientation(0);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() >= 2 && ImageLibList.this.getSelectedEntry() != null) {
                    ImageLibList.this.getRootPane().getDefaultButton().doClick();
                }
            }
        });
    }

    public ImageLibList(File directory) {
        this();
        this.setDirectory(directory);
    }

    public void setDirectory(File directory) {
        this.listModel.removeAllElements();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return true;
            }
        };
        File[] imageFiles = directory.listFiles(filter);
        if (imageFiles == null) {
            imageFiles = new File[]{};
        }
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        for (int i = 0; i < imageFiles.length; ++i) {
            try {
                BufferedImage image = ImageIO.read(imageFiles[i]);
                if (image == null) continue;
                Image scaledImage = GreenfootUtil.getScaledImage(image, dpi / 3, dpi / 3);
                ImageIcon icon = new ImageIcon(scaledImage);
                ImageListEntry entry = new ImageListEntry(imageFiles[i], icon);
                this.listModel.addElement(entry);
                continue;
            }
            catch (MalformedURLException mfue) {
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public ImageListEntry getSelectedEntry() {
        return (ImageListEntry)this.getSelectedValue();
    }

    public Dimension getPreferredSize() {
        if (this.getModel().getSize() != 0) {
            return super.getPreferredSize();
        }
        Dimension d = super.getPreferredSize();
        ListCellRenderer<ImageListEntry> renderer = this.getCellRenderer();
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        ImageListEntry fakeEntry = new ImageListEntry(new File("abcdefghijklmnopqrstuvw.jpg"), new ImageIcon(GraphicsUtilities.createCompatibleTranslucentImage(dpi / 3, dpi / 3)));
        Component component = renderer.getListCellRendererComponent(this, fakeEntry, 0, false, false);
        d.width = component.getPreferredSize().width;
        return d;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension d = super.getPreferredScrollableViewportSize();
        d.width = Math.min(d.width, this.getPreferredSize().width);
        return d;
    }

    public static class ImageListEntry {
        public File imageFile;
        public Icon imageIcon;

        private ImageListEntry(File file, Icon icon) {
            this.imageFile = file;
            this.imageIcon = icon;
        }
    }

    private static class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageListEntry entry = (ImageListEntry)value;
            MyCellRenderer item = this;
            item.setText(entry.imageFile.getName());
            item.setIcon(entry.imageIcon);
            if (isSelected) {
                item.setBackground(list.getSelectionBackground());
                item.setForeground(list.getSelectionForeground());
            } else {
                item.setBackground(list.getBackground());
                item.setForeground(list.getForeground());
            }
            item.setEnabled(list.isEnabled());
            item.setFont(list.getFont());
            item.setOpaque(true);
            return this;
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width += 5;
            return d;
        }
    }
}

