/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.GreenfootImage;
import greenfoot.ImageVisitor;
import greenfoot.World;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.WorldHandler;
import greenfoot.event.ValidityEvent;
import greenfoot.event.ValidityListener;
import greenfoot.gui.ClassNameVerifier;
import greenfoot.gui.ImageCategorySelector;
import greenfoot.gui.ImageFilePreview;
import greenfoot.gui.ImageLibList;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.util.GraphicsUtilities;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageLibFrame
extends EscapeDialog
implements ListSelectionListener,
WindowListener {
    private JLabel imageLabel;
    private JLabel imageTextLabel;
    private GClass gclass;
    private Icon defaultIcon;
    private ImageLibList projImageList;
    private ImageLibList greenfootImageList;
    private Action okAction;
    private File selectedImageFile;
    private File projImagesDir;
    public static int OK = 0;
    public static int CANCEL = 1;
    private int result = CANCEL;
    private Image generatedImage;
    private boolean showingGeneratedImage;
    private int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
    private JTextField classNameField;
    private GreenfootImage originalImage;

    public ImageLibFrame(JFrame owner, ClassView classView) {
        super((Frame)owner, Config.getString((String)"imagelib.title") + classView.getClassName(), true);
        this.gclass = classView.getGClass();
        this.generatedImage = this.renderImage();
        if (this.generatedImage != null) {
            this.showingGeneratedImage = true;
            this.defaultIcon = new ImageIcon(GreenfootUtil.getScaledImage(this.generatedImage, this.dpi / 2, this.dpi / 2));
        } else {
            this.showingGeneratedImage = false;
            this.defaultIcon = ImageLibFrame.getPreviewIcon(new File(GreenfootUtil.getGreenfootLogoPath()));
        }
        try {
            this.buildUI(classView.getGClass().getPackage().getProject(), false);
        }
        catch (ProjectNotOpenException pnoe) {
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public ImageLibFrame(JFrame owner, GClass superClass) {
        super((Frame)owner, Config.getString((String)"imagelib.newClass"), true);
        this.defaultIcon = ImageLibFrame.getClassIcon(superClass, ImageLibFrame.getPreviewIcon(new File(GreenfootUtil.getGreenfootLogoPath())));
        this.showingGeneratedImage = false;
        try {
            this.buildUI(superClass.getPackage().getProject(), true);
        }
        catch (ProjectNotOpenException pnoe) {
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    private void buildUI(GProject project, boolean includeClassNameField) {
        this.addWindowListener(this);
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(this.getContentPane(), 1));
        contentPane.setBorder(BlueJTheme.dialogBorder);
        int spacingLarge = 11;
        int spacingSmall = 5;
        this.okAction = this.getOkAction();
        try {
            contentPane.add(this.buildClassDetailsPanel(includeClassNameField, project.getDefaultPackage()));
        }
        catch (ProjectNotOpenException e1) {
            e1.printStackTrace();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        Box imageSelPanels = new Box(0);
        Box piPanel = new Box(1);
        JLabel piLabel = new JLabel(Config.getString((String)"imagelib.projectImages"));
        piLabel.setAlignmentX(0.0f);
        piPanel.add(piLabel);
        JScrollPane jsp = new JScrollPane();
        try {
            File projDir = project.getDir();
            this.projImagesDir = new File(projDir, "images");
            this.projImageList = new ImageLibList(this.projImagesDir);
            jsp.getViewport().setView(this.projImageList);
        }
        catch (ProjectNotOpenException pnoe) {
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        jsp.setBorder(Config.normalBorder);
        jsp.setViewportBorder(BorderFactory.createLineBorder(this.projImageList.getBackground(), 4));
        jsp.setAlignmentX(0.0f);
        piPanel.add(jsp);
        imageSelPanels.add(piPanel);
        imageSelPanels.add(GreenfootUtil.createSpacer(0, spacingLarge));
        Box piPanel2 = new Box(1);
        JLabel piLabel2 = new JLabel(Config.getString((String)"imagelib.categories"));
        piLabel2.setAlignmentX(0.0f);
        piPanel2.add(piLabel2);
        File imageDir = Config.getGreenfootLibDir();
        imageDir = new File(imageDir, "imagelib");
        ImageCategorySelector imageCategorySelector = new ImageCategorySelector(imageDir);
        JScrollPane jsp2 = new JScrollPane(imageCategorySelector);
        jsp2.setBorder(Config.normalBorder);
        jsp2.setViewportBorder(BorderFactory.createLineBorder(imageCategorySelector.getBackground(), 4));
        jsp2.setAlignmentX(0.0f);
        piPanel2.add(jsp2);
        imageSelPanels.add(piPanel2);
        imageSelPanels.add(GreenfootUtil.createSpacer(0, spacingSmall));
        piPanel2 = new Box(1);
        piLabel2 = new JLabel(Config.getString((String)"imagelib.images"));
        piLabel2.setAlignmentX(0.0f);
        piPanel2.add(piLabel2);
        JScrollPane jsp3 = new JScrollPane();
        this.greenfootImageList = new ImageLibList();
        jsp3.getViewport().setView(this.greenfootImageList);
        jsp3.setBorder(Config.normalBorder);
        jsp3.setViewportBorder(BorderFactory.createLineBorder(this.greenfootImageList.getBackground(), 4));
        jsp3.setAlignmentX(0.0f);
        piPanel2.add(jsp3);
        imageSelPanels.add(piPanel2);
        imageSelPanels.setAlignmentX(0.0f);
        contentPane.add(imageSelPanels);
        this.projImageList.addListSelectionListener(this);
        this.greenfootImageList.addListSelectionListener(this);
        imageCategorySelector.setImageLibList(this.greenfootImageList);
        JButton browseButton = new JButton(Config.getString((String)"imagelib.browse.button"));
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                new ImageFilePreview(chooser);
                int choice = chooser.showDialog((Component)((Object)ImageLibFrame.this), Config.getString((String)"imagelib.choose.button"));
                if (choice == 0) {
                    ImageLibFrame.this.selectImage(chooser.getSelectedFile());
                }
            }
        });
        browseButton.setAlignmentX(0.0f);
        contentPane.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        contentPane.add(ImageLibFrame.fixHeight(browseButton));
        contentPane.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        contentPane.add(ImageLibFrame.fixHeight(new JSeparator()));
        JPanel okCancelPanel = new JPanel();
        okCancelPanel.setLayout(new BoxLayout(okCancelPanel, 0));
        JButton okButton = BlueJTheme.getOkButton();
        okButton.setAction(this.okAction);
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.setVerifyInputWhenFocusTarget(false);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageLibFrame.this.result = CANCEL;
                ImageLibFrame.this.selectedImageFile = null;
                ImageLibFrame.this.restoreOriginalImage();
                ImageLibFrame.this.setVisible(false);
                ImageLibFrame.this.dispose();
            }
        });
        okCancelPanel.add(Box.createHorizontalGlue());
        okCancelPanel.add(okButton);
        okCancelPanel.add(Box.createHorizontalStrut(spacingLarge));
        okCancelPanel.add(cancelButton);
        okCancelPanel.setAlignmentX(0.0f);
        okCancelPanel.validate();
        contentPane.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        contentPane.add(ImageLibFrame.fixHeight(okCancelPanel));
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        DialogManager.centreDialog((JDialog)((Object)this));
        this.setVisible(true);
    }

    private JPanel buildClassDetailsPanel(boolean includeClassNameField, GPackage pkg) {
        JPanel classDetailsPanel = new JPanel();
        classDetailsPanel.setLayout(new BoxLayout(classDetailsPanel, 1));
        int spacingLarge = 11;
        int spacingSmall = 5;
        JPanel currentImagePanel = new JPanel();
        currentImagePanel.setLayout(new BoxLayout(currentImagePanel, 0));
        if (includeClassNameField) {
            Box b = new Box(0);
            JLabel classNameLabel = new JLabel(Config.getString((String)"imagelib.className"));
            b.add(classNameLabel);
            this.okAction.setEnabled(false);
            this.classNameField = new JTextField(12);
            final JLabel errorMsgLabel = new JLabel();
            errorMsgLabel.setVisible(false);
            errorMsgLabel.setForeground(Color.RED);
            ClassNameVerifier classNameVerifier = new ClassNameVerifier(this.classNameField, pkg);
            classNameVerifier.addValidityListener(new ValidityListener(){

                public void changedToInvalid(ValidityEvent e) {
                    errorMsgLabel.setText(e.getReason());
                    errorMsgLabel.setVisible(true);
                    ImageLibFrame.this.okAction.setEnabled(false);
                }

                public void changedToValid(ValidityEvent e) {
                    errorMsgLabel.setVisible(false);
                    ImageLibFrame.this.okAction.setEnabled(true);
                }
            });
            b.add(Box.createHorizontalStrut(spacingLarge));
            b.add(ImageLibFrame.fixHeight(this.classNameField));
            b.setAlignmentX(0.0f);
            classDetailsPanel.add(b);
            classDetailsPanel.add(errorMsgLabel);
            classDetailsPanel.add(Box.createVerticalStrut(spacingLarge));
        }
        JLabel helpLabel = new JLabel();
        if (this.showingGeneratedImage) {
            helpLabel.setText(Config.getString((String)"imagelib.help.autoImage"));
        } else {
            helpLabel.setText(Config.getString((String)"imagelib.help.selectImage"));
        }
        Font smallFont = helpLabel.getFont().deriveFont(2, 11.0f);
        helpLabel.setFont(smallFont);
        classDetailsPanel.add(ImageLibFrame.fixHeight(helpLabel));
        classDetailsPanel.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        classDetailsPanel.add(ImageLibFrame.fixHeight(new JSeparator()));
        classDetailsPanel.add(Box.createVerticalStrut(spacingSmall));
        JLabel classImageLabel = new JLabel(Config.getString((String)"imagelib.newClass.image"));
        currentImagePanel.add(classImageLabel);
        Icon icon = this.showingGeneratedImage ? this.defaultIcon : ImageLibFrame.getClassIcon(this.gclass, this.defaultIcon);
        currentImagePanel.add(Box.createHorizontalStrut(spacingSmall));
        this.imageLabel = new JLabel(icon){

            public boolean isValidateRoot() {
                return true;
            }
        };
        currentImagePanel.add(this.imageLabel);
        currentImagePanel.add(Box.createHorizontalStrut(spacingSmall));
        this.imageTextLabel = new JLabel(){

            public boolean isValidateRoot() {
                return true;
            }
        };
        currentImagePanel.add(this.imageTextLabel);
        if (this.showingGeneratedImage) {
            this.imageTextLabel.setText(Config.getString((String)"imagelib.image.autoGenerated"));
        }
        currentImagePanel.setAlignmentX(0.0f);
        classDetailsPanel.add(ImageLibFrame.fixHeight(currentImagePanel));
        classDetailsPanel.setAlignmentX(0.0f);
        return classDetailsPanel;
    }

    public void valueChanged(ListSelectionEvent lse) {
        Object source = lse.getSource();
        if (!lse.getValueIsAdjusting() && source instanceof ImageLibList) {
            this.imageTextLabel.setText("");
            ImageLibList sourceList = (ImageLibList)source;
            ImageLibList.ImageListEntry ile = sourceList.getSelectedEntry();
            if (ile != null) {
                this.showingGeneratedImage = false;
                File imageFile = ile.imageFile;
                this.selectImage(imageFile);
            }
        }
    }

    private void selectImage(File imageFile) {
        World world;
        this.imageLabel.setIcon(ImageLibFrame.getPreviewIcon(imageFile));
        this.selectedImageFile = imageFile;
        if (this.gclass != null && this.gclass.isWorldSubclass() && (world = WorldHandler.getInstance().getWorld()) != null) {
            if (this.originalImage == null) {
                this.originalImage = world.getBackground();
            }
            world.setBackground(new GreenfootImage(imageFile.toString()));
            WorldHandler.getInstance().repaint();
        }
    }

    private void restoreOriginalImage() {
        World world;
        if (this.originalImage != null && this.gclass != null && this.gclass.isWorldSubclass() && (world = WorldHandler.getInstance().getWorld()) != null) {
            world.setBackground(this.originalImage);
            WorldHandler.getInstance().repaint();
        }
        this.originalImage = null;
    }

    private static Icon getClassIcon(GClass gclass, Icon defaultIcon) {
        String imageName = null;
        if (gclass == null) {
            return defaultIcon;
        }
        while (gclass != null) {
            File imageFile;
            imageName = gclass.getClassProperty("image");
            if (imageName != null && (imageFile = new File(new File("images"), imageName)).canRead()) {
                return ImageLibFrame.getPreviewIcon(imageFile);
            }
            gclass = gclass.getSuperclass();
        }
        return defaultIcon;
    }

    private static Icon getPreviewIcon(File fname) {
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        try {
            BufferedImage bi = ImageIO.read(fname);
            return new ImageIcon(GreenfootUtil.getScaledImage(bi, dpi / 2, dpi / 2));
        }
        catch (IOException ioe) {
            BufferedImage bi = GraphicsUtilities.createCompatibleTranslucentImage(dpi / 2, dpi / 2);
            return new ImageIcon(bi);
        }
    }

    private static Component fixHeight(Component src) {
        Dimension d = src.getMaximumSize();
        d.height = src.getPreferredSize().height;
        src.setMaximumSize(d);
        return src;
    }

    public File getSelectedImageFile() {
        if (this.result == OK) {
            return this.selectedImageFile;
        }
        return null;
    }

    public int getResult() {
        return this.result;
    }

    public String getClassName() {
        return this.classNameField.getText();
    }

    private Image renderImage() {
        Actor so;
        GreenfootImage image;
        Object object = null;
        Class cls = this.gclass.getJavaClass();
        if (cls == null) {
            return null;
        }
        try {
            object = cls.newInstance();
        }
        catch (LinkageError le) {
        }
        catch (InstantiationException e) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Actor && (image = ActorVisitor.getDisplayImage(so = (Actor)object)) != null) {
            int rotation = so.getRotation();
            if (image != null && rotation != 0) {
                BufferedImage bImg = GraphicsUtilities.createCompatibleTranslucentImage(image.getWidth(), image.getHeight());
                Graphics2D g2 = (Graphics2D)bImg.getGraphics();
                double rotateX = (double)image.getWidth() / 2.0;
                double rotateY = (double)image.getHeight() / 2.0;
                g2.rotate(Math.toRadians(so.getRotation()), rotateX, rotateY);
                ImageVisitor.drawImage(image, g2, 0, 0, (ImageObserver)((Object)this));
                return bImg;
            }
            World world = so.getWorld();
            if (world != null) {
                world.removeObject(so);
            }
            try {
                GProject project = this.gclass.getPackage().getProject();
                GreenfootImage classImage = project.getProjectProperties().getImage(this.gclass.getQualifiedName());
                if (ImageVisitor.equal(classImage, image)) {
                    return null;
                }
                return image.getAwtImage();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            catch (ProjectNotOpenException pnoe) {
                // empty catch block
            }
        }
        return null;
    }

    private File writeGeneratedImage() throws IOException {
        int r;
        File imageDir = null;
        try {
            imageDir = this.gclass.getPackage().getProject().getImageDir();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        File f = new File(imageDir, this.gclass.getName() + ".png");
        if (f.exists() && (r = JOptionPane.showOptionDialog((Component)((Object)this), Config.getString((String)"imagelib.write.exists.part1") + f + Config.getString((String)"imagelib.write.exists.part2"), Config.getString((String)"imagelib.write.exists.title"), 2, 2, null, null, null)) != 0) {
            return null;
        }
        ImageIO.write((RenderedImage)((Object)this.generatedImage), "png", new FileOutputStream(f));
        return f;
    }

    private AbstractAction getOkAction() {
        return new AbstractAction(Config.getString((String)"okay")){

            public void actionPerformed(ActionEvent e) {
                ImageLibFrame.this.result = OK;
                if (ImageLibFrame.this.showingGeneratedImage) {
                    try {
                        ImageLibFrame.this.selectedImageFile = ImageLibFrame.this.writeGeneratedImage();
                        if (ImageLibFrame.this.selectedImageFile == null) {
                            return;
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                ImageLibFrame.this.originalImage = null;
                ImageLibFrame.this.setVisible(false);
                ImageLibFrame.this.dispose();
            }
        };
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.restoreOriginalImage();
    }

    public void windowClosing(WindowEvent e) {
        this.restoreOriginalImage();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

