/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.Config;
import greenfoot.util.GraphicsUtilities;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class ImageFilePreview
extends JLabel
implements PropertyChangeListener {
    private ImageIcon blankPreview;

    public ImageFilePreview(JFileChooser chooser) {
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        int width = dpi * 2;
        int height = dpi * 2;
        BufferedImage image = GraphicsUtilities.createCompatibleTranslucentImage(width, height);
        Graphics2D graphics = image.createGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D stringBounds = fontMetrics.getStringBounds(Config.getString((String)"imagelib.file.noPreview"), graphics);
        int ypos = (int)((double)height - stringBounds.getHeight()) / 2 + fontMetrics.getAscent();
        int xpos = (int)((double)width - stringBounds.getWidth()) / 2;
        graphics.setColor(Color.BLACK);
        graphics.drawString(Config.getString((String)"imagelib.file.noPreview"), xpos, ypos);
        this.blankPreview = new ImageIcon(image);
        this.setIcon(this.blankPreview);
        graphics.dispose();
        chooser.addPropertyChangeListener(this);
        chooser.setAccessory(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        boolean update = false;
        String prop = evt.getPropertyName();
        File file = null;
        if ("directoryChanged".equals(prop)) {
            file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            file = (File)evt.getNewValue();
            update = true;
        }
        if (update) {
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            int width = dpi * 2;
            int height = dpi * 2;
            if (file != null) {
                try {
                    BufferedImage image = ImageIO.read(file);
                    if (image != null) {
                        Image scaledImage = GreenfootUtil.getScaledImage(image, width, height);
                        ImageIcon icon = new ImageIcon(scaledImage);
                        this.setIcon(icon);
                    } else {
                        file = null;
                    }
                }
                catch (IOException ioe) {
                    file = null;
                }
            }
            if (file == null) {
                this.setIcon(this.blankPreview);
            }
        }
    }
}

