/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.pkgmgr.Package;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.record.ClassInspectInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import greenfoot.World;
import greenfoot.actions.AboutGreenfootAction;
import greenfoot.actions.CloseProjectAction;
import greenfoot.actions.CompileAllAction;
import greenfoot.actions.ExportProjectAction;
import greenfoot.actions.NewClassAction;
import greenfoot.actions.NewProjectAction;
import greenfoot.actions.OpenProjectAction;
import greenfoot.actions.OpenRecentProjectAction;
import greenfoot.actions.PauseSimulationAction;
import greenfoot.actions.PreferencesAction;
import greenfoot.actions.QuitAction;
import greenfoot.actions.RemoveSelectedClassAction;
import greenfoot.actions.ResetWorldAction;
import greenfoot.actions.RunOnceSimulationAction;
import greenfoot.actions.RunSimulationAction;
import greenfoot.actions.SaveCopyAction;
import greenfoot.actions.SaveProjectAction;
import greenfoot.actions.ShowCopyrightAction;
import greenfoot.actions.ShowReadMeAction;
import greenfoot.actions.ShowWebsiteAction;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.ProjectProperties;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.event.CompileListener;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.CenterLayout;
import greenfoot.gui.ControlPanel;
import greenfoot.gui.DragGlassPane;
import greenfoot.gui.WorldCanvas;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.Selectable;
import greenfoot.gui.classbrowser.SelectionListener;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.gui.inspector.GreenfootClassInspector;
import greenfoot.gui.inspector.GreenfootObjectInspector;
import greenfoot.gui.inspector.GreenfootResultInspector;
import greenfoot.platforms.ide.SimulationDelegateIDE;
import greenfoot.platforms.ide.WorldHandlerDelegateIDE;
import greenfoot.sound.SoundPlayer;
import greenfoot.util.GreenfootUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import rmiextension.wrappers.RBlueJ;
import rmiextension.wrappers.event.RCompileEvent;

public class GreenfootFrame
extends JFrame
implements WindowListener,
CompileListener,
WorldListener,
SelectionListener,
InspectorManager {
    private static final String readMeIconFile = "readme.png";
    private static final String compileIconFile = "compile.png";
    private static final int WORLD_MARGIN = 40;
    private static final int accelModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int shiftAccelModifier = accelModifier | 1;
    private GProject project;
    private Map<DebuggerObject, Inspector> objectInspectors = new HashMap<DebuggerObject, Inspector>();
    private Map<String, Inspector> classInspectors = new HashMap<String, Inspector>();
    private WorldCanvas worldCanvas;
    private WorldHandler worldHandler;
    private WorldHandlerDelegateIDE worldHandlerDelegate;
    private Dimension worldDimensions;
    private ClassBrowser classBrowser;
    private ControlPanel controlPanel;
    private JScrollPane classScrollPane;
    private NewClassAction newClassAction;
    private SaveProjectAction saveProjectAction;
    private SaveCopyAction saveCopyAction;
    private ShowReadMeAction showReadMeAction;
    private ExportProjectAction exportProjectAction;
    private CloseProjectAction closeProjectAction;
    private RemoveSelectedClassAction removeSelectedClassAction;
    private CompileAllAction compileAllAction;
    private JMenu recentProjectsMenu;
    private boolean isClosedProject = true;
    private boolean resizeWhenPossible = false;
    private static GreenfootFrame instance;

    public static GreenfootFrame getGreenfootFrame(RBlueJ blueJ) {
        instance = new GreenfootFrame(blueJ);
        return instance;
    }

    private GreenfootFrame(RBlueJ blueJ) throws HeadlessException {
        super("Greenfoot");
        try {
            if (Config.isWinOS()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        LocationTracker.instance();
        ImageIcon icon = new ImageIcon(GreenfootUtil.getGreenfootLogoPath());
        this.setIconImage(icon.getImage());
        this.makeFrame();
        this.addWindowListener(this);
        this.restoreFrameState();
        this.prepareMacOSApp();
        this.setVisible(true);
        this.worldCanvas.requestFocusInWindow();
        this.worldCanvas.requestFocus();
    }

    private void restoreFrameState() {
        if (this.project == null) {
            this.setBounds(40, 40, 700, 500);
            this.setResizeWhenPossible(true);
            return;
        }
        ProjectProperties projectProperties = this.project.getProjectProperties();
        try {
            int x = projectProperties.getInt("mainWindow.x");
            int y = projectProperties.getInt("mainWindow.y");
            int width = projectProperties.getInt("mainWindow.width");
            int height = projectProperties.getInt("mainWindow.height");
            this.setBounds(x, y, width, height);
            this.setResizeWhenPossible(false);
        }
        catch (NumberFormatException ecx) {
            this.setBounds(40, 40, 700, 500);
            this.setResizeWhenPossible(true);
        }
    }

    private Application prepareMacOSApp() {
        Application macApp = new Application();
        macApp.setEnabledPreferencesMenu(true);
        macApp.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent e) {
                AboutGreenfootAction.getInstance(GreenfootFrame.this).actionPerformed(null);
                e.setHandled(true);
            }

            public void handlePreferences(ApplicationEvent e) {
                PreferencesAction.getInstance().actionPerformed(null);
                e.setHandled(true);
            }

            public void handleQuit(ApplicationEvent e) {
                GreenfootFrame.this.exit();
                e.setHandled(true);
            }
        });
        return macApp;
    }

    public void openProject(GProject project) {
        if (this.isClosedProject) {
            this.project = project;
            this.worldHandlerDelegate.attachProject(project);
            project.addCompileListener(this);
            this.setTitle("Greenfoot: " + project.getName());
            this.enableProjectActions();
            this.worldCanvas.setVisible(true);
            this.buildClassBrowser();
            this.populateClassBrowser(this.classBrowser, project);
            this.classBrowser.setVisible(true);
            this.classScrollPane.setViewportView(this.classBrowser);
            this.restoreFrameState();
            try {
                ProjectProperties props = project.getProjectProperties();
                int initialSpeed = props.getInt("simulation.speed");
                Simulation.getInstance().setSpeed(initialSpeed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            WorldHandler.getInstance().instantiateNewWorld();
            this.worldHandlerDelegate.getWorldTitle().setVisible(true);
            if (this.needsResize()) {
                this.pack();
            }
            this.isClosedProject = false;
        }
    }

    public void closeProject() {
        this.setTitle("Greenfoot: ");
        this.project.removeCompileListener(this);
        this.worldCanvas.setVisible(false);
        this.classBrowser.setVisible(false);
        this.worldHandlerDelegate.getWorldTitle().setVisible(false);
        this.project = null;
        this.enableProjectActions();
        this.repaint();
        this.isClosedProject = true;
    }

    public ClassBrowser getClassBrowser() {
        return this.classBrowser;
    }

    public GProject getProject() {
        return this.project;
    }

    private void makeFrame() {
        this.setDefaultCloseOperation(3);
        this.worldCanvas = new WorldCanvas(null);
        this.worldHandlerDelegate = new WorldHandlerDelegateIDE(this);
        WorldHandler.initialise(this.worldCanvas, this.worldHandlerDelegate);
        this.worldHandler = WorldHandler.getInstance();
        this.worldHandler.addWorldListener(this);
        Simulation.initialize(this.worldHandler, new SimulationDelegateIDE());
        Simulation sim = Simulation.getInstance();
        this.buildClassBrowser();
        this.setupActions();
        this.setJMenuBar(this.buildMenu());
        this.setGlassPane(DragGlassPane.getInstance());
        JPanel centrePanel = new JPanel(new BorderLayout(4, 4));
        JPanel worldPanel = new JPanel(new BorderLayout());
        worldPanel.setBorder(BorderFactory.createEtchedBorder());
        sim.addSimulationListener(new SimulationListener(){

            public void simulationChanged(SimulationEvent e) {
                if (e.getType() == 0) {
                    GreenfootFrame.this.worldCanvas.requestFocusInWindow();
                }
            }
        });
        sim.addSimulationListener(SoundPlayer.getInstance());
        Box borderPanel = new Box(2);
        borderPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        borderPanel.add(this.worldCanvas);
        JPanel canvasPanel = new JPanel(new CenterLayout());
        canvasPanel.add((Component)borderPanel, "Center");
        JScrollPane worldScrollPane = new JScrollPane(canvasPanel);
        worldScrollPane.setOpaque(false);
        worldScrollPane.getViewport().setOpaque(false);
        worldScrollPane.setBorder(null);
        worldPanel.add(this.worldHandlerDelegate.getWorldTitle(), "North");
        worldPanel.add((Component)worldScrollPane, "Center");
        centrePanel.add((Component)worldPanel, "Center");
        this.controlPanel = new ControlPanel(sim, true);
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        centrePanel.add((Component)this.controlPanel, "South");
        JPanel eastPanel = new JPanel(new BorderLayout(12, 12));
        JButton readMeButton = GreenfootUtil.createButton(this.showReadMeAction);
        readMeButton.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(readMeIconFile)));
        eastPanel.add((Component)readMeButton, "North");
        this.classScrollPane = new JScrollPane(this.classBrowser);
        this.classScrollPane.setOpaque(false);
        this.classScrollPane.getViewport().setOpaque(false);
        this.classScrollPane.setBorder(BorderFactory.createEtchedBorder());
        eastPanel.add((Component)this.classScrollPane, "Center");
        JButton button = GreenfootUtil.createButton(this.compileAllAction);
        button.setFocusable(false);
        button.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(compileIconFile)));
        eastPanel.add((Component)button, "South");
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BorderLayout(12, 12));
        contentPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        contentPane.add((Component)centrePanel, "Center");
        contentPane.add((Component)eastPanel, "East");
        this.pack();
        this.worldDimensions = this.worldCanvas.getPreferredSize();
    }

    public void pack() {
        super.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        boolean change = false;
        if (width > this.getMaximumSize().width) {
            width = this.getMaximumSize().width;
            change = true;
        }
        if (height > this.getMaximumSize().height) {
            height = this.getMaximumSize().height;
            change = true;
        }
        if (change) {
            this.setSize(width, height);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.setSize(dim.width + 40, dim.height + 40);
        return dim;
    }

    private void buildClassBrowser() {
        this.classBrowser = new ClassBrowser(this.project, this);
        this.classBrowser.getSelectionManager().addSelectionChangeListener(this);
        DragGlassPane.getInstance().setSelectionManager(this.classBrowser.getSelectionManager());
    }

    private void populateClassBrowser(ClassBrowser classBrowser, GProject project) {
        if (project != null) {
            try {
                GClass gClass;
                int i;
                GPackage pkg = project.getDefaultPackage();
                GClass[] classes = pkg.getClasses();
                GPackage sysPkg = project.getGreenfootPackage();
                if (sysPkg == null) {
                    sysPkg = project.newPackage("greenfoot");
                }
                GClass[] gClasses = sysPkg.getClasses();
                for (i = 0; i < gClasses.length; ++i) {
                    gClass = gClasses[i];
                    classBrowser.quickAddClass(new ClassView(classBrowser, gClass, true));
                }
                for (i = 0; i < classes.length; ++i) {
                    gClass = classes[i];
                    classBrowser.quickAddClass(new ClassView(classBrowser, gClass));
                }
                classBrowser.updateLayout();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private void setupActions() {
        this.newClassAction = new NewClassAction(this);
        this.saveProjectAction = new SaveProjectAction(this);
        this.saveCopyAction = new SaveCopyAction(this);
        this.showReadMeAction = new ShowReadMeAction(this);
        this.exportProjectAction = new ExportProjectAction(this);
        this.closeProjectAction = new CloseProjectAction(this);
        this.removeSelectedClassAction = new RemoveSelectedClassAction(this);
        this.removeSelectedClassAction.setEnabled(false);
        this.compileAllAction = new CompileAllAction(this.project);
    }

    private JMenuBar buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu projectMenu = this.addMenu(Config.getString((String)"menu.scenario"), menuBar, 's');
        this.addMenuItem(NewProjectAction.getInstance(), projectMenu, -1, false, 78);
        this.addMenuItem(OpenProjectAction.getInstance(), projectMenu, 79, false, 79);
        this.recentProjectsMenu = new JMenu(Config.getString((String)"menu.openRecent"));
        projectMenu.add(this.recentProjectsMenu);
        this.updateRecentProjects();
        this.addMenuItem(this.closeProjectAction, projectMenu, 87, false, 67);
        this.addMenuItem(this.saveProjectAction, projectMenu, 83, false, 83);
        this.addMenuItem(this.saveCopyAction, projectMenu, -1, false, -1);
        projectMenu.addSeparator();
        this.addMenuItem(this.exportProjectAction, projectMenu, 69, false, 69);
        if (!Config.isMacOS()) {
            projectMenu.addSeparator();
            this.addMenuItem(QuitAction.getInstance(), projectMenu, 81, false, 81);
        }
        JMenu editMenu = this.addMenu(Config.getString((String)"menu.edit"), menuBar, 'e');
        this.addMenuItem(this.newClassAction, editMenu, 78, false, 78);
        this.addMenuItem(this.removeSelectedClassAction, editMenu, 68, false, 82);
        JMenu ctrlMenu = this.addMenu(Config.getString((String)"menu.controls"), menuBar, 'c');
        this.addMenuItem(RunOnceSimulationAction.getInstance(), ctrlMenu, 65, false, 65);
        this.addMenuItem(RunSimulationAction.getInstance(), ctrlMenu, 82, false, 82);
        this.addMenuItem(PauseSimulationAction.getInstance(), ctrlMenu, 82, true, 80);
        this.addMenuItem(ResetWorldAction.getInstance(), ctrlMenu, 84, false, 84);
        ctrlMenu.addSeparator();
        this.addMenuItem(this.compileAllAction, ctrlMenu, 75, false, -1);
        JMenu helpMenu = this.addMenu(Config.getString((String)"menu.help"), menuBar, 'h');
        if (!Config.isMacOS()) {
            this.addMenuItem(AboutGreenfootAction.getInstance(this), helpMenu, -1, false, 65);
        }
        this.addMenuItem(ShowCopyrightAction.getInstance(this), helpMenu, -1, false, -1);
        helpMenu.addSeparator();
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.classDoc"), Config.getPropString((String)"greenfoot.url.javadoc")), helpMenu, -1, false, -1);
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.javadoc"), Config.getPropString((String)"greenfoot.url.javaStdLib")), helpMenu, -1, false, -1);
        helpMenu.addSeparator();
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.tutorial"), Config.getPropString((String)"greenfoot.url.tutorial")), helpMenu, -1, false, -1);
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.website"), Config.getPropString((String)"greenfoot.url.greenfoot")), helpMenu, -1, false, -1);
        this.addMenuItem(new ShowWebsiteAction(Config.getString((String)"menu.help.moreScenarios"), Config.getPropString((String)"greenfoot.url.scenarios")), helpMenu, -1, false, -1);
        helpMenu.addSeparator();
        this.addMenuItem(new ShowWebsiteAction(Config.getPropString((String)"greenfoot.gameserver.name"), Config.getPropString((String)"greenfoot.gameserver.address")), helpMenu, -1, false, -1);
        return menuBar;
    }

    private JMenu addMenu(String name, JMenuBar menubar, char mnemonic) {
        JMenu menu = new JMenu(name);
        if (!Config.isMacOS()) {
            menu.setMnemonic(mnemonic);
        }
        menubar.add(menu);
        return menu;
    }

    private void addMenuItem(Action action, JMenu menu, int accelKey, boolean shift, int mnemonicKey) {
        if (accelKey != -1) {
            if (shift) {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelKey, shiftAccelModifier));
            } else {
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelKey, accelModifier));
            }
        }
        if (!Config.isMacOS() && mnemonicKey != -1) {
            action.putValue("MnemonicKey", new Integer(mnemonicKey));
        }
        menu.add(action);
    }

    private void updateRecentProjects() {
        List projects = PrefMgr.getRecentProjects();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            JMenuItem item = new JMenuItem((String)it.next());
            item.addActionListener(OpenRecentProjectAction.getInstance());
            this.recentProjectsMenu.add(item);
        }
    }

    private void enableProjectActions() {
        boolean state = this.project != null;
        this.closeProjectAction.setEnabled(state);
        this.saveProjectAction.setEnabled(state);
        this.saveCopyAction.setEnabled(state);
        this.newClassAction.setEnabled(state);
        this.showReadMeAction.setEnabled(state);
        this.exportProjectAction.setEnabled(state);
        if (!state) {
            WorldHandler.getInstance().discardWorld();
            this.removeSelectedClassAction.setEnabled(false);
        }
        this.compileAllAction.setProject(this.project);
    }

    private void exit() {
        super.dispose();
        GreenfootMain.closeAll();
    }

    public void dispose() {
    }

    public Dimension getMaximumSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    private boolean needsResize() {
        Dimension dim = this.worldCanvas.getPreferredSize();
        if (this.resizeWhenPossible) {
            return true;
        }
        if (this.worldDimensions == null) {
            return false;
        }
        return !dim.equals(this.worldDimensions);
    }

    private void resize() {
        this.setResizeWhenPossible(false);
        this.pack();
    }

    public void setResizeWhenPossible(boolean b) {
        this.worldDimensions = null;
        this.resizeWhenPossible = b;
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        GreenfootMain.closeProject(this, true);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void compileStarted(RCompileEvent event) {
        WorldHandler.getInstance().discardWorld();
    }

    public void compileError(RCompileEvent event) {
    }

    public void compileWarning(RCompileEvent event) {
    }

    public void compileSucceeded(RCompileEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WorldHandler.getInstance().instantiateNewWorld();
                GreenfootFrame.this.classBrowser.repaint();
                GreenfootFrame.this.compileAllAction.setEnabled(GreenfootFrame.this.project != null);
            }
        });
    }

    public void compileFailed(RCompileEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                GreenfootFrame.this.compileAllAction.setEnabled(GreenfootFrame.this.project != null);
            }
        });
    }

    public void worldCreated(WorldEvent e) {
        World newWorld = this.worldHandler.getWorld();
        if (this.needsResize() && newWorld != null) {
            this.resize();
        }
        this.worldDimensions = this.worldCanvas.getPreferredSize();
    }

    public void worldRemoved(WorldEvent e) {
        this.removeAllInspectors();
    }

    public void selectionChange(Selectable source) {
        if (source instanceof ClassView) {
            this.removeSelectedClassAction.setEnabled(true);
        } else {
            this.removeSelectedClassAction.setEnabled(false);
        }
    }

    public ClassInspector getClassInspectorInstance(DebuggerClass clss, Package pkg, JFrame parent) {
        ClassInspector inspector = (ClassInspector)this.classInspectors.get(clss.getName());
        if (inspector == null) {
            ClassInspectInvokerRecord ir = new ClassInspectInvokerRecord(clss.getName());
            inspector = new GreenfootClassInspector(clss, this, pkg, (InvokerRecord)ir, parent);
            this.classInspectors.put(clss.getName(), (Inspector)inspector);
        }
        ClassInspector insp = inspector;
        EventQueue.invokeLater(new Runnable((Inspector)insp){
            final /* synthetic */ Inspector val$insp;
            {
                this.val$insp = inspector;
            }

            public void run() {
                this.val$insp.update();
                this.val$insp.updateLayout();
                this.val$insp.setVisible(true);
                this.val$insp.bringToFront();
            }
        });
        return inspector;
    }

    public ObjectInspector getInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, JFrame parent) {
        ObjectInspector inspector = (ObjectInspector)this.objectInspectors.get(obj);
        if (inspector == null) {
            inspector = new GreenfootObjectInspector(obj, this, name, pkg, ir, parent);
            this.objectInspectors.put(obj, (Inspector)inspector);
        }
        final ObjectInspector insp = inspector;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                insp.update();
                insp.updateLayout();
                insp.setVisible(true);
                insp.bringToFront();
            }
        });
        return inspector;
    }

    public ResultInspector getResultInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, ExpressionInformation info, JFrame parent) {
        ResultInspector inspector = (ResultInspector)this.objectInspectors.get(obj);
        if (inspector == null) {
            inspector = new GreenfootResultInspector(obj, this, name, pkg, ir, info, parent);
            this.objectInspectors.put(obj, (Inspector)inspector);
        }
        final ResultInspector insp = inspector;
        insp.update();
        insp.updateLayout();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                insp.setVisible(true);
                insp.bringToFront();
            }
        });
        return inspector;
    }

    public boolean inTestMode() {
        return false;
    }

    public void removeInspector(DebuggerClass cls) {
        this.classInspectors.remove(cls.getName());
    }

    public void removeInspector(DebuggerObject obj) {
        this.objectInspectors.remove(obj);
    }

    public void removeAllInspectors() {
        for (Inspector inspector : this.objectInspectors.values()) {
            inspector.setVisible(false);
            inspector.dispose();
        }
        this.objectInspectors.clear();
        for (Inspector inspector : this.classInspectors.values()) {
            inspector.setVisible(false);
            inspector.dispose();
        }
        this.classInspectors.clear();
    }
}

