/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.BlueJTheme;
import bluej.Config;
import greenfoot.gui.WrappingMultiLineLabel;
import greenfoot.util.GreenfootUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FirstStartupDialog
extends JDialog {
    private Result result = Result.WITHOUT;

    public FirstStartupDialog() {
        super((Frame)null, "Greenfoot");
        this.setModal(true);
        this.buildUI();
        this.pack();
    }

    public void buildUI() {
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(BlueJTheme.dialogBorder);
        int spacingLarge = 11;
        int spacingSmall = 5;
        String headerText = Config.getString((String)"startup.header");
        String welcomeText = Config.getString((String)"startup.welcome");
        String questionText = Config.getString((String)"startup.question");
        JLabel headerLabel = new JLabel(headerText);
        Font f = headerLabel.getFont();
        f = f.deriveFont((float)f.getSize() + 4.0f);
        headerLabel.setFont(f);
        WrappingMultiLineLabel welcomeLabel = new WrappingMultiLineLabel(welcomeText, 60);
        JLabel questionLabel = new JLabel(questionText);
        headerLabel.setAlignmentX(0.5f);
        welcomeLabel.setAlignmentX(0.5f);
        questionLabel.setAlignmentX(0.5f);
        contentPane.add(headerLabel);
        contentPane.add(GreenfootUtil.createSpacer(1, spacingSmall));
        contentPane.add((Component)((Object)welcomeLabel));
        contentPane.add(Box.createVerticalGlue());
        contentPane.add(GreenfootUtil.createSpacer(1, spacingLarge));
        contentPane.add(questionLabel);
        contentPane.add(GreenfootUtil.createSpacer(1, spacingSmall));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JButton tutorialButton = new JButton(Config.getString((String)"startup.tutorial.button"));
        JButton openButton = new JButton(Config.getString((String)"startup.open.button"));
        JButton createButton = new JButton(Config.getString((String)"startup.create.button"));
        JButton continueButton = new JButton(Config.getString((String)"startup.continue.button"));
        this.getRootPane().setDefaultButton(tutorialButton);
        tutorialButton.setAlignmentX(0.5f);
        openButton.setAlignmentX(0.5f);
        createButton.setAlignmentX(0.5f);
        continueButton.setAlignmentX(0.5f);
        Dimension bigSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        tutorialButton.setMaximumSize(bigSize);
        openButton.setMaximumSize(bigSize);
        createButton.setMaximumSize(bigSize);
        continueButton.setMaximumSize(bigSize);
        tutorialButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FirstStartupDialog.this.result = Result.TUTORIAL;
                FirstStartupDialog.this.dispose();
            }
        });
        openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FirstStartupDialog.this.result = Result.OPEN;
                FirstStartupDialog.this.dispose();
            }
        });
        createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FirstStartupDialog.this.result = Result.CREATE;
                FirstStartupDialog.this.dispose();
            }
        });
        continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FirstStartupDialog.this.result = Result.WITHOUT;
                FirstStartupDialog.this.dispose();
            }
        });
        buttonPanel.add(tutorialButton);
        buttonPanel.add(GreenfootUtil.createSpacer(1, spacingSmall));
        buttonPanel.add(openButton);
        buttonPanel.add(GreenfootUtil.createSpacer(1, spacingSmall));
        buttonPanel.add(createButton);
        buttonPanel.add(GreenfootUtil.createSpacer(1, spacingSmall));
        buttonPanel.add(continueButton);
        JPanel nonGreedyPanel = new JPanel();
        nonGreedyPanel.add(buttonPanel);
        contentPane.add(nonGreedyPanel);
    }

    public Result getResult() {
        return this.result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        TUTORIAL,
        OPEN,
        CREATE,
        WITHOUT;

    }
}

