/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutGreenfootDialog
extends JDialog {
    private static final String dialogTitle = Config.getString((String)"about.title");

    public AboutGreenfootDialog(JFrame parent, String version) {
        super(parent, dialogTitle, true);
        JPanel aboutPanel = new JPanel();
        aboutPanel.setBorder(BlueJTheme.dialogBorder);
        aboutPanel.setLayout(new BorderLayout(12, 0));
        aboutPanel.setBackground(Color.white);
        URL splashURL = this.getClass().getClassLoader().getResource("greenfoot-about.png");
        ImageIcon icon = new ImageIcon(splashURL);
        JLabel logoLabel = new JLabel(icon);
        aboutPanel.add((Component)logoLabel, "West");
        MultiLineLabel text = new MultiLineLabel(0.0f, 6);
        text.setBackground(Color.white);
        text.addText("The Greenfoot team:\n ", false, true);
        text.addText("      Poul Henriksen\n");
        text.addText("      Michael K\u00f6lling\n");
        text.addText("      Davin McCall\n");
        text.addText("      Bruce Quig\n");
        text.addText("      John Rosenberg\n");
        aboutPanel.add((Component)text, "Center");
        MultiLineLabel bottomtext = new MultiLineLabel(0.0f);
        bottomtext.setBackground(Color.white);
        bottomtext.addText(" ");
        bottomtext.addText("Greenfoot version " + version + "  (" + Config.getString((String)"about.java.version") + " " + System.getProperty("java.version") + ")", true, false);
        bottomtext.addText(" ");
        bottomtext.addText(Config.getString((String)"about.vm") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
        bottomtext.addText(Config.getString((String)"about.runningOn") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        bottomtext.addText(Config.getString((String)"about.javahome") + " " + System.getProperty("java.home"));
        bottomtext.addText(" ");
        bottomtext.addText(Config.getString((String)"about.moreInfo"));
        bottomtext.addText(" ");
        bottomtext.addText(Config.getString((String)"about.logfile") + " " + Config.getUserConfigFile((String)"greenfoot-debuglog.txt"));
        aboutPanel.add((Component)bottomtext, "South");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton ok = BlueJTheme.getOkButton();
        buttonPanel.add(ok);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)aboutPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AboutGreenfootDialog.this.setVisible(false);
                AboutGreenfootDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Window win = (Window)event.getSource();
                win.setVisible(false);
                win.dispose();
            }
        });
        this.setResizable(false);
        this.pack();
        DialogManager.centreDialog((JDialog)this);
    }
}

