/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import greenfoot.core.ProjectProperties;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioInfo {
    private String title;
    private String shortDescription;
    private String longDescription;
    private List<String> tags;
    private String url;
    private boolean hasSource;
    private boolean isLocked;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setShortDescription(String shortDesc) {
        this.shortDescription = shortDesc;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setLongDescription(String longDesc) {
        this.longDescription = longDesc;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setHasSource(boolean hasSource) {
        this.hasSource = hasSource;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public boolean getHasSource() {
        return this.hasSource;
    }

    public void store(ProjectProperties properties) {
        properties.setString("publish.title", this.getTitle());
        properties.setString("publish.shortDesc", this.getShortDescription());
        properties.setString("publish.longDesc", this.getLongDescription());
        properties.setString("publish.url", this.getUrl());
        properties.setString("publish.tags", this.getTagsAsString());
        properties.setBoolean("publish.hasSource", this.getHasSource());
        properties.setBoolean("publish.locked", this.isLocked());
    }

    private String getTagsAsString() {
        StringBuilder tags = new StringBuilder();
        List<String> tagList = this.getTags();
        for (String tag : tagList) {
            tags.append(tag);
            tags.append(" ");
        }
        return tags.toString();
    }

    public boolean load(ProjectProperties properties) {
        try {
            properties.getBoolean("publish.hasSource");
        }
        catch (NullPointerException e) {
            return false;
        }
        this.setTitle(properties.getString("publish.title"));
        this.setShortDescription(properties.getString("publish.shortDesc"));
        this.setLongDescription(properties.getString("publish.longDesc"));
        this.setUrl(properties.getString("publish.url"));
        String tags = properties.getString("publish.tags");
        String[] tagArray = tags.split(" ");
        LinkedList<String> tagList = new LinkedList<String>();
        for (int i = 0; i < tagArray.length; ++i) {
            String string = tagArray[i];
            tagList.add(string);
        }
        this.setTags(tagList);
        this.setHasSource(properties.getBoolean("publish.hasSource"));
        this.setLocked(properties.getBoolean("publish.locked"));
        return true;
    }
}

