/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import bluej.Config;
import greenfoot.export.mygame.ProgressTrackingPart;
import greenfoot.export.mygame.ScenarioInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MyGameClient {
    public MyGameClient() {
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.NoOpLog");
    }

    public final MyGameClient submit(String hostAddress, String uid, String password, String jarFileName, File sourceFile, File screenshotFile, int width, int height, ScenarioInfo info) throws UnknownHostException, IOException {
        String gameName = info.getTitle();
        String shortDescription = info.getShortDescription();
        String longDescription = info.getLongDescription();
        String gameUrl = info.getUrl();
        HttpClient httpClient = this.getHttpClient();
        PostMethod postMethod = new PostMethod(hostAddress + "account/authenticate");
        postMethod.addParameter("user[username]", uid);
        postMethod.addParameter("user[password]", password);
        int response = httpClient.executeMethod((HttpMethod)postMethod);
        if (response == 407) {
            // empty if block
        }
        if (response > 400) {
            this.error("Unrecognized response from the server: " + response);
            return this;
        }
        if (!this.handleResponse(postMethod)) {
            return this;
        }
        List<String> tagsList = info.getTags();
        boolean hasSource = sourceFile != null;
        Part[] parts = new Part[9 + tagsList.size() + (hasSource ? 1 : 0)];
        parts[0] = new StringPart("scenario[title]", gameName);
        parts[1] = new StringPart("scenario[main_class]", "greenfoot.export.GreenfootScenarioViewer");
        parts[2] = new StringPart("scenario[width]", "" + width);
        parts[3] = new StringPart("scenario[height]", "" + height);
        parts[4] = new StringPart("scenario[short_description]", shortDescription);
        parts[5] = new StringPart("scenario[long_description]", longDescription);
        parts[6] = new StringPart("scenario[url]", gameUrl);
        parts[7] = new ProgressTrackingPart("scenario[uploaded_data]", new File(jarFileName), this);
        parts[8] = new ProgressTrackingPart("scenario[screenshot_data]", screenshotFile, this);
        int tagindex = 9;
        if (hasSource) {
            parts[9] = new ProgressTrackingPart("scenario[source_data]", sourceFile, this);
            tagindex = 10;
        }
        int tagNum = 0;
        Iterator<String> i = tagsList.iterator();
        while (i.hasNext()) {
            parts[tagindex++] = new StringPart("scenario[tag" + tagNum++ + "]", i.next());
        }
        postMethod = new PostMethod(hostAddress + "upload-scenario");
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
        response = httpClient.executeMethod((HttpMethod)postMethod);
        if (response > 400) {
            this.error("Unrecognized response from the server: " + response);
            return this;
        }
        if (!this.handleResponse(postMethod)) {
            return this;
        }
        this.status("Upload complete.");
        return this;
    }

    private boolean handleResponse(PostMethod postMethod) throws NumberFormatException {
        Header statusHeader = postMethod.getResponseHeader("X-mygame-status");
        if (statusHeader == null) {
            this.error("Unrecognized response from the server.");
            return false;
        }
        String responseString = statusHeader.getValue();
        int statusCode = Integer.parseInt(responseString.substring(0, responseString.indexOf(" ")));
        switch (statusCode) {
            case 0: {
                return true;
            }
            case 1: {
                this.error("Invalid username or password");
                return false;
            }
            case 2: {
                this.error("The scenario is too large");
                return false;
            }
        }
        this.error(responseString);
        return false;
    }

    protected HttpClient getHttpClient() {
        HttpClient httpClient = new HttpClient();
        String proxyHost = Config.getPropString((String)"proxy.host", null);
        String proxyPortStr = Config.getPropString((String)"proxy.port", null);
        if (proxyHost != null && proxyHost.length() != 0 && proxyPortStr != null) {
            HostConfiguration hostConfig = httpClient.getHostConfiguration();
            int proxyPort = 80;
            try {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            hostConfig.setProxy(proxyHost, proxyPort);
            String proxyUser = Config.getPropString((String)"proxy.user", null);
            String proxyPass = Config.getPropString((String)"proxy.password", null);
            if (proxyUser != null) {
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUser, proxyPass);
                httpClient.getState().setProxyCredentials(authScope, (Credentials)proxyCreds);
            }
        }
        return httpClient;
    }

    public boolean checkExistingScenario(String hostAddress, String uid, String gameName, ScenarioInfo info) throws UnknownHostException, IOException, InterruptedException {
        HttpClient client = this.getHttpClient();
        String encodedName = URLEncoder.encode(gameName, "UTF-8");
        encodedName = encodedName.replace("+", "%20");
        GetMethod getMethod = new GetMethod(hostAddress + "user/" + uid + "/check_scenario/" + encodedName);
        int response = client.executeMethod((HttpMethod)getMethod);
        if (response > 400) {
            throw new IOException("HTTP error response " + response + " from server.");
        }
        Header statusHeader = getMethod.getResponseHeader("X-mygame-scenario");
        if (statusHeader == null) {
            throw new IOException("X-mygame-scenario header missing from server response");
        }
        if (!statusHeader.getValue().equals("0 FOUND")) {
            return false;
        }
        if (info != null) {
            InputStream responseStream = getMethod.getResponseBodyAsStream();
            this.parseScenarioXml(info, responseStream);
            info.setTitle(gameName);
        }
        return true;
    }

    private void parseScenarioXml(ScenarioInfo info, InputStream xmlStream) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            Document doc = dbuilder.parse(xmlStream);
            Element root = doc.getDocumentElement();
            if (root == null || !root.getTagName().equals("scenario")) {
                return;
            }
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() != 1) continue;
                Element element = (Element)childNode;
                if (element.getTagName().equals("shortdescription")) {
                    info.setShortDescription(element.getTextContent());
                    continue;
                }
                if (element.getTagName().equals("longdescription")) {
                    info.setLongDescription(element.getTextContent());
                    continue;
                }
                if (element.getTagName().equals("taglist")) {
                    info.setTags(this.parseTagListXmlElement(element));
                    continue;
                }
                if (element.getTagName().equals("webpage")) {
                    info.setUrl(element.getTextContent());
                    continue;
                }
                if (!element.getTagName().equals("hassource")) continue;
                info.setHasSource(element.getTextContent().equals("true"));
            }
        }
        catch (ParserConfigurationException pce) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private List<String> parseTagListXmlElement(Element element) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals("tag")) continue;
            tags.add(element.getTextContent());
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCommonTags(String hostAddress, int maxNumberOfTags) throws UnknownHostException, IOException {
        GetMethod getMethod;
        HttpClient client = this.getHttpClient();
        int response = client.executeMethod((HttpMethod)(getMethod = new GetMethod(hostAddress + "common-tags/" + maxNumberOfTags)));
        if (response > 400) {
            throw new IOException("HTTP error response " + response + " from server.");
        }
        InputStream responseStream = getMethod.getResponseBodyAsStream();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            Document doc = dbuilder.parse(responseStream);
            Element root = doc.getDocumentElement();
            if (root == null || !root.getTagName().equals("taglist")) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = this.parseTagListXmlElement(root);
            return list;
        }
        catch (SAXException saxe) {
        }
        catch (ParserConfigurationException pce) {
        }
        finally {
            responseStream.close();
        }
        return Collections.emptyList();
    }

    public abstract void error(String var1);

    public abstract void status(String var1);

    public abstract void progress(int var1);
}

