/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.FileUtility;
import greenfoot.core.GProject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarCreator {
    private static final String SOURCE_SUFFIX = ".java";
    private boolean includeSource;
    private String mainClass;
    private File exportDir;
    private File projectDir;
    private String jarName;
    private List<File> extraJars = new LinkedList<File>();
    private List<File> dirs = new LinkedList<File>();
    private List<String> skipDirs = new LinkedList<String>();
    private List<String> skipFiles = new LinkedList<String>();
    private Manifest manifest = new Manifest();
    private Properties properties;
    private boolean isZip = false;

    public JarCreator(File exportDir, String jarName) {
        if (!exportDir.canWrite()) {
            throw new IllegalArgumentException("exportDir not writable: " + exportDir);
        }
        this.exportDir = exportDir;
        this.jarName = jarName;
        this.properties = new Properties();
    }

    public JarCreator(GProject project, File exportDir, String jarName, String worldClass, boolean lockScenario) {
        this(exportDir, jarName);
        try {
            this.projectDir = project.getDir();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        String scenarioName = project.getName();
        this.addDir(this.projectDir);
        File libDir = Config.getGreenfootLibDir();
        File greenfootDir = new File(libDir, "standalone");
        this.addDir(greenfootDir);
        this.addSkipDir("CVS");
        this.addSkipFile(".cvsignore");
        this.addSkipDir(".svn");
        this.addSkipFile(".DS_Store");
        this.addSkipDir(this.projectDir.getPath() + System.getProperty("file.separator") + "doc");
        this.addSkipDir(exportDir.getAbsolutePath().toString());
        this.addSkipDir(this.projectDir.getPath() + System.getProperty("file.separator") + "greenfoot");
        this.addSkipFile(".ctxt");
        this.addSkipFile("bluej.pkg");
        this.addSkipFile("bluej.pkh");
        this.addSkipDir("+libs");
        String mainClass = "greenfoot.export.GreenfootScenarioViewer";
        this.setMainClass(mainClass);
        this.properties.put("project.name", scenarioName);
        this.properties.put("main.class", worldClass);
        this.properties.put("scenario.lock", "" + lockScenario);
        this.properties.put("scenario.viewer.appletInfo", Config.getString((String)"scenario.viewer.appletInfo"));
        this.properties.put("run.once", Config.getString((String)"run.once"));
        this.properties.put("run.simulation", Config.getString((String)"run.simulation"));
        this.properties.put("pause.simulation", Config.getString((String)"pause.simulation"));
        this.properties.put("reset.world", Config.getString((String)"reset.world"));
        this.properties.put("controls.speed.label", Config.getString((String)"controls.speed.label"));
        this.properties.put("controls.runonce.longDescription", Config.getString((String)"controls.runonce.longDescription"));
        this.properties.put("controls.runonce.shortDescription", Config.getString((String)"controls.runonce.shortDescription"));
        this.properties.put("controls.run.longDescription", Config.getString((String)"controls.run.longDescription"));
        this.properties.put("controls.run.shortDescription", Config.getString((String)"controls.run.shortDescription"));
        this.properties.put("controls.pause.longDescription", Config.getString((String)"controls.pause.longDescription"));
        this.properties.put("controls.pause.shortDescription", Config.getString((String)"controls.pause.shortDescription"));
        this.properties.put("controls.run.button", Config.getString((String)"controls.run.button"));
        this.properties.put("controls.pause.button", Config.getString((String)"controls.pause.button"));
        this.properties.put("controls.reset.longDescription", Config.getString((String)"controls.reset.longDescription"));
        this.properties.put("controls.reset.shortDescription", Config.getString((String)"controls.reset.shortDescription"));
        this.properties.put("controls.speedSlider.tooltip", Config.getString((String)"controls.speedSlider.tooltip"));
    }

    public JarCreator(GProject project, File exportDir, String zipName) {
        this(exportDir, zipName);
        this.isZip = true;
        try {
            this.projectDir = project.getDir();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        String scenarioName = project.getName();
        this.addDir(this.projectDir);
        this.addSkipDir("CVS");
        this.addSkipFile(".cvsignore");
        this.addSkipDir(".svn");
        this.addSkipFile(".DS_Store");
        this.addSkipDir(this.projectDir.getPath() + System.getProperty("file.separator") + "doc");
        this.addSkipDir(exportDir.getAbsolutePath().toString());
        this.addSkipDir(this.projectDir.getPath() + System.getProperty("file.separator") + "greenfoot");
        this.addSkipFile("bluej.pkg");
        this.addSkipFile("bluej.pkh");
        this.includeSource(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        File jarFile = new File(this.exportDir, this.jarName);
        File propertiesFile = null;
        FileOutputStream oStream = null;
        ZipOutputStream jStream = null;
        try {
            oStream = new FileOutputStream(jarFile);
            String pathPrefix = "";
            if (!this.isZip) {
                this.writeManifest();
                propertiesFile = new File(this.projectDir, "standalone.properties");
                this.writePropertiesFile(propertiesFile);
                jStream = new JarOutputStream((OutputStream)oStream, this.manifest);
            } else {
                pathPrefix = this.projectDir.getName() + "/";
                jStream = new ZipOutputStream(oStream);
            }
            for (File dir : this.dirs) {
                this.writeDirToJar(dir, pathPrefix, jStream, jarFile.getCanonicalFile());
            }
            this.copyLibsToJar(this.extraJars, this.exportDir);
        }
        catch (IOException exc) {
            Debug.reportError((String)("problen writing jar file: " + exc));
        }
        finally {
            try {
                if (jStream != null) {
                    jStream.close();
                }
            }
            catch (IOException e) {}
            if (propertiesFile != null) {
                propertiesFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesFile(File file) {
        OutputStream os = null;
        try {
            file.createNewFile();
            os = new FileOutputStream(file);
            this.properties.store(os, "Properties for running Greenfoot scenarios alone.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void putManifestEntry(String key, String value) {
        Attributes attr = this.manifest.getMainAttributes();
        value = this.fixNewlines(value);
        attr.put(new Attributes.Name(key), value);
    }

    private String fixNewlines(String value) {
        StringBuffer buffer = new StringBuffer(value.length());
        String newLineRegExp = "(?m)(?s)$.^";
        String trailingNewLineReqExp = "$.\\z";
        String[] lines = value.split(newLineRegExp + "|" + trailingNewLineReqExp);
        for (int i = 0; i < lines.length; ++i) {
            String string = lines[i];
            if (i != 0) {
                buffer.append("<br>");
            }
            buffer.append(string);
        }
        return buffer.toString();
    }

    private void writeManifest() {
        String classpath = "";
        Iterator<File> it = this.extraJars.iterator();
        while (it.hasNext()) {
            classpath = classpath + " " + it.next().getName();
        }
        Attributes attr = this.manifest.getMainAttributes();
        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attr.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        attr.put(Attributes.Name.CLASS_PATH, classpath);
    }

    public void includeSource(boolean b) {
        this.includeSource = b;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void addJar(File jar) {
        this.extraJars.add(jar);
    }

    public void addDir(File dir) {
        this.dirs.add(dir);
    }

    public void addSkipDir(String dir) {
        this.skipDirs.add(dir);
    }

    public void addSkipFile(String file) {
        this.skipFiles.add(file);
    }

    private void writeDirToJar(File sourceDir, String pathPrefix, ZipOutputStream stream, File outputFile) throws IOException {
        File[] dir = sourceDir.listFiles();
        for (int i = 0; i < dir.length; ++i) {
            if (dir[i].isDirectory()) {
                if (this.skipDir(dir[i])) continue;
                this.writeDirToJar(dir[i], pathPrefix + dir[i].getName() + "/", stream, outputFile);
                continue;
            }
            if (this.skipFile(dir[i].getName(), !this.includeSource) || outputFile.equals(dir[i].getCanonicalFile())) continue;
            this.writeJarEntry(dir[i], stream, pathPrefix + dir[i].getName());
        }
    }

    private void copyLibsToJar(List<File> userLibs, File destDir) {
        for (File lib : userLibs) {
            File destFile = new File(destDir, lib.getName());
            try {
                FileUtility.copyFile((File)lib, (File)destFile);
            }
            catch (IOException e) {
                Debug.reportError((String)("Error when copying file: " + lib + " to: " + destFile), (Exception)e);
            }
        }
    }

    private boolean skipDir(File dir) throws IOException {
        for (String skipDir : this.skipDirs) {
            if (!dir.getCanonicalFile().getPath().endsWith(skipDir)) continue;
            return true;
        }
        return false;
    }

    private boolean skipFile(String fileName, boolean skipSource) {
        for (String skipFile : this.skipFiles) {
            if (!fileName.endsWith(skipFile)) continue;
            return true;
        }
        if (fileName.endsWith(SOURCE_SUFFIX)) {
            return !this.includeSource;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJarEntry(File file, ZipOutputStream stream, String entryName) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            stream.putNextEntry(new ZipEntry(entryName));
            FileUtility.copyStream((InputStream)in, (OutputStream)stream);
        }
        catch (ZipException exc) {
            Debug.message((String)("warning: " + exc));
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public void generateHTMLSkeleton(File outputFile, String title, int width, int height) {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        translations.put("TITLE", title);
        translations.put("CLASSFILE", this.mainClass + ".class");
        translations.put("CODEBASE", "");
        translations.put("APPLETWIDTH", "" + width);
        translations.put("APPLETHEIGHT", "" + height);
        translations.put("ARCHIVE", this.jarName);
        File libDir = Config.getGreenfootLibDir();
        File template = new File(libDir, "templates/html.tmpl");
        try {
            BlueJFileReader.translateFile((File)template, (File)outputFile, translations);
        }
        catch (IOException e) {
            Debug.reportError((String)("Exception during file translation from " + template + " to " + outputFile));
            e.printStackTrace();
        }
    }
}

