/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.BlueJPropStringSource;
import bluej.Config;
import greenfoot.World;
import greenfoot.core.ProjectProperties;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.gui.CenterLayout;
import greenfoot.gui.ControlPanel;
import greenfoot.gui.WorldCanvas;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.platforms.standalone.ActorDelegateStandAlone;
import greenfoot.platforms.standalone.GreenfootUtilDelegateStandAlone;
import greenfoot.platforms.standalone.SimulationDelegateStandAlone;
import greenfoot.platforms.standalone.WorldHandlerDelegateStandAlone;
import greenfoot.sound.SoundPlayer;
import greenfoot.util.GreenfootUtil;
import greenfoot.util.StandalonePropStringManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public class GreenfootScenarioViewer
extends JApplet {
    private static final int EMPTY_BORDER_SIZE = 5;
    private static String scenarioName;
    private ProjectProperties properties;
    private Simulation sim;
    private WorldCanvas canvas;
    private ControlPanel controls;
    private RootPaneContainer rootPaneContainer;
    private Constructor<?> worldConstructor;
    private static String[] args;

    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (args.length != 3 && args.length != 0) {
            System.err.println("Wrong number of arguments");
        }
        GreenfootScenarioViewer.args = args;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame(scenarioName);
                new GreenfootScenarioViewer(frame);
                frame.setDefaultCloseOperation(3);
                frame.setTitle(scenarioName);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public GreenfootScenarioViewer() {
    }

    public GreenfootScenarioViewer(RootPaneContainer rootPane) {
        this.rootPaneContainer = rootPane;
        this.init();
    }

    public static Dimension getControlsBorderSize() {
        return new Dimension(10, 10);
    }

    public static Dimension getWorldBorderSize() {
        return new Dimension(12, 7);
    }

    private void buildGUI() {
        if (this.rootPaneContainer == null) {
            this.rootPaneContainer = this;
        }
        JPanel centerPanel = new JPanel(new CenterLayout());
        centerPanel.add(this.canvas);
        this.canvas.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.controls.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5), BorderFactory.createEtchedBorder()));
        this.rootPaneContainer.getContentPane().add((Component)centerPanel, "Center");
        this.rootPaneContainer.getContentPane().add((Component)this.controls, "South");
    }

    public void init() {
        JRootPane rootPane = this.getRootPane();
        rootPane.putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        String worldClassName = null;
        boolean lockScenario = false;
        Properties p = new Properties();
        try {
            ClassLoader loader = GreenfootScenarioViewer.class.getClassLoader();
            InputStream is = loader.getResourceAsStream("standalone.properties");
            if (is == null && args.length == 3) {
                p.put("project.name", args[0]);
                p.put("main.class", args[1]);
                p.put("scenario.lock", "true");
                File f = new File(args[2]);
                is = new FileInputStream(f);
            }
            p.load(is);
            worldClassName = p.getProperty("main.class");
            scenarioName = p.getProperty("project.name");
            lockScenario = Boolean.parseBoolean(p.getProperty("scenario.lock"));
            Config.initializeStandalone((BlueJPropStringSource)new StandalonePropStringManager(p));
            is.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            GreenfootUtil.initialise(new GreenfootUtilDelegateStandAlone());
            this.properties = new ProjectProperties();
            ActorDelegateStandAlone.setupAsActorDelegate();
            ActorDelegateStandAlone.initProperties(this.properties);
            this.canvas = new WorldCanvas(null);
            WorldHandler.initialise(this.canvas, new WorldHandlerDelegateStandAlone(this, lockScenario));
            WorldHandler worldHandler = WorldHandler.getInstance();
            Simulation.initialize(worldHandler, new SimulationDelegateStandAlone());
            LocationTracker.initialize();
            this.sim = Simulation.getInstance();
            this.controls = new ControlPanel(this.sim, !lockScenario);
            this.sim.addSimulationListener(SoundPlayer.getInstance());
            this.sim.addSimulationListener(new SimulationListener(){

                public void simulationChanged(SimulationEvent e) {
                    if (e.getType() == 0) {
                        GreenfootScenarioViewer.this.canvas.requestFocusInWindow();
                        GreenfootScenarioViewer.this.canvas.requestFocus();
                    }
                }
            });
            try {
                int initialSpeed = this.properties.getInt("simulation.speed");
                this.sim.setSpeed(initialSpeed);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            Class<?> worldClass = Class.forName(worldClassName);
            this.worldConstructor = worldClass.getConstructor(new Class[0]);
            this.instantiateNewWorld();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.buildGUI();
    }

    public void start() {
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GreenfootScenarioViewer.this.canvas.requestFocusInWindow();
                GreenfootScenarioViewer.this.canvas.requestFocus();
            }
        });
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return Config.getString((String)"scenario.viewer.appletInfo") + " " + scenarioName;
    }

    public String[][] getParameterInfo() {
        String[][] paramInfo = new String[][]{};
        return paramInfo;
    }

    public void instantiateNewWorld() {
        try {
            World world = (World)this.worldConstructor.newInstance(new Object[0]);
            this.canvas.setWorld(world);
            WorldHandler.getInstance().setWorld(world);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            e.getCause().printStackTrace();
        }
    }
}

