/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export;

import bluej.Boot;
import bluej.Config;
import greenfoot.core.GProject;
import greenfoot.core.WorldHandler;
import greenfoot.event.PublishEvent;
import greenfoot.event.PublishListener;
import greenfoot.export.GreenfootScenarioViewer;
import greenfoot.export.JarCreator;
import greenfoot.export.WebPublisher;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.gui.WorldCanvas;
import greenfoot.gui.export.ExportAppPane;
import greenfoot.gui.export.ExportDialog;
import greenfoot.gui.export.ExportPublishPane;
import greenfoot.gui.export.ExportWebPagePane;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public class Exporter
implements PublishListener {
    private static Exporter instance;
    private File tmpJarFile;
    private File tmpImgFile;
    private WebPublisher webPublisher;
    private ExportDialog dlg;

    public static synchronized Exporter getInstance() {
        if (instance == null) {
            instance = new Exporter();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishToWebServer(GProject project, ExportPublishPane pane, ExportDialog dlg) {
        String hostAddress;
        this.dlg = dlg;
        dlg.setProgress(true, Config.getString((String)"export.progress.bundling"));
        try {
            this.tmpJarFile = File.createTempFile("greenfoot", ".jar", null);
            this.tmpJarFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        File exportDir = this.tmpJarFile.getParentFile();
        String jarName = this.tmpJarFile.getName();
        String worldClass = WorldHandler.getInstance().getLastWorldClass().getName();
        boolean lockScenario = pane.lockScenario();
        JarCreator jarCreator = new JarCreator(project, exportDir, jarName, worldClass, lockScenario);
        jarCreator.includeSource(false);
        jarCreator.putManifestEntry("title", pane.getTitle());
        jarCreator.putManifestEntry("short-description", pane.getShortDescription());
        jarCreator.putManifestEntry("description", pane.getDescription());
        jarCreator.putManifestEntry("url", pane.getURL());
        jarCreator.putManifestEntry("greenfoot-version", Boot.GREENFOOT_VERSION);
        jarCreator.putManifestEntry("java-version", System.getProperty("java.version"));
        jarCreator.putManifestEntry("java-vm-name", System.getProperty("java.vm.name"));
        jarCreator.putManifestEntry("java-vm-version", System.getProperty("java.vm.version"));
        jarCreator.putManifestEntry("java-vm-vendor", System.getProperty("java.vm.vendor"));
        jarCreator.putManifestEntry("os-name", System.getProperty("os.name"));
        jarCreator.putManifestEntry("os-version", System.getProperty("os.version"));
        jarCreator.putManifestEntry("os-arch", System.getProperty("os.arch"));
        jarCreator.putManifestEntry("java-home", System.getProperty("java.home"));
        Dimension size = this.getSize(!lockScenario);
        jarCreator.putManifestEntry("width", "" + size.width);
        jarCreator.putManifestEntry("height", "" + size.height);
        project.getProjectProperties().save();
        jarCreator.create();
        File tmpZipFile = null;
        if (pane.includeSourceCode()) {
            try {
                tmpZipFile = File.createTempFile("greenfootSource", ".zip", null);
                tmpZipFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            String zipName = tmpZipFile.getName();
            JarCreator zipCreator = new JarCreator(project, exportDir, zipName);
            zipCreator.create();
        }
        String formatName = "png";
        try {
            this.tmpImgFile = File.createTempFile("greenfoot", "." + formatName, null);
            BufferedImage img = pane.getImage();
            ImageIO.write((RenderedImage)img, formatName, this.tmpImgFile);
            this.tmpImgFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        String login = pane.getUserName();
        String password = pane.getPassword();
        String scenarioName = pane.getTitle();
        if (scenarioName != null && scenarioName.length() < 1) {
            scenarioName = "NO_NAME";
        }
        if (!(hostAddress = Config.getPropString((String)"greenfoot.gameserver.address", (String)"http://www.greenfootgallery.org/")).endsWith("/")) {
            hostAddress = hostAddress + "/";
        }
        if (this.webPublisher == null) {
            this.webPublisher = new WebPublisher();
            this.webPublisher.addPublishListener(this);
        }
        dlg.setProgress(true, Config.getString((String)"export.progress.publishing"));
        try {
            ScenarioInfo info = new ScenarioInfo();
            info.setTitle(scenarioName);
            info.setShortDescription(pane.getShortDescription());
            info.setLongDescription(pane.getDescription());
            info.setTags(pane.getTags());
            info.setUrl(pane.getURL());
            int uploadSize = (int)this.tmpJarFile.length();
            if (this.tmpImgFile != null) {
                uploadSize += (int)this.tmpImgFile.length();
            }
            if (tmpZipFile != null) {
                uploadSize += (int)tmpZipFile.length();
            }
            this.gotUploadSize(uploadSize);
            this.webPublisher.submit(hostAddress, login, password, this.tmpJarFile.getAbsolutePath(), tmpZipFile, this.tmpImgFile, size.width, size.height, info);
        }
        catch (UnknownHostException e) {
            dlg.setProgress(false, Config.getString((String)"export.publish.unknownHost") + " (" + e.getMessage() + ")");
            return;
        }
        catch (IOException e) {
            dlg.setProgress(false, Config.getString((String)"export.publish.fail") + " " + e.getMessage());
            return;
        }
        finally {
            this.tmpImgFile.delete();
            this.tmpImgFile = null;
        }
    }

    public void makeWebPage(GProject project, ExportWebPagePane pane, ExportDialog dlg) {
        this.dlg = dlg;
        dlg.setProgress(true, Config.getString((String)"export.progress.writingHTML"));
        File exportDir = new File(pane.getExportLocation());
        exportDir.mkdir();
        String worldClass = WorldHandler.getInstance().getLastWorldClass().getName();
        boolean includeControls = pane.lockScenario();
        String jarName = project.getName() + ".jar";
        JarCreator jarCreator = new JarCreator(project, exportDir, jarName, worldClass, includeControls);
        jarCreator.includeSource(false);
        Dimension size = this.getSize(includeControls);
        project.getProjectProperties().save();
        jarCreator.create();
        String htmlName = project.getName() + ".html";
        String title = project.getName();
        File outputFile = new File(exportDir, htmlName);
        jarCreator.generateHTMLSkeleton(outputFile, title, size.width, size.height);
        dlg.setProgress(false, Config.getString((String)"export.progress.complete"));
    }

    public void makeApplication(GProject project, ExportAppPane pane, ExportDialog dlg) {
        dlg.setProgress(true, Config.getString((String)"export.progress.writingJar"));
        File exportFile = new File(pane.getExportName());
        File exportDir = exportFile.getParentFile();
        String jarName = exportFile.getName();
        String worldClass = WorldHandler.getInstance().getLastWorldClass().getName();
        boolean includeControls = pane.lockScenario();
        JarCreator jarCreator = new JarCreator(project, exportDir, jarName, worldClass, includeControls);
        jarCreator.includeSource(false);
        project.getProjectProperties().save();
        jarCreator.create();
        dlg.setProgress(false, Config.getString((String)"export.progress.complete"));
    }

    private Dimension getSize(boolean includeControls) {
        Dimension controlPanelSize = null;
        Dimension border = GreenfootScenarioViewer.getControlsBorderSize();
        controlPanelSize = includeControls ? new Dimension(560 + border.width, 46 + border.height) : new Dimension(410 + border.width, 46 + border.height);
        WorldCanvas canvas = WorldHandler.getInstance().getWorldCanvas();
        border = GreenfootScenarioViewer.getControlsBorderSize();
        Dimension size = new Dimension(canvas.getWidth() + border.width, (int)controlPanelSize.getHeight() + canvas.getHeight() + border.height);
        if (size.getWidth() < controlPanelSize.getWidth()) {
            size.width = controlPanelSize.width;
        }
        return size;
    }

    public void errorRecieved(final PublishEvent event) {
        this.tmpJarFile.delete();
        this.tmpImgFile.delete();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Exporter.this.dlg.publishFinished(false, Config.getString((String)"export.publish.fail") + " " + event.getMessage());
            }
        });
    }

    public void statusRecieved(PublishEvent event) {
        this.tmpJarFile.delete();
        this.tmpImgFile.delete();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Exporter.this.dlg.publishFinished(true, Config.getString((String)"export.publish.complete"));
            }
        });
    }

    public void gotUploadSize(final int size) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Exporter.this.dlg.gotUploadSize(size);
            }
        });
    }

    public void progressMade(final PublishEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Exporter.this.dlg.progressMade(event.getBytes());
            }
        });
    }
}

