/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.debugger.DebuggerObject;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallDialogWatcher;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.MethodDialog;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import greenfoot.ObjectTracker;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.WorldHandler;
import greenfoot.event.ActorInstantiationListener;
import greenfoot.gui.GreenfootMethodDialog;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.localdebugger.LocalObject;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import rmiextension.wrappers.RObject;

public class WorldInvokeListener
implements InvokeListener,
CallDialogWatcher {
    private Object obj;
    private RObject rObj;
    private MethodView mv;
    private ConstructorView cv;
    private Class cl;
    private InspectorManager inspectorManager;
    private ObjectBenchInterface objectBench;
    private GProject project;
    private Map dialogToLocationMap = new HashMap();

    public WorldInvokeListener(Object obj, ObjectBenchInterface bench, InspectorManager inspectorManager, GProject project) {
        this.objectBench = bench;
        this.obj = obj;
        this.inspectorManager = inspectorManager;
        this.project = project;
    }

    public WorldInvokeListener(Class cl, InspectorManager inspectorManager, GProject project) {
        this.cl = cl;
        this.project = project;
        this.inspectorManager = inspectorManager;
    }

    public void executeMethod(MethodView mv) {
        this.mv = mv;
        try {
            String instanceName;
            if (this.obj != null) {
                this.rObj = ObjectTracker.getRObject(this.obj);
            }
            String string = instanceName = this.obj != null ? this.rObj.getInstanceName() : this.cl.getName();
            if (mv.getParameterCount() == 0) {
                final Method m = mv.getMethod();
                new Thread(){

                    public void run() {
                        try {
                            final Object r = m.invoke(WorldInvokeListener.this.obj, (Object[])null);
                            WorldInvokeListener.this.update();
                            if (m.getReturnType() != Void.TYPE) {
                                final ExpressionInformation ei = new ExpressionInformation(WorldInvokeListener.this.mv, instanceName);
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        ResultInspector ri = WorldInvokeListener.this.inspectorManager.getResultInspectorInstance((DebuggerObject)WorldInvokeListener.wrapResult(r, m.getReturnType()), instanceName, null, null, ei, (JFrame)GreenfootMain.getInstance().getFrame());
                                        ri.setVisible(true);
                                    }
                                });
                            }
                        }
                        catch (InvocationTargetException ite) {
                            ite.getCause().printStackTrace();
                        }
                        catch (IllegalAccessException iae) {
                            iae.printStackTrace();
                        }
                    }
                }.start();
            } else {
                CallHistory ch = GreenfootMain.getInstance().getCallHistory();
                GreenfootMethodDialog md = new GreenfootMethodDialog(GreenfootMain.getInstance().getFrame(), this.objectBench, ch, instanceName, (CallableView)mv, null);
                md.setWatcher(this);
                md.setVisible(true);
            }
        }
        catch (RemoteException re) {
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void callConstructor(ConstructorView cv) {
        this.cv = cv;
        if (cv.getParameterCount() == 0) {
            new Thread(){

                public void run() {
                    try {
                        Constructor c = WorldInvokeListener.this.cl.getDeclaredConstructor(new Class[0]);
                        c.setAccessible(true);
                        Object o = c.newInstance(null);
                        ActorInstantiationListener invocListener = GreenfootMain.getInstance().getInvocationListener();
                        invocListener.localObjectCreated(o, LocationTracker.instance().getMouseButtonEvent());
                    }
                    catch (NoSuchMethodException nsme) {
                    }
                    catch (IllegalAccessException iae) {
                    }
                    catch (InstantiationException ie) {
                    }
                    catch (InvocationTargetException ite) {
                        ite.getCause().printStackTrace();
                    }
                }
            }.start();
        } else {
            CallHistory ch = GreenfootMain.getInstance().getCallHistory();
            GreenfootMethodDialog md = new GreenfootMethodDialog(GreenfootMain.getInstance().getFrame(), this.objectBench, ch, "result", (CallableView)cv, null);
            this.dialogToLocationMap.put(md, LocationTracker.instance().getMouseButtonEvent());
            md.setWatcher(this);
            md.setVisible(true);
        }
    }

    public void callDialogEvent(CallDialog dlg, int event) {
        if (event == 1) {
            dlg.setVisible(false);
            dlg.dispose();
            this.dialogToLocationMap.remove(dlg);
        } else if (event == 0) {
            MethodDialog mdlg = (MethodDialog)dlg;
            mdlg.setWaitCursor(true);
            mdlg.setEnabled(false);
            RObject rObj = null;
            try {
                if (this.obj != null) {
                    rObj = ObjectTracker.getRObject(this.obj);
                }
            }
            catch (ProjectNotOpenException e1) {
                e1.printStackTrace();
            }
            catch (PackageNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            GPackage pkg = null;
            try {
                pkg = this.project.getDefaultPackage();
            }
            catch (ProjectNotOpenException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (pkg == null) {
                return;
            }
            this.executeMethod(mdlg, rObj, pkg);
        }
    }

    private void executeMethod(final MethodDialog mdlg, final RObject rObj, final GPackage pkg) {
        ConstructorView callv = this.mv == null ? this.cv : this.mv;
        Class[] cparams = callv.getParameters();
        final String[] params = new String[cparams.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = cparams[i].getName();
        }
        Thread t = new Thread(){

            public void run() {
                block16: {
                    if (WorldInvokeListener.this.mv != null) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    mdlg.setVisible(false);
                                }
                            });
                            String resultName = rObj != null ? rObj.invokeMethod(WorldInvokeListener.this.mv.getName(), params, mdlg.getArgs()) : pkg.invokeMethod(WorldInvokeListener.this.cl.getName(), WorldInvokeListener.this.mv.getName(), params, mdlg.getArgs());
                            if (resultName != null && resultName.charAt(0) == '!') {
                                final String errorMsg = resultName.substring(1);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        mdlg.setErrorMessage(errorMsg);
                                        mdlg.setWaitCursor(false);
                                        mdlg.setEnabled(true);
                                        mdlg.pack();
                                        mdlg.setVisible(true);
                                    }
                                });
                                break block16;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    mdlg.dispose();
                                }
                            });
                            Method m = WorldInvokeListener.this.mv.getMethod();
                            if (m.getReturnType() == Void.TYPE) break block16;
                            String instanceName = rObj != null ? rObj.getInstanceName() : WorldInvokeListener.this.cl.getName();
                            ExpressionInformation ei = new ExpressionInformation(WorldInvokeListener.this.mv, instanceName);
                            try {
                                RObject rresult = pkg.getObject(resultName);
                                Object resultw = ObjectTracker.getRealObject(rresult);
                                rresult.removeFromBench();
                                ResultInspector ri = WorldInvokeListener.this.inspectorManager.getResultInspectorInstance((DebuggerObject)LocalObject.getLocalObject(resultw), instanceName, null, null, ei, (JFrame)GreenfootMain.getInstance().getFrame());
                                ri.setVisible(true);
                            }
                            catch (PackageNotFoundException pnfe) {
                            }
                            catch (ProjectNotOpenException pnoe) {
                            }
                        }
                        catch (RemoteException re) {
                            re.printStackTrace(System.out);
                        }
                    } else if (WorldInvokeListener.this.cv != null) {
                        try {
                            String resultName = pkg.invokeConstructor(WorldInvokeListener.this.cl.getName(), params, mdlg.getArgs());
                            if (resultName != null && resultName.charAt(0) == '!') {
                                final String errorMsg = resultName.substring(1);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        mdlg.setErrorMessage(errorMsg);
                                        mdlg.setWaitCursor(false);
                                        mdlg.setEnabled(true);
                                    }
                                });
                            } else {
                                mdlg.setVisible(false);
                                MouseEvent location = (MouseEvent)WorldInvokeListener.this.dialogToLocationMap.remove(mdlg);
                                if (resultName != null) {
                                    RObject rresult = pkg.getObject(resultName);
                                    Object resultw = ObjectTracker.getRealObject(rresult);
                                    rresult.removeFromBench();
                                    ActorInstantiationListener invocListener = GreenfootMain.getInstance().getInvocationListener();
                                    invocListener.localObjectCreated(resultw, location);
                                }
                            }
                        }
                        catch (RemoteException re) {
                            re.printStackTrace();
                        }
                        catch (ProjectNotOpenException pnoe) {
                        }
                        catch (PackageNotFoundException packageNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                WorldInvokeListener.this.update();
            }
        };
        t.start();
    }

    private void update() {
        WorldHandler worldHandler = WorldHandler.getInstance();
        if (worldHandler != null) {
            worldHandler.repaint();
        }
    }

    private static LocalObject wrapResult(final Object r, Class c) {
        Object wrapped = c == Boolean.TYPE ? new Object(){
            public boolean result;
            {
                this.result = (Boolean)r;
            }
        } : (c == Byte.TYPE ? new Object(){
            public byte result;
            {
                this.result = (Byte)r;
            }
        } : (c == Character.TYPE ? new Object(){
            public char result;
            {
                this.result = ((Character)r).charValue();
            }
        } : (c == Short.TYPE ? new Object(){
            public short result;
            {
                this.result = (Short)r;
            }
        } : (c == Integer.TYPE ? new Object(){
            public int result;
            {
                this.result = (Integer)r;
            }
        } : (c == Long.TYPE ? new Object(){
            public long result;
            {
                this.result = (Long)r;
            }
        } : (c == Float.TYPE ? new Object(){
            public float result;
            {
                this.result = ((Float)r).floatValue();
            }
        } : (c == Double.TYPE ? new Object(){
            public double result;
            {
                this.result = (Double)r;
            }
        } : new Object(){
            public Object result;
            {
                this.result = r;
            }
        })))))));
        return LocalObject.getLocalObject(wrapped);
    }
}

