/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.ObjectDragProxy;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.event.TriggeredKeyListener;
import greenfoot.event.TriggeredMouseListener;
import greenfoot.event.TriggeredMouseMotionListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.DragListener;
import greenfoot.gui.DropTarget;
import greenfoot.gui.WorldCanvas;
import greenfoot.gui.input.InputManager;
import greenfoot.gui.input.KeyboardManager;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.gui.input.mouse.MousePollingManager;
import greenfoot.gui.input.mouse.WorldLocator;
import greenfoot.platforms.WorldHandlerDelegate;
import greenfoot.util.GraphicsUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldHandler
implements TriggeredMouseListener,
TriggeredMouseMotionListener,
TriggeredKeyListener,
DropTarget,
DragListener,
SimulationListener {
    private World initialisingWorld;
    private World world;
    private WorldCanvas worldCanvas;
    private int dragBeginX;
    private int dragBeginY;
    private boolean objectDropped = true;
    private KeyboardManager keyboardManager;
    private static WorldHandler instance;
    private EventListenerList listenerList = new EventListenerList();
    private WorldEvent worldEvent;
    private WorldHandlerDelegate handlerDelegate;
    private MousePollingManager mousePollingManager;
    private InputManager inputManager;
    private int dragOffsetX;
    private int dragOffsetY;
    private Actor dragActor;
    private Cursor defaultCursor;

    public static synchronized void initialise(WorldCanvas worldCanvas, WorldHandlerDelegate helper) {
        instance = new WorldHandler(worldCanvas, helper);
    }

    public static synchronized WorldHandler getInstance() {
        return instance;
    }

    private WorldHandler(final WorldCanvas worldCanvas, WorldHandlerDelegate handlerDelegate) {
        instance = this;
        this.handlerDelegate = handlerDelegate;
        this.handlerDelegate.setWorldHandler(this);
        this.worldCanvas = worldCanvas;
        this.worldEvent = new WorldEvent(this);
        this.mousePollingManager = new MousePollingManager(new WorldLocator(){

            public Actor getTopMostActorAt(MouseEvent e) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), worldCanvas);
                return WorldHandler.this.getObject(p.x, p.y);
            }

            public int getTranslatedX(MouseEvent e) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), worldCanvas);
                return WorldVisitor.toCellFloor(WorldHandler.this.getWorld(), p.x);
            }

            public int getTranslatedY(MouseEvent e) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), worldCanvas);
                return WorldVisitor.toCellFloor(WorldHandler.this.getWorld(), p.y);
            }
        });
        worldCanvas.setDropTargetListener(this);
        LocationTracker.instance().setSourceComponent(worldCanvas);
        this.keyboardManager = new KeyboardManager();
        worldCanvas.addFocusListener(this.keyboardManager);
        this.inputManager = handlerDelegate.getInputManager();
        this.addWorldListener(this.inputManager);
        this.inputManager.setRunningListeners(this.getKeyboardManager(), this.mousePollingManager, this.mousePollingManager);
        worldCanvas.addMouseListener(this.inputManager);
        worldCanvas.addMouseMotionListener(this.inputManager);
        worldCanvas.addKeyListener(this.inputManager);
        this.inputManager.init();
        this.defaultCursor = worldCanvas.getCursor();
    }

    public KeyboardManager getKeyboardManager() {
        return this.keyboardManager;
    }

    public MousePollingManager getMouseManager() {
        return this.mousePollingManager;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handlerDelegate.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Actor actor;
        boolean isPopUp = this.handlerDelegate.maybeShowPopup(e);
        if (SwingUtilities.isLeftMouseButton(e) && !isPopUp && (actor = this.getObject(e.getX(), e.getY())) != null) {
            Point p = e.getPoint();
            this.startDrag(actor, p);
        }
    }

    private void startDrag(Actor actor, Point p) {
        this.dragActor = actor;
        this.dragBeginX = actor.getX() * this.world.getCellSize() + this.world.getCellSize() / 2;
        this.dragBeginY = actor.getY() * this.world.getCellSize() + this.world.getCellSize() / 2;
        this.dragOffsetX = this.dragBeginX - p.x;
        this.dragOffsetY = this.dragBeginY - p.y;
        this.objectDropped = false;
        SwingUtilities.getWindowAncestor(this.worldCanvas).toFront();
        this.worldCanvas.setCursor(Cursor.getPredefinedCursor(12));
        this.drag(actor, p);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handlerDelegate.maybeShowPopup(e);
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.dragActor = null;
            this.worldCanvas.setCursor(this.defaultCursor);
        }
    }

    public Actor getObject(int x, int y) {
        World world = this.world;
        if (world == null) {
            return null;
        }
        Collection objectsThere = WorldVisitor.getObjectsAtPixel(world, x, y);
        if (objectsThere.isEmpty()) {
            return null;
        }
        Iterator iter = objectsThere.iterator();
        Actor topmostActor = (Actor)iter.next();
        int seq = ActorVisitor.getLastPaintSeqNum(topmostActor);
        while (iter.hasNext()) {
            Actor actor = (Actor)iter.next();
            int actorSeq = ActorVisitor.getLastPaintSeqNum(actor);
            if (actorSeq <= seq) continue;
            topmostActor = actor;
            seq = actorSeq;
        }
        return topmostActor;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.worldCanvas.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.dragActor != null) {
            ActorVisitor.setLocationInPixels(this.dragActor, this.dragBeginX, this.dragBeginY);
            this.repaint();
        }
    }

    public void repaint() {
        this.worldCanvas.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.worldCanvas.requestFocus();
    }

    public void instantiateNewWorld() {
        this.handlerDelegate.instantiateNewWorld();
    }

    public void setInitialisingWorld(World world) {
        this.initialisingWorld = world;
    }

    public synchronized void discardWorld() {
        if (this.world == null) {
            return;
        }
        this.handlerDelegate.discardWorld(this.world);
        this.world = null;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WorldHandler.this.worldCanvas.setWorld(null);
                WorldHandler.this.fireWorldRemovedEvent();
            }
        });
    }

    public synchronized void setWorld(final World world) {
        this.handlerDelegate.setWorld(this.world, world);
        this.world = world;
        this.initialisingWorld = null;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WorldHandler.this.worldCanvas.setWorld(world);
                if (WorldHandler.this.world != null) {
                    WorldHandler.this.fireWorldCreatedEvent();
                }
            }
        });
    }

    public Class<?> getLastWorldClass() {
        return this.handlerDelegate.getLastWorldClass();
    }

    public World getWorld() {
        if (this.world == null) {
            return this.initialisingWorld;
        }
        return this.world;
    }

    @Override
    public boolean drop(Object o, Point p) {
        int maxHeight = WorldVisitor.getHeightInPixels(this.world);
        int maxWidth = WorldVisitor.getWidthInPixels(this.world);
        int x = (int)p.getX();
        int y = (int)p.getY();
        if (x >= maxWidth || y >= maxHeight) {
            return false;
        }
        if (o instanceof ObjectDragProxy) {
            ObjectDragProxy to = (ObjectDragProxy)o;
            to.createRealObject();
            this.world.removeObject(to);
            this.objectDropped = true;
            return true;
        }
        if (o instanceof Actor && ((Actor)o).getWorld() == null) {
            Actor actor = (Actor)o;
            int xCell = WorldVisitor.toCellFloor(this.getWorld(), x);
            int yCell = WorldVisitor.toCellFloor(this.getWorld(), y);
            this.getWorld().addObject(actor, xCell, yCell);
            this.objectDropped = true;
            return true;
        }
        if (o instanceof Actor) {
            Actor actor = (Actor)o;
            if (actor.getWorld() == null) {
                return false;
            }
            try {
                ActorVisitor.setLocationInPixels(actor, x, y);
                this.objectDropped = true;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean drag(Object o, Point p) {
        if (o instanceof Actor && this.world != null) {
            block5: {
                int x = WorldVisitor.toCellFloor(this.getWorld(), (int)p.getX());
                int y = WorldVisitor.toCellFloor(this.getWorld(), (int)p.getY());
                Actor actor = (Actor)o;
                try {
                    int oldX = actor.getX();
                    int oldY = actor.getY();
                    if (oldX == x && oldY == y) break block5;
                    if (x < this.world.getWidth() && y < this.world.getHeight() && x >= 0 && y >= 0) {
                        ActorVisitor.setLocationInPixels(actor, (int)p.getX() + this.dragOffsetX, (int)p.getY() + this.dragOffsetY);
                        this.repaint();
                        break block5;
                    }
                    ActorVisitor.setLocationInPixels(actor, this.dragBeginX, this.dragBeginY);
                    this.repaint();
                    return false;
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public synchronized boolean addObjectAtEvent(Actor actor, MouseEvent e) {
        Component source = (Component)e.getSource();
        if (source != this.worldCanvas) {
            e = SwingUtilities.convertMouseEvent(source, e, this.worldCanvas);
        }
        int xPixel = e.getX();
        int yPixel = e.getY();
        return this.addActorAtPixel(actor, xPixel, yPixel);
    }

    private boolean addActorAtPixel(Actor actor, int xPixel, int yPixel) {
        World world = this.getWorld();
        int x = WorldVisitor.toCellFloor(world, xPixel);
        int y = WorldVisitor.toCellFloor(world, yPixel);
        if (x < world.getWidth() && y < world.getHeight()) {
            world.addObject(actor, x, y);
            return true;
        }
        return false;
    }

    @Override
    public void dragEnded(Object o) {
        if (o instanceof Actor && this.world != null) {
            Actor actor = (Actor)o;
            this.world.removeObject(actor);
        }
    }

    @Override
    public void dragFinished(Object o) {
        this.handlerDelegate.dragFinished(o);
    }

    protected void fireWorldCreatedEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WorldListener.class) continue;
            ((WorldListener)listeners[i + 1]).worldCreated(this.worldEvent);
        }
    }

    public void fireWorldRemovedEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WorldListener.class) continue;
            ((WorldListener)listeners[i + 1]).worldRemoved(this.worldEvent);
        }
    }

    public void addWorldListener(WorldListener l) {
        this.listenerList.add(WorldListener.class, l);
    }

    public void removeWorldListener(WorldListener l) {
        this.listenerList.remove(WorldListener.class, l);
    }

    public void startSequence() {
        WorldVisitor.startSequence(this.world);
    }

    public WorldCanvas getWorldCanvas() {
        return this.worldCanvas;
    }

    public boolean isObjectDropped() {
        return this.objectDropped;
    }

    public void setObjectDropped(boolean b) {
        this.objectDropped = b;
    }

    public EventListenerList getListenerList() {
        return this.listenerList;
    }

    public void finishDrag(Object o) {
        if (!this.isObjectDropped() && o instanceof Actor) {
            Actor actor = (Actor)o;
            this.setObjectDropped(true);
            ActorVisitor.setLocationInPixels(actor, this.dragBeginX, this.dragBeginY);
        }
    }

    @Override
    public void simulationChanged(SimulationEvent e) {
        this.inputManager.simulationChanged(e);
        if (e.getType() == 4) {
            this.mousePollingManager.newActStarted();
        }
    }

    public InputManager getInputManager() {
        return this.inputManager;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.objectDropped = false;
            this.drag(this.dragActor, e.getPoint());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.objectDropped = false;
        this.drag(this.dragActor, e.getPoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getSnapShot() {
        BufferedImage img;
        block6: {
            if (this.world == null) {
                return null;
            }
            WorldCanvas canvas = this.getWorldCanvas();
            img = GraphicsUtilities.createCompatibleImage(WorldVisitor.getWidthInPixels(this.world), WorldVisitor.getHeightInPixels(this.world));
            Graphics2D g = img.createGraphics();
            g.setColor(canvas.getBackground());
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
            canvas.paintBackground(g);
            try {
                if (!this.world.lock.readLock().tryLock(500L, TimeUnit.MILLISECONDS)) break block6;
                try {
                    canvas.paintObjects(g);
                }
                finally {
                    this.world.lock.readLock().unlock();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return img;
    }

    @Override
    public void listeningEnded() {
    }

    @Override
    public void listeningStarted(Object obj) {
        if (obj != null && obj != this.dragActor && obj instanceof Actor) {
            Actor actor = (Actor)obj;
            int x = (int)Math.floor(WorldVisitor.getCellCenter(this.world, actor.getX()));
            int y = (int)Math.floor(WorldVisitor.getCellCenter(this.world, actor.getY()));
            Point p = new Point(x, y);
            this.startDrag(actor, p);
        }
    }
}

