/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.Actor;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.ActInterruptedException;
import greenfoot.core.WorldHandler;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.platforms.SimulationDelegate;
import greenfoot.util.HDTimer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.event.EventListenerList;

public class Simulation
extends Thread
implements WorldListener {
    private static int MAX_FRAME_RATE = 60;
    private WorldHandler worldHandler;
    private boolean paused;
    private boolean enabled;
    private boolean runOnce;
    private EventListenerList listenerList = new EventListenerList();
    private SimulationEvent startedEvent;
    private SimulationEvent stoppedEvent;
    private SimulationEvent disabledEvent;
    private SimulationEvent speedChangeEvent;
    private SimulationEvent newActEvent;
    private static Simulation instance;
    public static final int MAX_SIMULATION_SPEED = 100;
    private int speed;
    private long lastDelayTime;
    private long delay;
    private long updates;
    private long lastUpdate;
    private Queue<Long> repaintTimes = new LinkedList<Long>();
    private volatile boolean interruptedForSpeedChange = false;
    private SimulationDelegate delegate;

    private Simulation() {
        this.setName("SimulationThread");
        this.speed = 50;
        this.delay = this.calculateDelay(this.speed);
        HDTimer.init();
    }

    public static void initialize(WorldHandler worldHandler, SimulationDelegate simulationDelegate) {
        instance = new Simulation();
        Simulation.instance.worldHandler = worldHandler;
        Simulation.instance.delegate = simulationDelegate;
        Simulation.instance.startedEvent = new SimulationEvent(instance, 0);
        Simulation.instance.stoppedEvent = new SimulationEvent(instance, 1);
        Simulation.instance.speedChangeEvent = new SimulationEvent(instance, 2);
        Simulation.instance.disabledEvent = new SimulationEvent(instance, 3);
        Simulation.instance.newActEvent = new SimulationEvent(instance, 4);
        instance.setPriority(1);
        Simulation.instance.paused = true;
        worldHandler.addWorldListener(instance);
        instance.addSimulationListener(worldHandler);
        instance.start();
    }

    public static Simulation getInstance() {
        return instance;
    }

    public void run() {
        System.gc();
        while (true) {
            try {
                while (true) {
                    if (this.interruptedForSpeedChange) {
                        this.interruptedForSpeedChange = false;
                        this.delay();
                    }
                    this.maybePause();
                    World world = this.worldHandler.getWorld();
                    if (world != null) {
                        WorldVisitor.startSequence(world);
                        this.runOneLoop();
                    }
                    this.delay();
                }
            }
            catch (ActInterruptedException actInterruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void maybePause() {
        if (this.paused && this.enabled) {
            this.fireSimulationEvent(this.stoppedEvent);
            System.gc();
        }
        while (this.paused && !this.runOnce) {
            this.worldHandler.repaint();
            try {
                System.gc();
                this.wait();
            }
            catch (InterruptedException e1) {
                throw new ActInterruptedException(e1);
            }
            if (this.paused) continue;
            Queue<Long> queue = this.repaintTimes;
            synchronized (queue) {
                this.repaintTimes.clear();
            }
            this.fireSimulationEvent(this.startedEvent);
        }
        this.runOnce = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOneLoop() {
        World world = this.worldHandler.getWorld();
        if (world == null) {
            return;
        }
        this.fireSimulationEvent(this.newActEvent);
        ArrayList<Actor> objects = null;
        try {
            world.lock.writeLock().lockInterruptibly();
            try {
                world.act();
                objects = new ArrayList<Actor>(WorldVisitor.getObjectsListInActOrder(world));
                for (Actor actor : objects) {
                    if (actor.getWorld() == null) continue;
                    actor.act();
                }
            }
            catch (ActInterruptedException e) {
                throw e;
            }
            catch (Throwable t) {
                this.paused = true;
                t.printStackTrace();
            }
            finally {
                if (world.lock.isWriteLockedByCurrentThread()) {
                    world.lock.writeLock().unlock();
                }
            }
        }
        catch (InterruptedException e) {
            throw new ActInterruptedException(e);
        }
        this.printUpdateRate(System.nanoTime());
        this.repaintIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintIfNeeded() {
        int repaintRate = this.getRepaintRate();
        if (repaintRate <= MAX_FRAME_RATE) {
            this.worldHandler.repaint();
            Queue<Long> queue = this.repaintTimes;
            synchronized (queue) {
                this.repaintTimes.offer(System.currentTimeMillis());
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRepaintRate() {
        long currentTime = System.currentTimeMillis();
        long lastRepaintTime = 0L;
        int knownRepaintTimes = 0;
        Queue<Long> queue = this.repaintTimes;
        synchronized (queue) {
            knownRepaintTimes = this.repaintTimes.size();
            if (knownRepaintTimes >= 100) {
                lastRepaintTime = this.repaintTimes.poll();
            } else if (knownRepaintTimes > 0) {
                lastRepaintTime = this.repaintTimes.peek();
            }
        }
        long timeSinceRepaint = currentTime - lastRepaintTime;
        if (timeSinceRepaint == 0L) {
            timeSinceRepaint = 1L;
        }
        int frameRate = (int)((long)knownRepaintTimes * 1000L / timeSinceRepaint);
        return frameRate;
    }

    private void printUpdateRate(long currentTime) {
        ++this.updates;
        long timeSinceUpdate = currentTime - this.lastUpdate;
        if (timeSinceUpdate > 3000000000L) {
            this.lastUpdate = currentTime;
            this.updates = 0L;
        }
    }

    public synchronized void runOnce() {
        this.runOnce = true;
        this.notifyAll();
    }

    public synchronized void setPaused(boolean b) {
        this.paused = b;
        if (this.enabled) {
            this.notifyAll();
            if (this.paused) {
                instance.interrupt();
            }
        }
    }

    public synchronized void setEnabled(boolean b) {
        if (b) {
            this.notifyAll();
        }
        if (this.enabled != b) {
            this.enabled = b;
            if (!this.enabled) {
                this.paused = true;
                this.fireSimulationEvent(this.disabledEvent);
            } else {
                this.fireSimulationEvent(this.stoppedEvent);
            }
        }
    }

    private void fireSimulationEvent(SimulationEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SimulationListener.class) continue;
            ((SimulationListener)listeners[i + 1]).simulationChanged(event);
        }
    }

    public void addSimulationListener(SimulationListener l) {
        this.listenerList.add(SimulationListener.class, l);
    }

    public void removeSimulationListener(SimulationListener l) {
        this.listenerList.remove(SimulationListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeed(int speed) {
        if (speed < 0) {
            speed = 0;
        } else if (speed > 100) {
            speed = 100;
        }
        if (this.speed != speed) {
            this.speed = speed;
            this.delegate.setSpeed(speed);
            this.delay = this.calculateDelay(speed);
            Queue<Long> queue = this.repaintTimes;
            synchronized (queue) {
                this.repaintTimes.clear();
            }
            if (!this.paused) {
                this.interruptedForSpeedChange = true;
                this.interrupt();
            }
            this.fireSimulationEvent(this.speedChangeEvent);
        }
    }

    private long calculateDelay(int speed) {
        long rawDelay = 100 - speed;
        long min = 30000L;
        long max = 10000000000L;
        double a = Math.pow((double)max / (double)min, 0.010101010101010102);
        long delay = 0L;
        if (rawDelay > 0L) {
            delay = (long)(Math.pow(a, rawDelay - 1L) * (double)min);
        }
        return delay;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void sleep() {
        World world = WorldHandler.getInstance().getWorld();
        try {
            if (world != null) {
                HDTimer.wait(this.delay, world.lock);
            } else {
                HDTimer.sleep(this.delay);
            }
        }
        catch (InterruptedException e) {
            throw new ActInterruptedException(e);
        }
    }

    private void delay() {
        try {
            long currentTime = System.nanoTime();
            long timeElapsed = currentTime - this.lastDelayTime;
            long actualDelay = this.delay - timeElapsed;
            if (actualDelay < 0L) {
                actualDelay = 0L;
            }
            if (actualDelay > 0L) {
                HDTimer.sleep(actualDelay);
            }
            this.lastDelayTime = currentTime + actualDelay;
        }
        catch (InterruptedException e) {
            throw new ActInterruptedException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void worldCreated(WorldEvent e) {
        this.setEnabled(true);
    }

    public void worldRemoved(WorldEvent e) {
        this.setEnabled(false);
    }
}

