/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.GreenfootImage;
import greenfoot.util.GreenfootUtil;
import greenfoot.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ProjectProperties {
    private static final String FILE_HEADER = "Greenfoot properties";
    public static final String GREENFOOT_PKG_NAME = "project.greenfoot";
    private Properties properties;
    private File propsFile;
    public Map<String, GreenfootImage> classImages = new HashMap<String, GreenfootImage>();

    public ProjectProperties(File projectDir) {
        this.properties = new Properties();
        this.load(projectDir);
    }

    public ProjectProperties() {
        this.properties = new Properties();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        URL probsFile = this.getClass().getResource("/project.greenfoot");
        InputStream is = null;
        try {
            is = probsFile.openStream();
            this.properties.load(is);
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File projectDir) {
        this.propsFile = new File(projectDir, GREENFOOT_PKG_NAME);
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.propsFile);
            this.properties.load(is);
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.propsFile);
            this.properties.store(os, FILE_HEADER);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setString(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public void setInt(String key, int value) {
        this.properties.setProperty(key, Integer.toString(value));
    }

    public int getInt(String key) throws NumberFormatException {
        String number = this.properties.getProperty(key);
        return Integer.parseInt(number);
    }

    public void setBoolean(String key, boolean value) {
        this.properties.setProperty(key, Boolean.toString(value));
    }

    public boolean getBoolean(String key) throws NullPointerException {
        String bool = this.properties.getProperty(key);
        if (bool == null) {
            throw new NullPointerException("Key does not exist: " + key);
        }
        return Boolean.parseBoolean(bool);
    }

    public String removeProperty(String key) {
        return (String)this.properties.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GreenfootImage getImage(String className) {
        className = GreenfootUtil.extractClassName(className);
        Map<String, GreenfootImage> map = this.classImages;
        synchronized (map) {
            GreenfootImage image = this.classImages.get(className);
            if (image == null) {
                if (className.equals("Actor")) {
                    image = new GreenfootImage(GreenfootUtil.getGreenfootLogoPath().toString());
                } else {
                    String imageName = this.getString("class." + className + ".image");
                    if (imageName != null) {
                        try {
                            image = new GreenfootImage("images/" + imageName);
                        }
                        catch (IllegalArgumentException iae) {
                            // empty catch block
                        }
                    }
                }
                if (image != null) {
                    this.classImages.put(className, image);
                }
            }
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedImage(String className) {
        Map<String, GreenfootImage> map = this.classImages;
        synchronized (map) {
            this.classImages.remove(className);
        }
    }

    public void setApiVersion(String version) {
        this.properties.setProperty("version", version);
    }

    public Version getAPIVersion() {
        String versionString = this.properties.getProperty("version");
        Version version = new Version(versionString);
        return version;
    }
}

