/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.Config;
import bluej.debugmgr.CallHistory;
import bluej.extensions.ProjectNotOpenException;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.views.View;
import greenfoot.ObjectTracker;
import greenfoot.core.ClassStateManager;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.ProjectProperties;
import greenfoot.core.WorldHandler;
import greenfoot.event.ActorInstantiationListener;
import greenfoot.event.CompileListener;
import greenfoot.event.CompileListenerForwarder;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.MessageDialog;
import greenfoot.platforms.ide.ActorDelegateIDE;
import greenfoot.util.GreenfootUtil;
import greenfoot.util.Version;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import rmiextension.wrappers.RBlueJ;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.event.RCompileEvent;
import rmiextension.wrappers.event.RInvocationListener;
import rmiextension.wrappers.event.RProjectListener;

public class GreenfootMain
extends Thread
implements CompileListener,
RProjectListener {
    public static final int VERSION_OK = 0;
    public static final int VERSION_UPDATED = 1;
    public static final int VERSION_BAD = 2;
    private static Version version = null;
    private static GreenfootMain instance;
    private RBlueJ rBlueJ;
    private GreenfootFrame frame;
    private GProject project;
    private GPackage pkg;
    private File startupProject;
    private CompileListenerForwarder compileListenerForwarder;
    private List<CompileListener> compileListeners = new LinkedList<CompileListener>();
    private ClassStateManager classStateManager;
    private ActorInstantiationListener instantiationListener;
    private List<RInvocationListener> invocationListeners = new ArrayList<RInvocationListener>();
    private CallHistory callHistory = new CallHistory();
    private static FilenameFilter classFilter;
    private ClassLoader currentLoader;

    public static void initialize(RBlueJ rBlueJ, RPackage pkg) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (instance == null) {
            try {
                instance = new GreenfootMain(rBlueJ, pkg.getProject());
            }
            catch (ProjectNotOpenException pnoe) {
                pnoe.printStackTrace();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    public static GreenfootMain getInstance() {
        return instance;
    }

    private GreenfootMain(final RBlueJ rBlueJ, RProject proj) {
        instance = this;
        this.rBlueJ = rBlueJ;
        this.currentLoader = ExecServer.getCurrentClassLoader();
        this.addCompileListener(this);
        try {
            File startupProj = rBlueJ.getSystemLibDir();
            startupProj = new File(startupProj, "greenfoot");
            this.startupProject = new File(startupProj, "startupProject");
            this.project = new GProject(proj);
            this.addCompileListener(this.project);
            this.pkg = this.project.getDefaultPackage();
            ActorDelegateIDE.setupAsActorDelegate(this.project);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    GreenfootMain.this.frame = GreenfootFrame.getGreenfootFrame(rBlueJ);
                    if (!GreenfootMain.this.isStartupProject()) {
                        try {
                            GreenfootMain.this.instantiationListener = new ActorInstantiationListener(WorldHandler.getInstance());
                            GreenfootMain.this.frame.openProject(GreenfootMain.this.project);
                            GreenfootMain.this.compileListenerForwarder = new CompileListenerForwarder(GreenfootMain.this.compileListeners);
                            GreenfootMain.this.rBlueJ.addCompileListener(GreenfootMain.this.compileListenerForwarder, GreenfootMain.this.pkg.getProject().getDir());
                            GreenfootMain.this.classStateManager = new ClassStateManager(GreenfootMain.this.project);
                            rBlueJ.addClassListener(GreenfootMain.this.classStateManager);
                        }
                        catch (Exception exc) {
                            Debug.reportError((String)"Error when opening scenario", (Exception)exc);
                        }
                    } else {
                        Utility.bringToFront((Window)GreenfootMain.this.frame);
                    }
                }
            });
        }
        catch (Exception exc) {
            Debug.reportError((String)"could not create greenfoot main", (Exception)exc);
        }
    }

    private boolean isStartupProject() {
        try {
            return this.project.getDir().equals(this.startupProject);
        }
        catch (ProjectNotOpenException pnoe) {
            return false;
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public void openProject(String projectDir) throws RemoteException {
        boolean doOpen;
        File projectDirFile = new File(projectDir);
        if (!projectDirFile.exists()) {
            JButton[] buttons = new JButton[]{new JButton(Config.getString((String)"greenfoot.continue"))};
            MessageDialog confirmRemove = new MessageDialog(this.frame, Config.getString((String)"noproject.dialog.msg") + System.getProperty("line.separator") + projectDir, Config.getString((String)"noproject.dialog.title"), 200, buttons);
            confirmRemove.display();
            return;
        }
        try {
            if (this.project.getDir().equals(projectDirFile)) {
                this.frame.openProject(this.project);
                return;
            }
        }
        catch (ProjectNotOpenException pnoe) {
            // empty catch block
        }
        int versionStatus = GreenfootMain.updateApi(projectDirFile, this.frame);
        boolean bl = doOpen = versionStatus != 2;
        if (doOpen) {
            this.rBlueJ.openProject(projectDir);
            if (this.frame.getProject() == null) {
                this.project.close();
            }
        }
    }

    public void openProjectBrowser() {
        File dirName = GreenfootUtil.getScenarioFromFileBrowser(this.frame);
        if (dirName != null) {
            try {
                this.openProject(dirName.getAbsolutePath());
            }
            catch (Exception exc) {
                Debug.reportError((String)"Could not open scenario", (Exception)exc);
            }
        }
    }

    public GProject getProject() {
        return this.project;
    }

    private void closeThisInstance(boolean windowClosing) {
        try {
            if (this.rBlueJ.getOpenProjects().length <= 1) {
                if (windowClosing) {
                    this.rBlueJ.exit();
                } else {
                    this.frame.closeProject();
                }
            } else {
                this.project.close();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public static void closeProject(GreenfootFrame frame, boolean windowClosing) {
        instance.closeThisInstance(windowClosing);
    }

    public void projectClosing() {
        try {
            if (!this.isStartupProject()) {
                this.rBlueJ.removeCompileListener(this.compileListenerForwarder);
                this.rBlueJ.removeClassListener(this.classStateManager);
                this.storeFrameState();
                for (RInvocationListener element : this.invocationListeners) {
                    this.rBlueJ.removeInvocationListener(element);
                }
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public static void closeAll() {
        try {
            GreenfootMain.getInstance().rBlueJ.exit();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    private void storeFrameState() {
        ProjectProperties projectProperties = this.project.getProjectProperties();
        projectProperties.setInt("mainWindow.width", this.frame.getWidth());
        projectProperties.setInt("mainWindow.height", this.frame.getHeight());
        Point loc = this.frame.getLocation();
        projectProperties.setInt("mainWindow.x", loc.x);
        projectProperties.setInt("mainWindow.y", loc.y);
        Class<?> cls = WorldHandler.getInstance().getLastWorldClass();
        if (cls != null) {
            projectProperties.setString("world.lastInstantiated", WorldHandler.getInstance().getLastWorldClass().getName());
        }
        projectProperties.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompileListener(CompileListener listener) {
        List<CompileListener> list = this.compileListeners;
        synchronized (list) {
            this.compileListeners.add(0, listener);
        }
    }

    public void addInvocationListener(RInvocationListener listener) throws RemoteException {
        this.invocationListeners.add(listener);
        this.rBlueJ.addInvocationListener(listener);
    }

    public void newProject() {
        String newname = GreenfootUtil.getNewProjectName(this.frame);
        if (newname != null) {
            try {
                File f = new File(newname);
                this.rBlueJ.newProject(f);
                if (this.isStartupProject()) {
                    this.project.close();
                }
            }
            catch (Exception exc) {
                Debug.reportError((String)"Problems when trying to create new scenario...", (Exception)exc);
            }
        }
    }

    public CallHistory getCallHistory() {
        return this.callHistory;
    }

    public ActorInstantiationListener getInvocationListener() {
        return this.instantiationListener;
    }

    public GreenfootFrame getFrame() {
        return this.frame;
    }

    private static void prepareGreenfootProject(File greenfootLibDir, File projectDir, ProjectProperties p, boolean deleteClassFiles) {
        if (GreenfootMain.isStartupProject(greenfootLibDir, projectDir)) {
            return;
        }
        File src = new File(greenfootLibDir, "skeletonProject");
        File dst = projectDir;
        if (deleteClassFiles) {
            GreenfootMain.deleteAllClassFiles(dst);
        }
        try {
            File pkhFile;
            File pkgFile = new File(dst, "bluej.pkg");
            if (pkgFile.exists()) {
                pkgFile.delete();
            }
            if ((pkhFile = new File(dst, "bluej.pkh")).exists()) {
                pkhFile.delete();
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        GreenfootUtil.copyDir(src, dst);
        GreenfootMain.touchApiClasses(dst);
        p.setApiVersion(GreenfootMain.getAPIVersion().toString());
        p.save();
    }

    private static void touchApiClasses(File projectDir) {
        File greenfootPkgDir = new File(projectDir, "greenfoot");
        File actorClassFile = new File(greenfootPkgDir, "Actor.class");
        File worldClassFile = new File(greenfootPkgDir, "World.class");
        long currentTime = System.currentTimeMillis();
        actorClassFile.setLastModified(currentTime);
        worldClassFile.setLastModified(currentTime);
    }

    public static int updateApi(File projectDir, Frame parent) {
        File greenfootLibDir = Config.getGreenfootLibDir();
        ProjectProperties newProperties = new ProjectProperties(projectDir);
        Version projectVersion = newProperties.getAPIVersion();
        Version apiVersion = GreenfootMain.getAPIVersion();
        if (apiVersion == null) {
            String message = Config.getString((String)"project.version.notGreenfoot") + projectDir;
            JButton continueButton = new JButton(Config.getString((String)"greenfoot.continue"));
            MessageDialog dialog = new MessageDialog(parent, message, Config.getString((String)"project.version.mismatch"), 50, new JButton[]{continueButton});
            dialog.displayModal();
            return 2;
        }
        if (projectVersion.isBad()) {
            String message = Config.getString((String)"project.version.none");
            JButton continueButton = new JButton(Config.getString((String)"greenfoot.continue"));
            MessageDialog dialog = new MessageDialog(parent, message, Config.getString((String)"project.version.mismatch"), 50, new JButton[]{continueButton});
            dialog.displayModal();
            Debug.message((String)("Bad version number in project: " + greenfootLibDir));
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, true);
            System.out.println("BAD VERSION");
            return 1;
        }
        if (projectVersion.isOlderAndBreaking(apiVersion)) {
            String message = Config.getString((String)"project.version.older.part1") + projectVersion + Config.getString((String)"project.version.older.part2") + apiVersion + Config.getString((String)"project.version.older.part3");
            JButton continueButton = new JButton(Config.getString((String)"greenfoot.continue"));
            MessageDialog dialog = new MessageDialog(parent, message, Config.getString((String)"project.version.mismatch"), 50, new JButton[]{continueButton});
            dialog.displayModal();
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, true);
            return 1;
        }
        if (apiVersion.isOlderAndBreaking(projectVersion)) {
            String message = Config.getString((String)"project.version.newer.part1") + projectVersion + Config.getString((String)"project.version.newer.part2");
            JButton cancelButton = new JButton(Config.getString((String)"greenfoot.cancel"));
            JButton continueButton = new JButton(Config.getString((String)"greenfoot.continue"));
            MessageDialog dialog = new MessageDialog(parent, message, Config.getString((String)"project.version.mismatch"), 50, new JButton[]{continueButton, cancelButton});
            JButton pressed = dialog.displayModal();
            if (pressed == cancelButton) {
                return 2;
            }
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, true);
            return 1;
        }
        if (projectVersion.isNonBreaking(apiVersion)) {
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, true);
            return 1;
        }
        if (projectVersion.isInternal(apiVersion)) {
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, false);
            return 1;
        }
        File greenfootDir = new File(projectDir, "greenfoot");
        if (!greenfootDir.exists()) {
            GreenfootMain.prepareGreenfootProject(greenfootLibDir, projectDir, newProperties, false);
        }
        return 0;
    }

    public static void deleteAllClassFiles(File dst) {
        GreenfootMain.deleteClassFiles(dst);
        File greenfootDir = new File(dst, "greenfoot");
        if (greenfootDir.canRead()) {
            GreenfootMain.deleteClassFiles(greenfootDir);
        }
    }

    private static void deleteClassFiles(File dir) {
        String[] classFiles = dir.list(classFilter);
        if (classFiles == null) {
            return;
        }
        for (int i = 0; i < classFiles.length; ++i) {
            String fileName = classFiles[i];
            File file = new File(dir, fileName);
            file.delete();
        }
    }

    public static boolean isStartupProject(File blueJLibDir, File projectDir) {
        File startupProject = new File(blueJLibDir, "startupProject");
        return startupProject.equals(projectDir);
    }

    public static Version getAPIVersion() {
        if (version == null) {
            try {
                Class<?> bootCls = Class.forName("bluej.Boot");
                Field field = bootCls.getField("GREENFOOT_API_VERSION");
                String versionStr = (String)field.get(null);
                version = new Version(versionStr);
            }
            catch (ClassNotFoundException e) {
                version = new Version("0.0.0");
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public static Class loadAndInitClass(String name) {
        return null;
    }

    private void checkClassLoader() {
        ClassLoader newLoader = ExecServer.getCurrentClassLoader();
        if (newLoader != this.currentLoader) {
            View.removeAll((ClassLoader)this.currentLoader);
            this.currentLoader = newLoader;
            ObjectTracker.clearRObjectCache();
        }
    }

    public void compileStarted(RCompileEvent event) {
        this.checkClassLoader();
    }

    public void compileSucceeded(RCompileEvent event) {
        this.checkClassLoader();
    }

    public void compileFailed(RCompileEvent event) {
        this.checkClassLoader();
    }

    public void compileError(RCompileEvent event) {
    }

    public void compileWarning(RCompileEvent event) {
    }

    static {
        classFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".class");
            }
        };
    }
}

