/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.Config;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import greenfoot.gui.FirstStartupDialog;
import greenfoot.util.FileChoosers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import rmiextension.RMIExtension;

public class GreenfootLauncherBlueJVM {
    private static GreenfootLauncherBlueJVM instance;
    private RMIExtension extension;
    private static final String STARTUP_PROJECT = "greenfoot/startupProject";
    private static final String TUTORIAL_SCENARIO = "wombats";
    private static final String TUTORIAL_FILE = "tutorial/tutorial.html";

    public static GreenfootLauncherBlueJVM getInstance() {
        if (instance == null) {
            instance = new GreenfootLauncherBlueJVM();
        }
        return instance;
    }

    public void launch(RMIExtension extension) {
        this.extension = extension;
        if (Utility.firstTimeEver((String)"greenfoot.run")) {
            this.handleFirstTime();
            return;
        }
        this.openNormally();
    }

    private void handleFirstTime() {
        FirstStartupDialog dialog = new FirstStartupDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        FirstStartupDialog.Result result = dialog.getResult();
        switch (result) {
            case TUTORIAL: {
                this.openTutorial();
                break;
            }
            case OPEN: {
                this.openScenario();
                break;
            }
            case CREATE: {
                this.createScenario();
                break;
            }
            case WITHOUT: {
                this.openNormally();
            }
        }
    }

    private void openTutorial() {
        this.setScenariosAsDefaultDir();
        File scenarioDir = null;
        try {
            String scenarioName = Config.getPropString((String)"greenfoot.tutorial.scenario", null);
            if (scenarioName == null) {
                scenarioName = TUTORIAL_SCENARIO;
            }
            scenarioDir = this.getScenarioDir(scenarioName);
        }
        catch (FileNotFoundException e) {
            Debug.reportError((String)"Error when attempting to open tutorial scenario on first startup", (Exception)e);
        }
        catch (IOException e) {
            Debug.reportError((String)"Error when attempting to open tutorial scenario on first startup", (Exception)e);
        }
        if (scenarioDir != null) {
            this.extension.openProject(scenarioDir);
        }
        File greenfootDir = null;
        try {
            greenfootDir = this.getGreenfootDir();
        }
        catch (IOException e) {
            Debug.reportError((String)"Error when attempting to open tutorial on first startup", (Exception)e);
            return;
        }
        String alternativeTutorial = Config.getPropString((String)"greenfoot.tutorial", null);
        if (alternativeTutorial == null) {
            File tutorial = new File(greenfootDir, TUTORIAL_FILE);
            if (tutorial.canRead()) {
                Utility.openWebBrowser((File)tutorial);
            } else {
                Debug.reportError((String)"Error when attempting to open tutorial on first startup", (Exception)new IOException());
            }
        } else {
            try {
                URL tutorial = new URL(alternativeTutorial);
                Utility.openWebBrowser((URL)tutorial);
            }
            catch (MalformedURLException e) {
                Debug.reportError((String)("Error when trying to open tutorial in alternative location: " + alternativeTutorial), (Exception)e);
            }
        }
    }

    private void openScenario() {
        this.setScenariosAsDefaultDir();
        File scenario = FileChoosers.getScenario(null);
        if (scenario != null) {
            this.extension.openProject(scenario);
        } else {
            System.exit(0);
        }
    }

    private void createScenario() {
        String newName = FileUtility.getFileName(null, (String)"New Scenario", (String)Config.getString((String)"pkgmgr.newPkg.buttonLabel"), (boolean)false, null, (boolean)true);
        File newDir = new File(newName);
        this.extension.newProject(newDir);
    }

    public void openNormally() {
        File blueJLibDir = Config.getBlueJLibDir();
        File startupProject = new File(blueJLibDir, STARTUP_PROJECT);
        this.extension.maybeOpenProject(startupProject);
    }

    private void setScenariosAsDefaultDir() {
        try {
            File startupDir = this.getScenariosDir();
            PrefMgr.setProjectDirectory((String)startupDir.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getScenariosDir() throws IOException {
        String alternativeScenarios = Config.getPropString((String)"greenfoot.scenarios", null);
        if (alternativeScenarios == null) {
            File greenfootDir = this.getGreenfootDir();
            return new File(greenfootDir, "scenarios");
        }
        return new File(alternativeScenarios);
    }

    private File getScenarioDir(String scenario) throws FileNotFoundException, IOException {
        File scenariosDir = this.getScenariosDir();
        File specificScenarioDir = new File(scenariosDir, scenario);
        if (specificScenarioDir.isDirectory()) {
            return specificScenarioDir;
        }
        throw new FileNotFoundException("Scenario not found: " + scenario + ". Tried to find it at: " + specificScenarioDir);
    }

    private File getGreenfootDir() throws IOException {
        File libDir = Config.getBlueJLibDir();
        File greenfootDir = libDir.getParentFile();
        if (Config.isMacOS()) {
            greenfootDir = greenfootDir.getParentFile().getParentFile().getParentFile();
        }
        if (!greenfootDir.isDirectory() || !greenfootDir.canRead()) {
            throw new IOException("Could not read from greenfoot directory: " + greenfootDir);
        }
        return greenfootDir;
    }
}

