/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.extensions.PackageAlreadyExistsException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.Debug;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GreenfootMain;
import greenfoot.core.InternalGreenfootError;
import greenfoot.core.ProjectProperties;
import greenfoot.event.CompileListener;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.event.RCompileEvent;
import rmiextension.wrappers.event.RProjectListenerImpl;

public class GProject
extends RProjectListenerImpl
implements CompileListener {
    private Map<RPackage, GPackage> packagePool = new HashMap<RPackage, GPackage>();
    private RProject rProject;
    private ProjectProperties projectProperties;
    private List<CompileListener> compileListeners = new LinkedList<CompileListener>();

    public GProject(RProject rmiProject) throws RemoteException {
        this.rProject = rmiProject;
        rmiProject.addListener(this);
        try {
            this.projectProperties = new ProjectProperties(this.getDir());
        }
        catch (Exception exc) {
            Debug.reportError((String)"Could not open greenfoot scenario properties");
            exc.printStackTrace();
        }
    }

    public void close() throws RemoteException {
        this.rProject.close();
    }

    public void save() throws ProjectNotOpenException, RemoteException {
        this.rProject.save();
    }

    public GPackage getDefaultPackage() throws ProjectNotOpenException, RemoteException {
        return this.getPackage("");
    }

    public GPackage getGreenfootPackage() throws ProjectNotOpenException, RemoteException {
        return this.getPackage("greenfoot");
    }

    public GPackage getPackage(String packageName) throws ProjectNotOpenException, RemoteException {
        RPackage rPkg = this.rProject.getPackage(packageName);
        if (rPkg == null) {
            return null;
        }
        return this.getPackage(rPkg);
    }

    public GPackage getPackage(RPackage pkg) {
        GPackage ret = this.packagePool.get(pkg);
        if (ret == null) {
            ret = new GPackage(pkg, this);
            this.packagePool.put(pkg, ret);
        }
        return ret;
    }

    public RPackage[] getPackages() throws ProjectNotOpenException, RemoteException {
        return this.rProject.getPackages();
    }

    public GPackage newPackage(String fullyQualifiedName) throws ProjectNotOpenException, PackageAlreadyExistsException, RemoteException {
        return this.getPackage(this.rProject.newPackage(fullyQualifiedName));
    }

    public RClass getRClass(String fullyQualifiedName) {
        try {
            String className;
            RPackage pkg;
            int lastDotIndex = fullyQualifiedName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                pkg = this.rProject.getPackage("");
                className = fullyQualifiedName;
            } else {
                pkg = this.rProject.getPackage(fullyQualifiedName.substring(0, lastDotIndex));
                className = fullyQualifiedName.substring(lastDotIndex + 1);
            }
            if (pkg == null) {
                return null;
            }
            return pkg.getRClass(className);
        }
        catch (RemoteException re) {
            throw new InternalGreenfootError(re);
        }
        catch (ProjectNotOpenException pnoe) {
            throw new InternalGreenfootError(pnoe);
        }
        catch (PackageNotFoundException pnfe) {
            throw new InternalGreenfootError(pnfe);
        }
    }

    public File getDir() throws ProjectNotOpenException, RemoteException {
        return this.rProject.getDir();
    }

    public String getName() {
        try {
            return this.rProject.getName();
        }
        catch (ProjectNotOpenException pnoe) {
            pnoe.printStackTrace();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return null;
    }

    public boolean inTestMode() {
        return false;
    }

    public ProjectProperties getProjectProperties() {
        return this.projectProperties;
    }

    public void openReadme() {
        try {
            this.rProject.openReadmeEditor();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (ProjectNotOpenException pnoe) {
            pnoe.printStackTrace();
        }
    }

    public RProject getRProject() {
        return this.rProject;
    }

    public void projectClosing() {
        GreenfootMain.getInstance().projectClosing();
    }

    public boolean isCompiled() {
        try {
            GClass[] classes = this.getDefaultPackage().getClasses();
            for (int i = 0; i < classes.length; ++i) {
                GClass cls = classes[i];
                if (cls.isCompiled()) continue;
                return false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileListener(CompileListener listener) {
        List<CompileListener> list = this.compileListeners;
        synchronized (list) {
            this.compileListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileListener(CompileListener listener) {
        List<CompileListener> list = this.compileListeners;
        synchronized (list) {
            this.compileListeners.remove(listener);
        }
    }

    public void compileError(RCompileEvent event) {
        this.delegateCompileEvent(event);
    }

    public void compileFailed(RCompileEvent event) {
        this.reloadClasses();
        this.delegateCompileEvent(event);
    }

    public void compileStarted(RCompileEvent event) {
        this.delegateCompileEvent(event);
    }

    public void compileSucceeded(RCompileEvent event) {
        this.reloadClasses();
        this.delegateCompileEvent(event);
    }

    public void compileWarning(RCompileEvent event) {
        this.delegateCompileEvent(event);
    }

    private void reloadClasses() {
        try {
            GClass[] classes;
            GPackage pkg = this.getDefaultPackage();
            for (GClass cls : classes = pkg.getClasses()) {
                cls.reload();
            }
        }
        catch (ProjectNotOpenException e) {
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException packageNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateCompileEvent(RCompileEvent event) {
        List<CompileListener> list = this.compileListeners;
        synchronized (list) {
            ArrayList<CompileListener> listeners = new ArrayList<CompileListener>(this.compileListeners);
            for (CompileListener listener : listeners) {
                try {
                    switch (event.getEvent()) {
                        case 1: {
                            listener.compileStarted(event);
                            break;
                        }
                        case 4: {
                            listener.compileSucceeded(event);
                            break;
                        }
                        case 5: {
                            listener.compileFailed(event);
                            break;
                        }
                        case 3: {
                            listener.compileError(event);
                            break;
                        }
                        case 2: {
                            listener.compileWarning(event);
                            break;
                        }
                    }
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }
    }

    public File getImageDir() {
        try {
            File projDir = this.getDir().getAbsoluteFile();
            File projImagesDir = new File(projDir, "images");
            projImagesDir.mkdir();
            return projImagesDir;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        return null;
    }
}

