/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.extensions.BObject;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.MissingJavaFileException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import greenfoot.core.GClass;
import greenfoot.core.GProject;
import greenfoot.util.GreenfootUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.RPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPackage {
    private RPackage pkg;
    private GProject project;
    private Map<RClass, GClass> classPool = new HashMap<RClass, GClass>();

    public GPackage(RPackage pkg, GProject project) {
        if (pkg == null) {
            throw new NullPointerException("Pkg must not be null.");
        }
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        this.pkg = pkg;
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GClass getGClass(RClass remoteClass) {
        GClass gClass;
        if (remoteClass == null) {
            return null;
        }
        Map<RClass, GClass> map = this.classPool;
        synchronized (map) {
            gClass = this.classPool.get(remoteClass);
            if (gClass == null) {
                gClass = new GClass(remoteClass, this);
                this.classPool.put(remoteClass, gClass);
            }
        }
        return gClass;
    }

    public void compile(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, RemoteException, CompilationNotStartedException {
        this.pkg.compile(waitCompileEnd);
    }

    public void compileAll(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, RemoteException, CompilationNotStartedException {
        this.pkg.compileAll(waitCompileEnd);
    }

    public File getDir() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.pkg.getDir();
    }

    public String getName() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.pkg.getName();
    }

    public RObject getObject(String instanceName) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.pkg.getObject(instanceName);
    }

    public BObject[] getObjects() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.pkg.getObjects();
    }

    public GProject getProject() throws ProjectNotOpenException, RemoteException {
        return this.project;
    }

    public GClass[] getClasses() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        RClass[] rClasses = this.pkg.getRClasses();
        GClass[] gClasses = new GClass[rClasses.length];
        for (int i = 0; i < rClasses.length; ++i) {
            RClass rClass = rClasses[i];
            gClasses[i] = this.getGClass(rClass);
        }
        return gClasses;
    }

    public String invokeConstructor(String className, String[] argTypes, String[] args) throws RemoteException {
        return this.pkg.invokeConstructor(className, argTypes, args);
    }

    public String invokeMethod(String className, String methodName, String[] argTypes, String[] args) throws RemoteException {
        return this.pkg.invokeMethod(className, methodName, argTypes, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GClass newClass(String className) {
        GClass newClass = null;
        try {
            RClass newRClass = this.pkg.newClass(className);
            newClass = new GClass(newRClass, this);
            Map<RClass, GClass> map = this.classPool;
            synchronized (map) {
                this.classPool.put(newRClass, newClass);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (ProjectNotOpenException pnoe) {
            pnoe.printStackTrace();
        }
        catch (PackageNotFoundException pnfe) {
            pnfe.printStackTrace();
        }
        catch (MissingJavaFileException mjfe) {
            mjfe.printStackTrace();
        }
        return newClass;
    }

    public GClass getClass(String className) {
        try {
            RClass rClass = this.pkg.getRClass(className);
            return this.getGClass(rClass);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (ProjectNotOpenException pnoe) {
            pnoe.printStackTrace();
        }
        catch (PackageNotFoundException pnfe) {
            pnfe.printStackTrace();
        }
        return null;
    }

    public void reload() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        this.pkg.reload();
    }

    public void deleteClassFiles() {
        try {
            GClass[] classes = this.getClasses();
            for (int i = 0; i < classes.length; ++i) {
                GClass cls = classes[i];
                File classFile = new File(this.getDir(), cls.getName() + ".class");
                classFile.delete();
            }
            this.reload();
        }
        catch (ProjectNotOpenException e) {
        }
        catch (PackageNotFoundException e) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.pkg.close();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public List<Class<?>> getWorldClasses() {
        LinkedList worldClasses = new LinkedList();
        try {
            GClass[] classes = this.getClasses();
            for (int i = 0; i < classes.length; ++i) {
                Class realClass;
                GClass cls = classes[i];
                if (!cls.isWorldSubclass() || !GreenfootUtil.canBeInstantiated(realClass = cls.getJavaClass())) continue;
                worldClasses.add(realClass);
            }
        }
        catch (ProjectNotOpenException e1) {
            e1.printStackTrace();
        }
        catch (PackageNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        return worldClasses;
    }
}

