/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.extensions.BField;
import bluej.extensions.BMethod;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.parser.ClassParser;
import bluej.parser.symtab.ClassInfo;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.ProjectProperties;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.util.GreenfootUtil;
import java.awt.EventQueue;
import java.io.File;
import java.rmi.RemoteException;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RConstructor;
import rmiextension.wrappers.RField;

public class GClass {
    private static String simObj = "greenfoot.Actor";
    private static String worldObj = "greenfoot.World";
    private RClass rmiClass;
    private GPackage pkg;
    private String superclassGuess;
    private boolean compiled;
    private ClassView classView;
    private Class realClass;

    public GClass(RClass cls, GPackage pkg) {
        this.rmiClass = cls;
        this.pkg = pkg;
        String savedSuperclass = this.getClassProperty("superclass");
        if (savedSuperclass == null) {
            this.guessSuperclass();
        } else {
            this.superclassGuess = savedSuperclass;
        }
        try {
            this.compiled = cls.isCompiled();
            if (this.compiled) {
                this.loadRealClass();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (PackageNotFoundException pnfe) {
            pnfe.printStackTrace();
        }
        catch (ProjectNotOpenException pnoe) {
            pnoe.printStackTrace();
        }
    }

    public void setClassView(ClassView view) {
        this.classView = view;
    }

    public void nameChanged(final String oldName) {
        try {
            ProjectProperties props = this.pkg.getProject().getProjectProperties();
            String superClass = props.removeProperty("class." + oldName + ".superclass");
            String classImage = props.removeProperty("class." + oldName + ".image");
            props.removeCachedImage(oldName);
            this.setClassProperty("superclass", superClass);
            if (classImage != null) {
                this.setClassProperty("image", classImage);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (ProjectNotOpenException projectNotOpenException) {
            // empty catch block
        }
        if (this.classView != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    GClass.this.classView.nameChanged(oldName);
                }
            });
        }
    }

    public String getClassProperty(String propertyName) {
        try {
            return this.pkg.getProject().getProjectProperties().getString("class." + this.getName() + "." + propertyName);
        }
        catch (ProjectNotOpenException e) {
            return null;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void setClassProperty(String propertyName, String value) {
        try {
            this.pkg.getProject().getProjectProperties().setString("class." + this.getName() + "." + propertyName, value);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Debug.reportError((String)("Greenfoot: Could not set class property: " + this.getName() + "." + propertyName));
        }
    }

    public void compile(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, RemoteException, CompilationNotStartedException {
        this.rmiClass.compile(waitCompileEnd);
    }

    public void edit() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        if (this.isWorldClass() || this.isActorClass()) {
            this.rmiClass.setReadOnly(true);
        }
        this.rmiClass.edit();
    }

    public void remove() throws ProjectNotOpenException, PackageNotFoundException, bluej.extensions.ClassNotFoundException, RemoteException {
        ProjectProperties props = this.pkg.getProject().getProjectProperties();
        props.removeProperty("class." + this.getName() + ".superclass");
        props.removeProperty("class." + this.getName() + ".image");
        props.removeCachedImage(this.getName());
        this.rmiClass.remove();
    }

    public RConstructor getConstructor(Class[] signature) throws ProjectNotOpenException, bluej.extensions.ClassNotFoundException, RemoteException {
        return this.rmiClass.getConstructor(signature);
    }

    public RConstructor[] getConstructors() throws ProjectNotOpenException, bluej.extensions.ClassNotFoundException, RemoteException {
        return this.rmiClass.getConstructors();
    }

    public BMethod getDeclaredMethod(String methodName, Class[] params) throws ProjectNotOpenException, bluej.extensions.ClassNotFoundException, RemoteException {
        return this.rmiClass.getDeclaredMethod(methodName, params);
    }

    public BMethod[] getDeclaredMethods() throws ProjectNotOpenException, bluej.extensions.ClassNotFoundException, RemoteException {
        return this.rmiClass.getDeclaredMethods();
    }

    public RField getField(String fieldName) throws ProjectNotOpenException, bluej.extensions.ClassNotFoundException, RemoteException {
        return this.rmiClass.getField(fieldName);
    }

    public BField[] getFields() throws ProjectNotOpenException, bluej.extensions.ClassNotFoundException, RemoteException {
        return this.rmiClass.getFields();
    }

    public Class getJavaClass() {
        return this.realClass;
    }

    public GPackage getPackage() {
        return this.pkg;
    }

    public String getQualifiedName() {
        try {
            return this.rmiClass.getQualifiedName();
        }
        catch (RemoteException e) {
        }
        catch (ProjectNotOpenException e) {
        }
        catch (bluej.extensions.ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        return GreenfootUtil.extractClassName(this.getQualifiedName());
    }

    public GClass getSuperclass() {
        try {
            GProject proj = this.pkg.getProject();
            String superclassName = this.getSuperclassGuess();
            if (superclassName == null) {
                return null;
            }
            String superclassPkg = GreenfootUtil.extractPackageName(superclassName);
            superclassName = GreenfootUtil.extractClassName(superclassName);
            GPackage thePkg = proj.getPackage(superclassPkg);
            if (thePkg == null) {
                return null;
            }
            return thePkg.getClass(superclassName);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return null;
        }
        catch (ProjectNotOpenException pnoe) {
            pnoe.printStackTrace();
            return null;
        }
    }

    public String getSuperclassGuess() {
        return this.superclassGuess;
    }

    public void setSuperclassGuess(String superclassName) {
        if (this.superclassGuess != superclassName) {
            this.superclassGuess = superclassName;
            this.setClassProperty("superclass", this.superclassGuess);
        }
    }

    private void guessSuperclass() {
        String name = this.getName();
        if (name.equals("World") || name.equals("Actor")) {
            this.setSuperclassGuess("");
            return;
        }
        String realSuperclass = null;
        try {
            if (this.isCompiled()) {
                realSuperclass = this.rmiClass.getSuperclass().getQualifiedName();
            }
        }
        catch (RemoteException e) {
        }
        catch (ProjectNotOpenException e) {
        }
        catch (PackageNotFoundException e) {
        }
        catch (bluej.extensions.ClassNotFoundException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (realSuperclass != null) {
            this.setSuperclassGuess(realSuperclass);
            return;
        }
        if (realSuperclass == null && this.isCompiled()) {
            this.setSuperclassGuess("");
            return;
        }
        String parsedSuperclass = null;
        try {
            ClassInfo info = ClassParser.parse((File)this.rmiClass.getJavaFile());
            parsedSuperclass = info.getSuperclass();
            if (parsedSuperclass.equals("Actor")) {
                parsedSuperclass = "greenfoot.Actor";
            }
            if (parsedSuperclass.equals("World")) {
                parsedSuperclass = "greenfoot.World";
            }
        }
        catch (ProjectNotOpenException e) {
        }
        catch (PackageNotFoundException e) {
        }
        catch (RemoteException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        if (parsedSuperclass != null) {
            this.setSuperclassGuess(parsedSuperclass);
            return;
        }
    }

    private String removeQualification(String classname) {
        int lastDotIndex = classname.lastIndexOf(".");
        if (lastDotIndex != -1) {
            return classname.substring(lastDotIndex + 1);
        }
        return classname;
    }

    public String getToString() {
        try {
            return this.rmiClass.getToString();
        }
        catch (RemoteException e) {
        }
        catch (ProjectNotOpenException e) {
        }
        catch (bluej.extensions.ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return "Error getting real toString. super:" + super.toString();
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public void setCompiledState(boolean isCompiled) {
        this.compiled = isCompiled;
        if (this.classView != null) {
            this.classView.repaint();
        }
        if (isCompiled) {
            this.loadRealClass();
        } else {
            this.realClass = null;
        }
    }

    public boolean isSubclassOf(String className) {
        className = this.removeQualification(className);
        if (this.getName().equals(className)) {
            return false;
        }
        for (GClass superclass = this; superclass != null; superclass = superclass.getSuperclass()) {
            String superclassName = superclass.getSuperclassGuess();
            if (superclassName == null) {
                superclassName = "";
            }
            if (superclassName == null || !className.equals(this.removeQualification(superclassName))) continue;
            return true;
        }
        return false;
    }

    public void reload() {
        this.loadRealClass();
        this.guessSuperclass();
        if (this.classView != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    GClass.this.classView.updateView();
                }
            });
        }
    }

    private void loadRealClass() {
        Class<?> cls = null;
        if (!this.isCompiled()) {
            this.realClass = null;
            return;
        }
        try {
            String className = this.getQualifiedName();
            ClassLoader classLdr = ExecServer.getCurrentClassLoader();
            cls = Class.forName(className, false, classLdr);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (LinkageError e) {
            e.printStackTrace();
        }
        this.realClass = cls;
    }

    public boolean isActorClass() {
        return this.getQualifiedName().equals(simObj);
    }

    public boolean isWorldClass() {
        return this.getQualifiedName().equals(worldObj);
    }

    public boolean isActorSubclass() {
        return this.isSubclassOf(simObj);
    }

    public boolean isWorldSubclass() {
        return this.isSubclassOf(worldObj);
    }
}

