/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import java.rmi.RemoteException;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.event.RClassEvent;
import rmiextension.wrappers.event.RClassListenerImpl;

public class ClassStateManager
extends RClassListenerImpl {
    private GProject project;

    public ClassStateManager(GProject project) throws RemoteException {
        this.project = project;
    }

    public void classStateChanged(RClassEvent event) throws RemoteException {
        RClass eventClass = event.getRClass();
        int eventId = event.getEventId();
        try {
            RProject eventProject = eventClass.getPackage().getProject();
            if (!this.project.getRProject().equals(eventProject)) {
                return;
            }
            GPackage pkg = this.project.getPackage(eventClass.getPackage());
            GClass gClass = pkg.getGClass(eventClass);
            if (eventId == 0) {
                boolean compiled = event.isClassCompiled();
                gClass.setCompiledState(compiled);
            } else if (eventId == 1) {
                gClass.nameChanged(event.getOldName());
            }
        }
        catch (PackageNotFoundException pnfe) {
        }
        catch (ProjectNotOpenException pnoe) {
            // empty catch block
        }
    }
}

