/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision.ibsp;

public class Rect {
    private int x;
    private int y;
    private int width;
    private int height;

    public Rect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return "rect (" + this.x + "," + this.y + ")-(" + (this.x + this.width) + "," + (this.y + this.height) + ")";
    }

    public int getX() {
        return this.x;
    }

    public int getMiddleX() {
        return this.x + this.width / 2;
    }

    public int getRight() {
        return this.x + this.width;
    }

    public int getY() {
        return this.y;
    }

    public int getMiddleY() {
        return this.y + this.height / 2;
    }

    public int getTop() {
        return this.y + this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean contains(Rect other) {
        return this.x <= other.x && this.y <= other.y && this.getTop() >= other.getTop() && this.getRight() >= other.getRight();
    }

    public static Rect getIntersection(Rect a, Rect b) {
        int a_x = a.getX();
        int a_r = a.getRight();
        int a_y = a.getY();
        int a_t = a.getTop();
        int b_x = b.getX();
        int b_r = b.getRight();
        int b_y = b.getY();
        int b_t = b.getTop();
        int i_x = Math.max(a_x, b_x);
        int i_r = Math.min(a_r, b_r);
        int i_y = Math.max(a_y, b_y);
        int i_t = Math.min(a_t, b_t);
        if (i_x >= i_r || i_y >= i_t) {
            return null;
        }
        return new Rect(i_x, i_y, i_r - i_x, i_t - i_y);
    }

    public static boolean equals(Rect a, Rect b) {
        return a.x == b.x && a.y == b.y && a.width == b.width && a.height == b.height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

