/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision.ibsp;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.collision.ClassQuery;
import greenfoot.collision.CollisionChecker;
import greenfoot.collision.CollisionQuery;
import greenfoot.collision.GOCollisionQuery;
import greenfoot.collision.InRangeQuery;
import greenfoot.collision.NeighbourCollisionQuery;
import greenfoot.collision.PointCollisionQuery;
import greenfoot.collision.ibsp.ActorNode;
import greenfoot.collision.ibsp.BSPNode;
import greenfoot.collision.ibsp.Rect;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBSPColChecker
implements CollisionChecker {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int PARENT_LEFT = 0;
    public static final int PARENT_RIGHT = 1;
    public static final int PARENT_NONE = 3;
    public static final int REBALANCE_THRESHOLD = 20;
    private GOCollisionQuery actorQuery = new GOCollisionQuery();
    private NeighbourCollisionQuery neighbourQuery = new NeighbourCollisionQuery();
    private PointCollisionQuery pointQuery = new PointCollisionQuery();
    private InRangeQuery inRangeQuery = new InRangeQuery();
    private int cellSize;
    private BSPNode bspTree;
    private Rect allArea = new Rect(-1073741823, -1073741823, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static boolean debugging = false;
    private static int dbgCounter = 0;

    @Override
    public void initialize(int width, int height, int cellSize, boolean wrap) {
        this.cellSize = cellSize;
        this.allArea = new Rect(0, 0, width * cellSize, height * cellSize);
    }

    @Override
    public void addObject(Actor actor) {
        Rect bounds = this.getActorBounds(actor);
        this.insertObject(actor, bounds, bounds, this.allArea, null, this.bspTree, 3);
    }

    private BSPNode insertObject(Actor actor, Rect actorBounds, Rect bounds, Rect area, BSPNode parent, BSPNode node, int parentSide) {
        if (node == null) {
            if (area.getHeight() > area.getWidth()) {
                int middle = area.getMiddleY();
                node = new BSPNode(area, 1, middle);
            } else {
                int middle = area.getMiddleX();
                node = new BSPNode(area, 0, middle);
            }
            node.addActor(actor);
            if (parent == null) {
                this.bspTree = node;
            } else {
                parent.setChild(parentSide, node);
            }
            return node;
        }
        if (node.containsActor(actor)) {
            return node;
        }
        if (node.isEmpty() || area.getWidth() <= actorBounds.getWidth() && area.getHeight() <= actorBounds.getHeight()) {
            node.addActor(actor);
            return node;
        }
        Rect leftArea = node.getLeftArea();
        Rect rightArea = node.getRightArea();
        BSPNode lnode = null;
        Rect leftIntersects = Rect.getIntersection(leftArea, bounds);
        Rect rightIntersects = Rect.getIntersection(rightArea, bounds);
        if (leftIntersects != null) {
            lnode = this.insertObject(actor, actorBounds, leftIntersects, leftArea, node, node.getLeft(), 0);
        }
        if (rightIntersects != null) {
            BSPNode rnode = this.insertObject(actor, actorBounds, rightIntersects, rightArea, node, node.getRight(), 1);
            if (lnode == null) {
                return rnode;
            }
        }
        return lnode;
    }

    public void rebalance(BSPNode node) {
    }

    public final Rect getActorBounds(Actor actor) {
        Rect r = ActorVisitor.getBoundingRect(actor);
        return r;
    }

    public static void printTree(BSPNode node, String indent, String lead) {
        if (node == null) {
            return;
        }
        String xx = lead;
        xx = xx + node + ": ";
        xx = xx + node.getArea();
        IBSPColChecker.println(xx);
        BSPNode left = node.getLeft();
        BSPNode right = node.getRight();
        if (left != null) {
            String newIndent = right != null ? indent + " |" : indent + "  ";
            IBSPColChecker.printTree(left, newIndent, indent + " \\L-");
        }
        if (right != null) {
            IBSPColChecker.printTree(node.getRight(), indent + "  ", indent + " \\R-");
        }
    }

    public void printTree() {
        IBSPColChecker.printTree(this.bspTree, "", "");
    }

    @Override
    public void removeObject(Actor object) {
        ActorNode node = IBSPColChecker.getNodeForActor(object);
        while (node != null) {
            BSPNode bspNode = node.getBSPNode();
            node.remove();
            this.checkRemoveNode(bspNode);
            node = IBSPColChecker.getNodeForActor(object);
        }
    }

    private BSPNode checkRemoveNode(BSPNode node) {
        while (node != null && node.isEmpty()) {
            BSPNode parent = node.getParent();
            int side = parent != null ? parent.getChildSide(node) : 3;
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left == null) {
                if (parent != null) {
                    parent.setChild(side, right);
                } else {
                    this.bspTree = right;
                    if (right != null) {
                        right.setArea(this.allArea);
                    }
                }
                node = parent;
                continue;
            }
            if (right != null) break;
            if (parent != null) {
                parent.setChild(side, left);
            } else {
                this.bspTree = left;
                if (left != null) {
                    left.setArea(this.allArea);
                }
            }
            node = parent;
        }
        return node;
    }

    private static void println(String s) {
        if (dbgCounter < 3000) {
            System.out.println(s);
        }
    }

    public static ActorNode getNodeForActor(Actor object) {
        return (ActorNode)ActorVisitor.getData(object);
    }

    public static void setNodeForActor(Actor object, ActorNode node) {
        ActorVisitor.setData(object, node);
    }

    private void updateObject(Actor object) {
        Rect bspArea;
        BSPNode bspNode;
        ActorNode node = IBSPColChecker.getNodeForActor(object);
        if (node == null) {
            return;
        }
        Rect newBounds = this.getActorBounds(object);
        newBounds = Rect.getIntersection(newBounds, this.allArea);
        while (node != null) {
            bspNode = node.getBSPNode();
            bspArea = bspNode.getArea();
            if (bspArea.contains(newBounds)) {
                for (ActorNode iter = IBSPColChecker.getNodeForActor(object); iter != null; iter = iter.getNext()) {
                    if (iter == node) continue;
                    BSPNode rNode = iter.getBSPNode();
                    iter.remove();
                    this.checkRemoveNode(rNode);
                }
                return;
            }
            if (Rect.getIntersection(bspArea, newBounds) == null) {
                BSPNode rNode = node.getBSPNode();
                node.remove();
                this.checkRemoveNode(rNode);
            }
            node.clearMark();
            node = node.getNext();
        }
        node = IBSPColChecker.getNodeForActor(object);
        if (node != null) {
            bspNode = node.getBSPNode();
            while (!bspNode.getArea().contains(newBounds)) {
                bspNode = bspNode.getParent();
            }
        } else {
            bspNode = this.bspTree;
        }
        bspArea = bspNode != null ? bspNode.getArea() : this.allArea;
        this.insertObject(object, newBounds, newBounds, bspArea, null, bspNode, 3);
        for (node = IBSPColChecker.getNodeForActor(object); node != null; node = node.getNext()) {
            if (node.checkMark()) continue;
            bspNode = node.getBSPNode();
            node.remove();
            this.checkRemoveNode(bspNode);
        }
    }

    @Override
    public void updateObjectLocation(Actor object, int oldX, int oldY) {
        this.updateObject(object);
    }

    @Override
    public void updateObjectSize(Actor object) {
        this.updateObject(object);
    }

    private List<Actor> getIntersectingObjects(Rect r, CollisionQuery query) {
        HashSet<Actor> set = new HashSet<Actor>();
        this.getIntersectingObjects(r, query, set, this.bspTree);
        ArrayList<Actor> l = new ArrayList<Actor>(set);
        return l;
    }

    private void getIntersectingObjects(Rect r, CollisionQuery query, Set<Actor> resultSet, BSPNode startNode) {
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        if (startNode != null) {
            nodeStack.add(startNode);
        }
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            if (Rect.getIntersection(node.getArea(), r) == null) continue;
            Iterator<Actor> i = node.getActorsIterator();
            while (i.hasNext()) {
                Actor actor = i.next();
                if (!query.checkCollision(actor) || resultSet.contains(actor)) continue;
                resultSet.add(actor);
            }
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left != null) {
                nodeStack.add(left);
            }
            if (right == null) continue;
            nodeStack.add(right);
        }
    }

    private Actor checkForOneCollision(Actor ignore, BSPNode node, CollisionQuery query) {
        Iterator<Actor> i = node.getActorsIterator();
        while (i.hasNext()) {
            Actor candidate = i.next();
            if (ignore == candidate || !query.checkCollision(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private Actor getOneObjectDownTree(Actor ignore, Rect r, CollisionQuery query, BSPNode startNode) {
        if (startNode == null) {
            return null;
        }
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        nodeStack.add(startNode);
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            if (Rect.getIntersection(node.getArea(), r) == null) continue;
            Actor res = this.checkForOneCollision(ignore, node, query);
            if (res != null) {
                return res;
            }
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left != null) {
                nodeStack.add(left);
            }
            if (right == null) continue;
            nodeStack.add(right);
        }
        return null;
    }

    private Actor getOneIntersectingDown(Rect r, CollisionQuery query, Actor actor) {
        if (this.bspTree == null) {
            return null;
        }
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        nodeStack.add(this.bspTree);
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            if (!node.getArea().contains(r)) continue;
            Actor res = this.checkForOneCollision(actor, node, query);
            if (res != null) {
                return res;
            }
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left != null) {
                nodeStack.add(left);
            }
            if (right == null) continue;
            nodeStack.add(right);
        }
        return null;
    }

    public Actor getOneIntersectingUp(Rect r, CollisionQuery query, Actor actor, BSPNode start) {
        while (start != null && !start.getArea().contains(r)) {
            Actor res = this.checkForOneCollision(actor, start, query);
            if (res != null) {
                return res;
            }
            start = start.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> List<T> getObjectsAt(int x, int y, Class<T> cls) {
        PointCollisionQuery pointCollisionQuery = this.pointQuery;
        synchronized (pointCollisionQuery) {
            this.pointQuery.init(x, y, cls);
            return this.getIntersectingObjects(new Rect(x * this.cellSize, y * this.cellSize, this.cellSize, this.cellSize), this.pointQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> List<T> getIntersectingObjects(Actor actor, Class<T> cls) {
        Rect r = this.getActorBounds(actor);
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, actor);
            return this.getIntersectingObjects(r, this.actorQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> List<T> getObjectsInRange(int x, int y, int r, Class<T> cls) {
        List<Actor> result;
        int halfCell = this.cellSize / 2;
        int size = 2 * r * this.cellSize;
        Rect rect = new Rect((x - r) * this.cellSize + halfCell, (y - r) * this.cellSize + halfCell, size, size);
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, null);
            result = this.getIntersectingObjects(rect, this.actorQuery);
        }
        Iterator<Actor> i = result.iterator();
        InRangeQuery inRangeQuery = this.inRangeQuery;
        synchronized (inRangeQuery) {
            this.inRangeQuery.init(x * this.cellSize + halfCell, y * this.cellSize + halfCell, r * this.cellSize);
            while (i.hasNext()) {
                if (this.inRangeQuery.checkCollision(i.next())) continue;
                i.remove();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> List<T> getNeighbours(Actor actor, int distance, boolean diag, Class<T> cls) {
        int x = actor.getX();
        int y = actor.getY();
        int xPixel = x * this.cellSize;
        int yPixel = y * this.cellSize;
        int dPixel = distance * this.cellSize;
        Rect r = new Rect(xPixel - dPixel, yPixel - dPixel, dPixel * 2 + 1, dPixel * 2 + 1);
        NeighbourCollisionQuery neighbourCollisionQuery = this.neighbourQuery;
        synchronized (neighbourCollisionQuery) {
            this.neighbourQuery.init(x, y, distance, diag, cls);
            List<Actor> res = this.getIntersectingObjects(r, this.neighbourQuery);
            return res;
        }
    }

    @Override
    public <T extends Actor> List<T> getObjectsInDirection(int x, int y, int angle, int length, Class<T> cls) {
        return new ArrayList();
    }

    @Override
    public <T extends Actor> List<T> getObjects(Class<T> cls) {
        HashSet<Actor> set = new HashSet<Actor>();
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        if (this.bspTree != null) {
            nodeStack.add(this.bspTree);
        }
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            Iterator<Actor> i = node.getActorsIterator();
            while (i.hasNext()) {
                Actor actor = i.next();
                if (cls != null && !cls.isInstance(actor)) continue;
                set.add(actor);
            }
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left != null) {
                nodeStack.add(left);
            }
            if (right == null) continue;
            nodeStack.add(right);
        }
        ArrayList list = new ArrayList(set);
        return list;
    }

    @Override
    public List<Actor> getObjectsList() {
        return this.getObjects(null);
    }

    @Override
    public final void startSequence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> T getOneObjectAt(Actor object, int dx, int dy, Class<T> cls) {
        PointCollisionQuery pointCollisionQuery = this.pointQuery;
        synchronized (pointCollisionQuery) {
            this.pointQuery.init(dx, dy, cls);
            CollisionQuery query = this.pointQuery;
            if (cls != null) {
                query = new ClassQuery(cls, this.pointQuery);
            }
            return (T)this.getOneIntersectingDown(new Rect(dx * this.cellSize + this.cellSize / 2, dy * this.cellSize + this.cellSize / 2, 1, 1), query, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Actor getOneIntersectingObject(Actor actor, Class cls) {
        Rect r = this.getActorBounds(actor);
        r = Rect.getIntersection(r, this.allArea);
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, actor);
            ActorNode node = IBSPColChecker.getNodeForActor(actor);
            do {
                BSPNode bspNode;
                Actor ret;
                if ((ret = this.getOneObjectDownTree(actor, r, this.actorQuery, bspNode = node.getBSPNode())) != null) {
                    return ret;
                }
                ret = this.getOneIntersectingUp(r, this.actorQuery, actor, bspNode.getParent());
                if (ret == null) continue;
                return ret;
            } while ((node = node.getNext()) != null);
            return this.getOneIntersectingDown(r, this.actorQuery, actor);
        }
    }

    @Override
    public void paintDebug(Graphics g) {
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        nodeStack.add(this.bspTree);
        Color oldColor = g.getColor();
        g.setColor(Color.RED);
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            if (node == null) continue;
            Rect area = node.getArea();
            g.drawRect(area.getX(), area.getY(), area.getWidth(), area.getHeight());
            nodeStack.add(node.getLeft());
            nodeStack.add(node.getRight());
        }
        g.setColor(oldColor);
    }
}

