/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.Actor;
import greenfoot.collision.CollisionQuery;

public class NeighbourCollisionQuery
implements CollisionQuery {
    private int x;
    private int y;
    private int distance;
    private boolean diag;
    private Class cls;

    public void init(int x, int y, int distance, boolean diag, Class cls) {
        if (distance < 0) {
            throw new IllegalArgumentException("Distance must not be less than 0. It was: " + distance);
        }
        this.x = x;
        this.y = y;
        this.distance = distance;
        this.diag = diag;
        this.cls = cls;
    }

    public boolean checkCollision(Actor actor) {
        int dy;
        if (this.cls != null && !this.cls.isInstance(actor)) {
            return false;
        }
        if (actor.getX() == this.x && actor.getY() == this.y) {
            return false;
        }
        if (this.diag) {
            int x1 = this.x - this.distance;
            int y1 = this.y - this.distance;
            int x2 = this.x + this.distance;
            int y2 = this.y + this.distance;
            return actor.getX() >= x1 && actor.getY() >= y1 && actor.getX() <= x2 && actor.getY() <= y2;
        }
        int dx = Math.abs(actor.getX() - this.x);
        return dx + (dy = Math.abs(actor.getY() - this.y)) <= this.distance;
    }
}

