/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.collision.CollisionChecker;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridCollisionChecker
implements CollisionChecker {
    private Set objects;
    private static List emptyList = new Vector();
    private boolean wrap;
    private GridWorld world;
    private Statistics currentStats = new Statistics();
    private List allStats = new ArrayList();
    private static boolean PRINT_STATS = false;

    @Override
    public void initialize(int width, int height, int cellSize, boolean wrap) {
        this.wrap = wrap;
        this.objects = null;
        if (PRINT_STATS) {
            System.out.println(Statistics.headerString());
            this.objects = new TreeSet(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    int compare = arg0.hashCode() - arg1.hashCode();
                    if (compare == 0 && !arg0.equals(arg1)) {
                        System.err.println("Write the developers that they should fix the GridCollisionChecker!");
                    }
                    return compare;
                }
            });
        } else {
            this.objects = new HashSet();
        }
        this.world = wrap ? new WrappingGridWorld(width, height) : new GridWorld(width, height);
    }

    @Override
    public synchronized void addObject(Actor thing) throws ArrayIndexOutOfBoundsException {
        this.testBounds(thing);
        if (!this.objects.contains(thing)) {
            Cell cell = this.world.get(thing.getX(), thing.getY());
            if (cell == null) {
                cell = new Cell();
                this.world.set(thing.getX(), thing.getY(), cell);
            }
            cell.add(thing);
            this.objects.add(thing);
        }
    }

    private void testBounds(Actor thing) {
        if (thing.getX() >= this.getWidth()) {
            throw new ArrayIndexOutOfBoundsException(thing.getX());
        }
        if (thing.getY() >= this.getHeight()) {
            throw new ArrayIndexOutOfBoundsException(thing.getY());
        }
        if (thing.getX() < 0) {
            throw new ArrayIndexOutOfBoundsException(thing.getX());
        }
        if (thing.getY() < 0) {
            throw new ArrayIndexOutOfBoundsException(thing.getY());
        }
    }

    public List getObjectsAt(int x, int y, Class cls) {
        if (this.wrap) {
            x = this.wrap(x, this.world.getWidth());
            y = this.wrap(y, this.world.getWidth());
        }
        ArrayList<Actor> objectsThere = new ArrayList<Actor>();
        Iterator iter = this.objects.iterator();
        while (iter.hasNext()) {
            this.currentStats.incGetObjectsAt();
            Actor actor = (Actor)iter.next();
            if (cls != null && !cls.isInstance(actor) || !ActorVisitor.contains(actor, x - actor.getX(), y - actor.getY())) continue;
            objectsThere.add(actor);
        }
        return objectsThere;
    }

    public List getObjectsInRange(int x, int y, int r, Class cls) {
        Iterator iter = this.objects.iterator();
        ArrayList<Actor> neighbours = new ArrayList<Actor>();
        while (iter.hasNext()) {
            Actor g;
            Object o = iter.next();
            this.currentStats.incGetObjectsInRange();
            if (cls != null && !cls.isInstance(o) || !(this.distance(x, y, g = (Actor)o) <= (double)r)) continue;
            neighbours.add(g);
        }
        return neighbours;
    }

    private double distance(int x, int y, Actor actor) {
        double gx = actor.getX();
        double gy = actor.getY();
        double dx = Math.abs(gx - (double)x);
        double dy = Math.abs(gy - (double)y);
        if (this.wrap) {
            double dxWrap = (double)this.getWidth() - dx;
            double dyWrap = (double)this.getWidth() - dy;
            if (dx >= dxWrap) {
                dx = dxWrap;
            }
            if (dy >= dyWrap) {
                dy = dyWrap;
            }
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public synchronized void removeObject(Actor object) {
        Cell cell = this.world.get(object.getX(), object.getY());
        if (cell != null) {
            cell.remove(object);
            if (cell.isEmpty()) {
                this.world.set(object.getX(), object.getY(), null);
            }
        }
        this.objects.remove(object);
    }

    public int getWidth() {
        return this.world.getWidth();
    }

    public int getHeight() {
        return this.world.getHeight();
    }

    @Override
    public void updateObjectLocation(Actor object, int oldX, int oldY) {
        Cell cell = this.world.get(oldX, oldY);
        if (cell != null) {
            cell.remove(object);
            if (cell.isEmpty()) {
                this.world.set(oldX, oldY, null);
            }
        }
        if ((cell = this.world.get(object.getX(), object.getY())) == null) {
            cell = new Cell();
            this.world.set(object.getX(), object.getY(), cell);
        }
        cell.add(object);
    }

    @Override
    public void updateObjectSize(Actor object) {
    }

    public List getIntersectingObjects(Actor actor, Class cls) {
        ArrayList<Actor> intersecting = new ArrayList<Actor>();
        for (Actor element : this.objects) {
            this.currentStats.incGetIntersectingObjects();
            if (element == actor || !ActorVisitor.intersects(actor, element) || cls != null && !cls.isInstance(element)) continue;
            intersecting.add(element);
        }
        return intersecting;
    }

    public List getNeighbours(Actor actor, int distance, boolean diag, Class cls) {
        int x = actor.getX();
        int y = actor.getY();
        ArrayList c = new ArrayList();
        if (diag) {
            block0: for (int dx = x - distance; dx <= x + distance; ++dx) {
                if (!this.wrap) {
                    if (dx < 0) continue;
                    if (dx >= this.world.getWidth()) break;
                }
                for (int dy = y - distance; dy <= y + distance; ++dy) {
                    List found;
                    if (!this.wrap) {
                        if (dy < 0) continue;
                        if (dy >= this.world.getHeight()) continue block0;
                    }
                    if (dx == x && dy == y) continue;
                    Cell cell = this.world.get(dx, dy);
                    this.currentStats.incGetNeighbours();
                    if (cell == null || (found = cell.get(cls)) == null) continue;
                    c.addAll(found);
                }
            }
        } else {
            int d = distance;
            int xStart = x;
            int yStart = y;
            int dyEnd = d;
            for (int dx = 0; dx <= d; ++dx) {
                for (int dy = dx - d; dy <= dyEnd; ++dy) {
                    List found;
                    Cell cell;
                    int xPos = xStart + dx;
                    int xNeg = xStart - dx;
                    int yPos = yStart + dy;
                    if (!this.wrap) {
                        if (yPos >= this.world.getHeight()) break;
                        if (yPos < 0) continue;
                    }
                    if (dx == 0 && dy == 0) continue;
                    this.currentStats.incGetNeighbours();
                    if (this.withinBounds(xPos, this.getWidth()) && (cell = this.world.get(xPos, yPos)) != null && (found = cell.get(cls)) != null) {
                        c.addAll(found);
                    }
                    if (dx == 0 || !this.withinBounds(xNeg, this.getWidth()) || (cell = this.world.get(xNeg, yPos)) == null || (found = cell.get(cls)) == null) continue;
                    c.addAll(found);
                }
                --dyEnd;
            }
        }
        return c;
    }

    public List getObjectsInDirection(int x, int y, int angle, int length, Class cls) {
        int stepx;
        int stepy;
        ArrayList result = new ArrayList();
        double dy = 2.0 * Math.sin(Math.toRadians(angle));
        double dx = 2.0 * Math.cos(Math.toRadians(angle));
        int lxMax = (int)Math.abs(Math.round((double)length * Math.cos(Math.toRadians(angle))));
        int lyMax = (int)Math.abs(Math.round((double)length * Math.sin(Math.toRadians(angle))));
        if (dy < 0.0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0.0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        result.addAll(this.getObjectsAt(x, y, cls));
        if (dx > dy) {
            double fraction = dy - dx / 2.0;
            for (int l = 0; l < lxMax; ++l) {
                this.currentStats.incGetObjectsInDirection();
                if (fraction >= 0.0) {
                    y += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                result.addAll(this.getObjectsAt(x += stepx, y, cls));
            }
        } else {
            double fraction = dx - dy / 2.0;
            for (int l = 0; l < lyMax; ++l) {
                this.currentStats.incGetObjectsInDirection();
                if (fraction >= 0.0) {
                    x += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                result.addAll(this.getObjectsAt(x, y += stepy, cls));
            }
        }
        return result;
    }

    private boolean withinBounds(int x, int width) {
        return this.wrap || !this.wrap && x >= 0 && x < width;
    }

    private int wrap(int x, int width) {
        int remainder = x % width;
        if (remainder < 0) {
            return width + remainder;
        }
        return remainder;
    }

    @Override
    public void startSequence() {
        if (PRINT_STATS) {
            System.out.println(this.currentStats);
        }
        this.allStats.add(this.currentStats);
        this.currentStats = new Statistics();
    }

    public List getObjects(Class cls) {
        ArrayList<Actor> objectsThere = new ArrayList<Actor>();
        Iterator iter = this.objects.iterator();
        while (iter.hasNext()) {
            this.currentStats.incGetObjectsAt();
            Actor actor = (Actor)iter.next();
            if (cls != null && !cls.isInstance(actor)) continue;
            objectsThere.add(actor);
        }
        return objectsThere;
    }

    @Override
    public List<Actor> getObjectsList() {
        ArrayList<Actor> l = new ArrayList<Actor>(this.objects);
        return l;
    }

    public Actor getOneObjectAt(Actor actor, int dx, int dy, Class cls) {
        List neighbours = this.getObjectsAt(dx, dy, cls);
        neighbours.remove(actor);
        if (!neighbours.isEmpty()) {
            return (Actor)neighbours.get(0);
        }
        return null;
    }

    @Override
    public Actor getOneIntersectingObject(Actor object, Class cls) {
        List intersecting = this.getIntersectingObjects(object, cls);
        if (!intersecting.isEmpty()) {
            return (Actor)intersecting.get(0);
        }
        return null;
    }

    @Override
    public void paintDebug(Graphics g) {
    }

    public static class Statistics {
        private static final String format = "%15s%15s%15s%15s%15s";
        private long objectsAt;
        private long intersectionObjects;
        private long objectsInRange;
        private long neighbours;
        private long objectsInDirection;
        private long startTime = -1L;

        public void incGetObjectsAt() {
            this.initStartTime();
            ++this.objectsAt;
        }

        public void incGetIntersectingObjects() {
            this.initStartTime();
            ++this.intersectionObjects;
        }

        public void incGetObjectsInRange() {
            this.initStartTime();
            ++this.objectsInRange;
        }

        public void incGetNeighbours() {
            this.initStartTime();
            ++this.neighbours;
        }

        public void incGetObjectsInDirection() {
            this.initStartTime();
            ++this.objectsInDirection;
        }

        private void initStartTime() {
            if (this.startTime == -1L) {
                this.startTime = System.currentTimeMillis();
            }
        }

        public String toString() {
            return String.format(format, new Long(this.startTime), new Long(this.objectsAt), new Long(this.intersectionObjects), new Long(this.objectsInRange), new Long(this.neighbours), new Long(this.objectsInDirection));
        }

        public static String headerString() {
            return String.format(format, "startTime", "objectsAt", "intersection", "oinRange", "neighbours", "inDirection");
        }
    }

    private class WrappingGridWorld
    extends GridWorld {
        public WrappingGridWorld(int width, int height) {
            super(width, height);
        }

        public Cell get(int x, int y) {
            x = GridCollisionChecker.this.wrap(x, this.getWidth());
            y = GridCollisionChecker.this.wrap(y, this.getHeight());
            return this.world[x][y];
        }

        public void set(int x, int y, Cell cell) {
            x = GridCollisionChecker.this.wrap(x, this.getWidth());
            y = GridCollisionChecker.this.wrap(y, this.getHeight());
            this.world[x][y] = cell;
        }
    }

    private class GridWorld {
        protected Cell[][] world;

        public GridWorld(int width, int height) {
            this.world = new Cell[width][height];
        }

        public Cell get(int x, int y) {
            return this.world[x][y];
        }

        public void set(int x, int y, Cell cell) {
            this.world[x][y] = cell;
        }

        public int getWidth() {
            return this.world.length;
        }

        public int getHeight() {
            return this.world[0].length;
        }
    }

    class Cell {
        private HashMap classMap = new HashMap();
        private List objects = new ArrayList();

        Cell() {
        }

        public void add(Actor thing) {
            Class<?> clazz = thing.getClass();
            ArrayList<Actor> list = (ArrayList<Actor>)this.classMap.get(clazz);
            if (list == null) {
                list = new ArrayList<Actor>();
                this.classMap.put(clazz, list);
            }
            if (!list.contains(thing)) {
                list.add(thing);
            }
            if (!this.objects.contains(thing)) {
                this.objects.add(thing);
            }
        }

        public List get(Class cls) {
            return (List)this.classMap.get(cls);
        }

        public void remove(Actor object) {
            this.objects.remove(object);
            List classes = (List)this.classMap.get(object.getClass());
            if (classes != null) {
                classes.remove(object);
            }
        }

        public boolean isEmpty() {
            return this.objects.isEmpty();
        }

        public List getAll() {
            return this.objects;
        }
    }
}

