/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.collision.CollisionChecker;
import greenfoot.collision.CollisionQuery;
import greenfoot.collision.GOCollisionQuery;
import greenfoot.collision.NeighbourCollisionQuery;
import greenfoot.collision.PointCollisionQuery;
import greenfoot.util.Circle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public class BVHInsChecker
implements CollisionChecker {
    public CircleTree tree;
    private GOCollisionQuery actorQuery = new GOCollisionQuery();
    private NeighbourCollisionQuery neighbourQuery = new NeighbourCollisionQuery();
    private PointCollisionQuery pointQuery = new PointCollisionQuery();
    private int cellSize;
    private List objects;

    public void initialize(int width, int height, int cellSize, boolean wrap) {
        this.tree = new CircleTree();
        this.cellSize = cellSize;
        this.objects = new ArrayList();
    }

    public synchronized void addObject(Actor actor) {
        if (this.objects.contains(actor)) {
            return;
        }
        Node n = this.createNode(actor);
        ActorVisitor.setData(actor, n);
        this.tree.addNode(n);
        this.objects.add(actor);
    }

    private Node createNode(Actor actor) {
        Circle c = this.getCircle(actor);
        Node n = new Node(c, actor);
        return n;
    }

    public synchronized void removeObject(Actor object) {
        this.tree.removeNode((Node)ActorVisitor.getData(object));
        ActorVisitor.setData(object, null);
        this.objects.remove(object);
    }

    public synchronized void updateObjectLocation(Actor object, int oldX, int oldY) {
        if (object.getX() == oldX && object.getY() == oldY) {
            return;
        }
        Node n = (Node)ActorVisitor.getData(object);
        Circle c = this.getCircle(object);
        if (c != null && n != null) {
            n.circle.setX(c.getX());
            n.circle.setY(c.getY());
            this.tree.repairNode(n);
        }
    }

    public synchronized void updateObjectSize(Actor object) {
        Node n = (Node)ActorVisitor.getData(object);
        Circle c = ActorVisitor.getBoundingCircle(object);
        if (c != null && n != null) {
            n.circle.setRadius(c.getRadius() * this.cellSize);
            this.tree.repairNode(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getObjectsAt(int x, int y, Class cls) {
        int halfCell = this.cellSize / 2;
        Circle b = new Circle(x * this.cellSize + halfCell, y * this.cellSize + halfCell, 0);
        PointCollisionQuery pointCollisionQuery = this.pointQuery;
        synchronized (pointCollisionQuery) {
            this.pointQuery.init(x, y, cls);
            return this.tree.getIntersections(b, this.pointQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getIntersectingObjects(Actor actor, Class cls) {
        Circle b = this.getCircle(actor);
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, actor);
            return this.tree.getIntersections(b, this.actorQuery);
        }
    }

    private Circle getCircle(Actor actor) {
        Circle c = ActorVisitor.getBoundingCircle(actor);
        if (c == null) {
            return null;
        }
        Circle b = new Circle(c.getX() * this.cellSize, c.getY() * this.cellSize, c.getRadius() * this.cellSize);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getObjectsInRange(int x, int y, int r, Class cls) {
        Circle b = new Circle(x * this.cellSize, y * this.cellSize, r * this.cellSize);
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, null);
            return this.tree.getIntersections(b, this.actorQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNeighbours(Actor a, int distance, boolean diag, Class cls) {
        int x = a.getX();
        int y = a.getY();
        int xPixel = x * this.cellSize;
        int yPixel = y * this.cellSize;
        int dPixel = distance * this.cellSize;
        int r = 0;
        if (diag) {
            r = (int)Math.ceil(Math.sqrt(dPixel * dPixel + dPixel * dPixel));
        } else {
            double dy = 0.5 * (double)this.cellSize;
            double dx = (double)dPixel + dy;
            r = (int)Math.sqrt(dy * dy + dx * dx);
        }
        Circle c = new Circle(xPixel, yPixel, r);
        NeighbourCollisionQuery neighbourCollisionQuery = this.neighbourQuery;
        synchronized (neighbourCollisionQuery) {
            this.neighbourQuery.init(x, y, distance, diag, cls);
            return this.tree.getIntersections(c, this.neighbourQuery);
        }
    }

    public List getObjectsInDirection(int x, int y, int angle, int length, Class cls) {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    public List getObjects(Class cls) {
        if (cls == null) {
            return new ArrayList(this.objects);
        }
        ArrayList<Actor> l = new ArrayList<Actor>();
        for (Actor actor : this.objects) {
            if (!cls.isInstance(actor)) continue;
            l.add(actor);
        }
        return l;
    }

    public List getObjectsList() {
        return this.objects;
    }

    public void startSequence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Actor getOneObjectAt(Actor actor, int x, int y, Class cls) {
        int halfCell = this.cellSize / 2;
        Circle b = new Circle(x * this.cellSize + halfCell, y * this.cellSize + halfCell, 0);
        PointCollisionQuery pointCollisionQuery = this.pointQuery;
        synchronized (pointCollisionQuery) {
            this.pointQuery.init(x, y, cls);
            Node node = (Node)ActorVisitor.getData(actor);
            return this.tree.getOneIntersectingObject(node, b, this.pointQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Actor getOneIntersectingObject(Actor object, Class cls) {
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, object);
            Node node = (Node)ActorVisitor.getData(object);
            if (node == null) {
                return null;
            }
            return this.tree.getOneIntersectingObject(node, this.actorQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDebug(Graphics g) {
        int missing = 0;
        BVHInsChecker bVHInsChecker = this;
        synchronized (bVHInsChecker) {
            missing = this.objects.size() - this.tree.size();
            this.tree.paintDebug((Graphics2D)g);
        }
        if (missing > 0) {
            System.out.println("Objects missing: " + missing);
        }
    }

    class CircleTree {
        private Node root;
        private int size;
        private Node lastInsertionPoint;

        CircleTree() {
        }

        public void addNode(Node n, Node bestGuess) {
            Node sibling = this.bestSibling(n, bestGuess);
            this.insertAtNode(n, sibling);
        }

        public void addNode(Node n) {
            if (!this.contains(this.lastInsertionPoint)) {
                this.lastInsertionPoint = null;
            }
            Node sibling = this.bestSibling(n, this.lastInsertionPoint);
            this.insertAtNode(n, sibling);
            this.lastInsertionPoint = n.getSibling();
        }

        private boolean contains(Node n) {
            if (n == null) {
                return false;
            }
            return this.root == n || n.parent != null;
        }

        private void checkInvariant(Node n) {
            if (n == null) {
                return;
            }
            if (n.getActor() != null && !BVHInsChecker.this.objects.contains(n.getActor()) && this.contains(n)) {
                System.err.println("The node is in the tree, but should not be: " + n + "  " + n.getActor());
                throw new RuntimeException("Invariant not true because the node is in the tree, but should not be:   Node: " + n + " #   left:" + n.left + " #   right:" + n.right + " #   parent:" + n.parent + " #   root:" + this.root + " #   actor:" + n.getActor());
            }
            if (n.left == null && n.right == null && n.parent == null && n != this.root) {
                throw new RuntimeException("Invariant not true because parents and children are null and it is not the root:   Node: " + n + " #   left:" + n.left + " #   right:" + n.right + " #   parent:" + n.parent + " #   root:" + this.root + " #   actor:" + n.getActor());
            }
            if (n.circle == null) {
                throw new RuntimeException("Invariant not true because circle==null:   Node: " + n + " #   left:" + n.left + " #   right:" + n.right + " #   parent:" + n.parent + " #   root:" + this.root + " #   actor:" + n.getActor());
            }
            if (!(n.left == null && n.right == null || n.left != null && n.right != null)) {
                throw new RuntimeException("Invariant not true:   Node: " + n + " #   left:" + n.left + " #   right:" + n.right + " #   parent:" + n.parent + " #   root:" + this.root + " #   actor:" + n.getActor());
            }
            this.checkInvariant(n.left);
            this.checkInvariant(n.right);
        }

        private void checkInvariant() {
        }

        public Node bestSibling(Node newNode, Node bestGuess) {
            CircleFringe newFringe;
            if (this.getRoot() == null) {
                return null;
            }
            if (this.root.isLeaf()) {
                return this.root;
            }
            CircleFringe rootFringe = this.createFringe(newNode, this.root);
            CircleFringe best = new CircleFringe(rootFringe);
            if (bestGuess != null && (newFringe = this.createFringe(newNode, bestGuess)).getCost() < best.getCost()) {
                best.copyValuesFrom(newFringe);
            }
            PriorityQueue<CircleFringe> fringeQueue = new PriorityQueue<CircleFringe>();
            fringeQueue.add(rootFringe);
            this.bestSiblingSearch(newNode, best, fringeQueue);
            return best.getNode();
        }

        private void bestSiblingSearch(Node newNode, CircleFringe best, PriorityQueue fringeQueue) {
            CircleFringe tf;
            while (!fringeQueue.isEmpty() && !((tf = (CircleFringe)fringeQueue.poll()).getAncestorExpansion() >= best.getCost())) {
                double newAExp = tf.getCost() - tf.getNode().circle.getVolume();
                this.processNode(newNode, tf.getNode().left, newAExp, best, fringeQueue);
                this.processNode(newNode, tf.getNode().right, newAExp, best, fringeQueue);
            }
        }

        private CircleFringe createFringe(Node newNode, Node currentNode) {
            Circle bestCircle = new Circle();
            bestCircle.merge(currentNode.circle, newNode.circle);
            double bestCost = bestCircle.getVolume();
            double ae = 0.0;
            Node n = currentNode;
            while (n.parent != null) {
                Circle enclosingCircle = new Circle();
                enclosingCircle.merge(n.circle, newNode.circle);
                double delta = enclosingCircle.getVolume() - n.parent.circle.getVolume();
                if (delta == 0.0) break;
                ae += delta;
                n = n.parent;
            }
            CircleFringe newFringe = new CircleFringe(currentNode, ae, bestCost);
            return newFringe;
        }

        private void processNode(Node newNode, Node childNode, double newAExp, CircleFringe best, PriorityQueue fringeQueue) {
            Circle enclosingCircle = new Circle();
            enclosingCircle.merge(childNode.circle, newNode.circle);
            double enclosingVolume = enclosingCircle.getVolume();
            if (newAExp + enclosingVolume < best.getCost()) {
                best.setVolume(enclosingVolume);
                best.setAncestorExpansion(enclosingVolume);
                best.setNode(childNode);
            }
            if (!childNode.isLeaf()) {
                CircleFringe newFringe = new CircleFringe(childNode, newAExp, enclosingVolume);
                fringeQueue.add(newFringe);
            }
        }

        public void insertAtNode(Node newNode, Node sibling) {
            if (this.getRoot() == null) {
                this.setRoot(newNode);
            } else {
                Node newParent = new Node();
                newParent.parent = sibling.parent;
                if (sibling.parent == null) {
                    this.setRoot(newParent);
                } else if (sibling.parent.left == sibling) {
                    sibling.parent.left = newParent;
                } else {
                    sibling.parent.right = newParent;
                }
                newParent.left = sibling;
                newParent.right = newNode;
                newNode.parent = newParent;
                sibling.parent = newParent;
                newParent.circle.merge(newNode.circle, sibling.circle);
                this.repairParents(newParent);
            }
            ++this.size;
        }

        private void repairParents(Node newParent) {
            Node p = newParent.parent;
            while (p != null) {
                int radius = p.circle.getRadius();
                p.circle.merge(p.left.circle, p.right.circle);
                if (p.circle.getRadius() == radius) break;
                p = p.parent;
            }
        }

        public void repairNode(Node n) {
            if (n == null) {
                return;
            }
            Node sibling = this.removeNode(n);
            this.addNode(n, sibling);
        }

        public Node removeNode(Node n) {
            Node sibling = null;
            if (n == null) {
                return null;
            }
            if (n == this.root) {
                this.setRoot(null);
            } else {
                sibling = n.getSibling();
                Node parent = n.parent;
                sibling.parent = parent.parent;
                if (parent.parent == null) {
                    this.setRoot(sibling);
                } else if (parent.parent.left == parent) {
                    parent.parent.left = sibling;
                } else {
                    parent.parent.right = sibling;
                }
                parent.reset();
                this.repairParents(sibling);
            }
            n.reset();
            --this.size;
            return sibling;
        }

        public List getIntersections(Circle b, CollisionQuery c) {
            ArrayList result = new ArrayList();
            if (this.getRoot() == null) {
                return result;
            }
            this.getRoot().getIntersections(b, c, result);
            return result;
        }

        public Actor getOneIntersectingObject(Node node, Circle circle, CollisionQuery checker) {
            if (node != null) {
                return node.getOneIntersectingObject(circle, checker);
            }
            if (this.root != null) {
                return this.root.getOneIntersectingObject(circle, checker);
            }
            return null;
        }

        public Actor getOneIntersectingObject(Node node, CollisionQuery checker) {
            return node.getOneIntersectingObject(node.circle, checker);
        }

        public void paintDebug(Graphics g) {
            if (this.getRoot() != null) {
                this.paintNode(this.getRoot(), g);
            }
        }

        private void paintNode(Node n, Graphics g) {
            this.paintCircle(n.circle, g);
            if (n.left != null) {
                g.setColor(Color.BLUE);
                this.paintLine(n, n.left, g);
                this.paintNode(n.left, g);
            }
            if (n.right != null) {
                g.setColor(Color.GREEN);
                this.paintLine(n, n.right, g);
                this.paintNode(n.right, g);
            }
        }

        private void paintLine(Node from, Node to, Graphics g) {
            if (from == null || to == null) {
                return;
            }
            g.drawLine(from.circle.getX(), from.circle.getY(), to.circle.getX(), to.circle.getY());
        }

        private void paintCircle(Circle b, Graphics g) {
            if (b != null) {
                g.setColor(Color.RED);
                g.drawOval(b.getX() - b.getRadius(), b.getY() - b.getRadius(), b.getRadius() * 2, b.getRadius() * 2);
            }
        }

        public int size() {
            return this.size;
        }

        public void setRoot(Node root) {
            this.root = root;
        }

        public Node getRoot() {
            return this.root;
        }
    }

    static class CircleFringe
    implements Comparable {
        private Node node;
        private double ancestorExpansion;
        private double volume;

        public CircleFringe(Node n, double ancestorExpansion, double volume) {
            this.ancestorExpansion = ancestorExpansion;
            this.volume = volume;
            this.node = n;
        }

        public CircleFringe(CircleFringe other) {
            this.copyValuesFrom(other);
        }

        public void copyValuesFrom(CircleFringe other) {
            this.node = other.getNode();
            this.ancestorExpansion = other.getAncestorExpansion();
            this.volume = other.getVolume();
        }

        public double getAncestorExpansion() {
            return this.ancestorExpansion;
        }

        public void setAncestorExpansion(double ancestorExpansion) {
            this.ancestorExpansion = ancestorExpansion;
        }

        public int compareTo(Object arg0) {
            CircleFringe other = (CircleFringe)arg0;
            return (int)(this.ancestorExpansion - other.getAncestorExpansion());
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public void setVolume(double volume) {
            this.volume = volume;
        }

        public double getVolume() {
            return this.volume;
        }

        public double getCost() {
            return this.ancestorExpansion + this.volume;
        }
    }

    class Node {
        public Node parent;
        public Node left;
        public Node right;
        public Circle circle;
        private Actor actor;

        public Node(Circle circle) {
            this.circle = circle;
        }

        public Node() {
            this.circle = new Circle();
        }

        public Node(Circle circle, Actor actor) {
            if (actor == null) {
                throw new NullPointerException("Actor may not be null.");
            }
            this.circle = circle;
            this.actor = actor;
        }

        public Actor getActor() {
            return this.actor;
        }

        public boolean isLeaf() {
            return this.left == null && this.right == null;
        }

        public void getIntersections(Circle c, CollisionQuery checker, List result) {
            if (!c.intersects(this.circle)) {
                return;
            }
            if (this.isLeaf() && checker != null && checker.checkCollision(this.getActor())) {
                result.add(this.getActor());
            } else if (!this.isLeaf()) {
                this.left.getIntersections(c, checker, result);
                this.right.getIntersections(c, checker, result);
            }
        }

        private Actor getOneIntersectingObject(Circle c, CollisionQuery checker) {
            return this.getOneIntersectingObjectUpwards(c, checker);
        }

        private Actor getOneIntersectingObjectDownwards(Circle c, CollisionQuery checker) {
            if (!c.intersects(this.circle)) {
                return null;
            }
            if (this.isLeaf() && checker != null && checker.checkCollision(this.getActor())) {
                return this.getActor();
            }
            if (!this.isLeaf()) {
                Actor res = this.left.getOneIntersectingObjectDownwards(c, checker);
                if (res != null) {
                    return res;
                }
                return this.right.getOneIntersectingObjectDownwards(c, checker);
            }
            return null;
        }

        private Actor getOneIntersectingObjectUpwards(Circle c, CollisionQuery checker) {
            Node sibling = this.getSibling();
            Actor result = null;
            if (sibling != null) {
                result = sibling.getOneIntersectingObjectDownwards(sibling.circle, checker);
            }
            if (result == null && this.parent != null) {
                return this.parent.getOneIntersectingObjectUpwards(c, checker);
            }
            if (result != null) {
                return result;
            }
            return null;
        }

        public void reset() {
            if (this.left != null && this.left.parent == this) {
                this.left.parent = null;
            }
            if (this.right != null && this.right.parent == this) {
                this.right.parent = null;
            }
            if (this.parent != null) {
                if (this.parent.left == this) {
                    this.parent.left = null;
                } else if (this.parent.right == this) {
                    this.parent.right = null;
                }
            }
            this.parent = null;
            this.left = null;
            this.right = null;
        }

        private Node getSibling() {
            if (this.parent != null) {
                if (this.parent.left == this) {
                    return this.parent.right;
                }
                return this.parent.left;
            }
            return null;
        }
    }
}

