/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.Debug;
import bluej.utility.FileUtility;
import greenfoot.core.GClass;
import greenfoot.core.GreenfootMain;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.ImageLibFrame;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.role.ImageClassRole;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class SelectImageAction
extends AbstractAction {
    private ClassView classView;
    private ImageClassRole gclassRole;

    public SelectImageAction(ClassView classView, ImageClassRole gcr) {
        super(Config.getString((String)"select.image"));
        this.classView = classView;
        this.gclassRole = gcr;
    }

    public void actionPerformed(ActionEvent e) {
        GreenfootFrame gfFrame = GreenfootMain.getInstance().getFrame();
        ImageLibFrame imageLibFrame = new ImageLibFrame((JFrame)gfFrame, this.classView);
        File currentImageFile = imageLibFrame.getSelectedImageFile();
        SelectImageAction.setClassImage(this.classView, this.gclassRole, currentImageFile);
    }

    public static void setClassImage(ClassView classView, ImageClassRole gclassRole, File imageFile) {
        block6: {
            try {
                GClass gclass = classView.getGClass();
                File projImagesDir = gclass.getPackage().getProject().getImageDir();
                if (imageFile == null) break block6;
                if (!imageFile.getParentFile().getAbsoluteFile().equals(projImagesDir)) {
                    File destFile = new File(projImagesDir, imageFile.getName());
                    try {
                        FileUtility.copyFile((File)imageFile, (File)destFile);
                        imageFile = destFile;
                    }
                    catch (IOException e) {
                        Debug.reportError((String)("Error when copying file: " + imageFile + " to: " + destFile), (Exception)e);
                    }
                }
                gclass.setClassProperty("image", imageFile.getName());
                gclassRole.changeImage();
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            catch (ProjectNotOpenException projectNotOpenException) {
                // empty catch block
            }
        }
    }
}

