/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import greenfoot.core.GProject;
import greenfoot.gui.GreenfootFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class SaveCopyAction
extends AbstractAction {
    private GreenfootFrame gfFrame;

    public SaveCopyAction(GreenfootFrame gfFrame) {
        super(Config.getString((String)"project.savecopy"));
        this.gfFrame = gfFrame;
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        String newName = FileUtility.getFileName((Component)this.gfFrame, (String)Config.getString((String)"project.savecopy.title"), (String)Config.getString((String)"pkgmgr.saveAs.buttonLabel"), (boolean)true, null, (boolean)true);
        if (newName != null) {
            GProject project = this.gfFrame.getProject();
            int result = 3;
            try {
                project.save();
                result = FileUtility.copyDirectory((File)project.getDir(), (File)new File(newName));
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            catch (ProjectNotOpenException pnoe) {
                pnoe.printStackTrace();
            }
            switch (result) {
                case 0: {
                    break;
                }
                case 1: {
                    DialogManager.showError((Component)this.gfFrame, (String)"directory-exists");
                    return;
                }
                case 2: 
                case 3: {
                    DialogManager.showError((Component)this.gfFrame, (String)"cannot-copy-package");
                    return;
                }
            }
        }
    }
}

