/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.utility.Debug;
import greenfoot.core.Simulation;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class RunSimulationAction
extends AbstractAction
implements SimulationListener {
    private static final String iconFile = "run.png";
    private static RunSimulationAction instance = new RunSimulationAction();
    private Simulation simulation;

    public static RunSimulationAction getInstance() {
        return instance;
    }

    private RunSimulationAction() {
        super(Config.getString((String)"run.simulation"), new ImageIcon(RunSimulationAction.class.getClassLoader().getResource(iconFile)));
    }

    public void attachSimulation(Simulation simulation) {
        this.simulation = simulation;
        simulation.addSimulationListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.simulation == null) {
            Debug.reportError((String)"attempt to run a simulation while none exists.");
            return;
        }
        this.simulation.setPaused(false);
    }

    public void simulationChanged(final SimulationEvent e) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int eventType = e.getType();
                if (eventType == 1) {
                    RunSimulationAction.this.setEnabled(true);
                } else if (eventType == 0) {
                    RunSimulationAction.this.setEnabled(false);
                } else if (eventType == 3) {
                    RunSimulationAction.this.setEnabled(false);
                }
            }
        });
    }
}

