/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.utility.Debug;
import greenfoot.core.Simulation;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class RunOnceSimulationAction
extends AbstractAction
implements SimulationListener {
    private static final String iconFile = "step.png";
    private static RunOnceSimulationAction instance = new RunOnceSimulationAction();
    private Simulation simulation;

    public static RunOnceSimulationAction getInstance() {
        return instance;
    }

    private RunOnceSimulationAction() {
        super(Config.getString((String)"run.once"), new ImageIcon(RunOnceSimulationAction.class.getClassLoader().getResource(iconFile)));
    }

    public void attachSimulation(Simulation simulation) {
        this.simulation = simulation;
        simulation.addSimulationListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.simulation == null) {
            Debug.reportError((String)"attempt to pause a simulation while none exists.");
            return;
        }
        new Thread(){

            public void run() {
                RunOnceSimulationAction.this.simulation.runOnce();
            }
        }.start();
    }

    public void simulationChanged(final SimulationEvent e) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int eventType = e.getType();
                if (eventType == 1) {
                    RunOnceSimulationAction.this.setEnabled(true);
                } else if (eventType == 0) {
                    RunOnceSimulationAction.this.setEnabled(false);
                } else if (eventType == 3) {
                    RunOnceSimulationAction.this.setEnabled(false);
                }
            }
        });
    }
}

