/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import greenfoot.actions.SelectImageAction;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.gui.ImageLibFrame;
import greenfoot.gui.NewClassDialog;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.role.ImageClassRole;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class NewSubclassAction
extends AbstractAction {
    private ClassView superclass;
    private ClassBrowser classBrowser;

    public NewSubclassAction(ClassView view, ClassBrowser classBrowser) {
        super(Config.getString((String)"new.subclass"));
        this.superclass = view;
        this.classBrowser = classBrowser;
    }

    public void actionPerformed(ActionEvent e) {
        GClass superG = this.superclass.getGClass();
        boolean imageClass = superG.isActorClass() || superG.isActorSubclass();
        if (imageClass |= superG.isWorldClass() || superG.isWorldSubclass()) {
            this.createImageClass();
        } else {
            this.createNonActorClass();
        }
    }

    public void createImageClass() {
        JFrame f = (JFrame)SwingUtilities.getWindowAncestor(this.classBrowser);
        ImageLibFrame dialog = new ImageLibFrame(f, this.superclass.getGClass());
        if (dialog.getResult() != ImageLibFrame.OK) {
            return;
        }
        String className = dialog.getClassName();
        GClass gClass = this.superclass.createSubclass(className);
        ClassView classView = new ClassView(this.classBrowser, gClass);
        SelectImageAction.setClassImage(classView, (ImageClassRole)classView.getRole(), dialog.getSelectedImageFile());
        this.classBrowser.addClass(classView);
    }

    public void createNonActorClass() {
        JFrame f = (JFrame)SwingUtilities.getWindowAncestor(this.classBrowser);
        GPackage pkg = null;
        try {
            pkg = this.classBrowser.getProject().getDefaultPackage();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return;
        }
        NewClassDialog dialog = new NewClassDialog(f, pkg);
        dialog.setVisible(true);
        if (!dialog.okPressed()) {
            return;
        }
        String className = dialog.getClassName();
        GClass gClass = this.superclass.createSubclass(className);
        ClassView classView = new ClassView(this.classBrowser, gClass);
        this.classBrowser.addClass(classView);
    }
}

