/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.NewClassDialog;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.role.NormalClassRole;
import greenfoot.util.GreenfootUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class NewClassAction
extends AbstractAction {
    private GreenfootFrame gfFrame;

    public NewClassAction(GreenfootFrame gfFrame) {
        super(Config.getString((String)"new.class"));
        this.setEnabled(false);
        this.gfFrame = gfFrame;
    }

    public void actionPerformed(ActionEvent arg0) {
        GreenfootFrame f = this.gfFrame;
        ClassBrowser classBrowser = this.gfFrame.getClassBrowser();
        GPackage pkg = null;
        try {
            pkg = classBrowser.getProject().getDefaultPackage();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return;
        }
        NewClassDialog dialog = new NewClassDialog(f, pkg);
        dialog.setVisible(true);
        if (!dialog.okPressed()) {
            return;
        }
        String className = dialog.getClassName();
        try {
            File dir = pkg.getProject().getDir();
            File newJavaFile = new File(dir, className + ".java");
            GreenfootUtil.createSkeleton(className, null, newJavaFile, NormalClassRole.getInstance().getTemplateFileName());
            GClass newClass = pkg.newClass(className);
            ClassView classView = new ClassView(classBrowser, newClass);
            classBrowser.addClass(classView);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ProjectNotOpenException pnoe) {
            pnoe.printStackTrace();
        }
    }
}

