/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.Actor;
import greenfoot.GreenfootImage;
import greenfoot.TreeActorSet;
import greenfoot.collision.CollisionChecker;
import greenfoot.collision.ibsp.IBSPColChecker;
import greenfoot.core.ActInterruptedException;
import greenfoot.core.WorldHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class World {
    private CollisionChecker collisionChecker = new IBSPColChecker();
    private TreeActorSet objectsDisordered = new TreeActorSet();
    private TreeActorSet objectsInPaintOrder;
    private TreeActorSet objectsInActOrder;
    private int cellSize = 1;
    private int width;
    private int height;
    private GreenfootImage backgroundImage;
    private boolean tiled = true;
    public ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    public static final int READ_LOCK_TIMEOUT = 500;
    private static Object transportField;
    private static Object remoteObjectTracker;

    public World(int worldWidth, int worldHeight, int cellSize) {
        this.initialize(worldWidth, worldHeight, cellSize);
        GreenfootImage image = this.getClassImage();
        if (image != null) {
            image = image.getCopyOnWriteClone();
            this.setBackground(image);
        }
        if (WorldHandler.getInstance() != null) {
            WorldHandler.getInstance().setInitialisingWorld(this);
        }
    }

    private void initialize(int width, int height, int cellSize) {
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.tiled = true;
        this.collisionChecker.initialize(width, height, cellSize, false);
    }

    public final void setBackground(GreenfootImage image) {
        this.backgroundImage = image;
    }

    public final void setBackground(String filename) throws IllegalArgumentException {
        GreenfootImage bg = new GreenfootImage(filename);
        this.setBackground(bg);
    }

    public GreenfootImage getBackground() {
        if (this.backgroundImage == null) {
            this.backgroundImage = new GreenfootImage(this.getWidthInPixels(), this.getHeightInPixels());
        }
        return this.backgroundImage;
    }

    public Color getColorAt(int x, int y) {
        this.ensureWithinXBounds(x);
        this.ensureWithinYBounds(y);
        int xPixel = (int)Math.floor(this.getCellCenter(x));
        int yPixel = (int)Math.floor(this.getCellCenter(y));
        if (this.isTiled()) {
            xPixel %= this.backgroundImage.getWidth();
            yPixel %= this.backgroundImage.getHeight();
        }
        if (xPixel >= this.backgroundImage.getWidth()) {
            return Color.WHITE;
        }
        if (yPixel >= this.backgroundImage.getHeight()) {
            return Color.WHITE;
        }
        return this.backgroundImage.getColorAt(xPixel, yPixel);
    }

    public void setTiled(boolean tiled) {
        this.tiled = tiled;
    }

    public boolean isTiled() {
        return this.tiled;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setPaintOrder(Class ... classes) {
        if (classes == null) {
            if (this.objectsInPaintOrder != null) {
                classes = new Class[]{};
                this.objectsInPaintOrder.setClassOrder(true, classes);
                this.objectsInPaintOrder = null;
            }
            return;
        }
        if (this.objectsInPaintOrder == null) {
            if (this.objectsInActOrder == this.objectsDisordered) {
                this.objectsInPaintOrder = new TreeActorSet();
                this.objectsInPaintOrder.addAll(this.objectsDisordered);
            } else {
                this.objectsInPaintOrder = this.objectsDisordered;
            }
        }
        this.objectsInPaintOrder.setClassOrder(true, classes);
    }

    public void setActOrder(Class ... classes) {
        if (classes == null) {
            if (this.objectsInActOrder != null) {
                classes = new Class[]{};
                this.objectsInActOrder.setClassOrder(false, classes);
                this.objectsInActOrder = null;
            }
            return;
        }
        if (this.objectsInActOrder == null) {
            if (this.objectsInPaintOrder == this.objectsDisordered) {
                this.objectsInActOrder = new TreeActorSet();
                this.objectsInActOrder.addAll(this.objectsDisordered);
            } else {
                this.objectsInActOrder = this.objectsDisordered;
            }
        }
        this.objectsInActOrder.setClassOrder(false, classes);
    }

    public synchronized void addObject(Actor object, int x, int y) {
        if (!this.objectsDisordered.add(object)) {
            return;
        }
        object.addToWorld(x, y, this);
        this.collisionChecker.addObject(object);
        this.addInPaintOrder(object);
        this.addInActOrder(object);
        object.addedToWorld(this);
    }

    private void addInActOrder(Actor object) {
        if (this.objectsInActOrder != null) {
            this.objectsInActOrder.add(object);
        }
    }

    private void addInPaintOrder(Actor object) {
        if (this.objectsInPaintOrder != null) {
            this.objectsInPaintOrder.add(object);
        }
    }

    private void removeInActOrder(Actor object) {
        if (this.objectsInActOrder != null) {
            this.objectsInActOrder.remove(object);
        }
    }

    private void removeInPaintOrder(Actor object) {
        if (this.objectsInPaintOrder != null) {
            this.objectsInPaintOrder.remove(object);
        }
    }

    public synchronized void removeObject(Actor object) {
        if (this.objectsDisordered.remove(object)) {
            this.collisionChecker.removeObject(object);
            this.removeInActOrder(object);
            this.removeInPaintOrder(object);
        }
        object.setWorld(null);
    }

    public synchronized void removeObjects(Collection objects) {
        for (Actor actor : objects) {
            this.removeObject(actor);
        }
    }

    public List getObjects(Class<?> cls) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        for (Actor actor : this.objectsDisordered) {
            if (cls != null && !cls.isInstance(actor)) continue;
            result.add(actor);
        }
        return result;
    }

    public int numberOfObjects() {
        return this.objectsDisordered.size();
    }

    public void repaint() {
        WorldHandler.getInstance().repaint();
        if (this.lock.isWriteLockedByCurrentThread()) {
            try {
                this.lock.writeLock().newCondition().await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ActInterruptedException(e);
            }
        }
    }

    public void act() {
    }

    public List getObjectsAt(int x, int y, Class cls) {
        return this.collisionChecker.getObjectsAt(x, y, cls);
    }

    List getIntersectingObjects(Actor actor, Class cls) {
        return this.collisionChecker.getIntersectingObjects(actor, cls);
    }

    List getObjectsInRange(int x, int y, int r, Class cls) {
        return this.collisionChecker.getObjectsInRange(x, y, r, cls);
    }

    List getNeighbours(Actor actor, int distance, boolean diag, Class cls) {
        return this.collisionChecker.getNeighbours(actor, distance, diag, cls);
    }

    List getObjectsInDirection(int x0, int y0, int angle, int length, Class cls) {
        return this.collisionChecker.getObjectsInDirection(x0, y0, angle, length, cls);
    }

    int getHeightInPixels() {
        return this.getHeight() * this.getCellSize();
    }

    int getWidthInPixels() {
        return this.getWidth() * this.getCellSize();
    }

    int toCellCeil(int pixel) {
        return (int)Math.ceil((double)pixel / (double)this.cellSize);
    }

    int toCellFloor(int pixel) {
        return (int)Math.floor((double)pixel / (double)this.cellSize);
    }

    double getCellCenter(int l) {
        double cellCenter = (double)(l * this.cellSize) + (double)this.cellSize / 2.0;
        return cellCenter;
    }

    Collection getObjectsAtPixel(int x, int y) {
        return this.collisionChecker.getObjectsAt(this.toCellFloor(x), this.toCellFloor(y), null);
    }

    void updateObjectLocation(Actor object, int oldX, int oldY) {
        this.collisionChecker.updateObjectLocation(object, oldX, oldY);
    }

    void updateObjectSize(Actor object) {
        this.collisionChecker.updateObjectSize(object);
    }

    private GreenfootImage getClassImage() {
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            GreenfootImage image = null;
            try {
                image = Actor.getDelegate().getImage(clazz.getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (image == null) continue;
            return image;
        }
        return null;
    }

    private void ensureWithinXBounds(int x) throws IndexOutOfBoundsException {
        if (x >= this.getWidth()) {
            throw new IndexOutOfBoundsException("The x-coordinate is: " + x + ". It must be smaller than: " + this.getWidth());
        }
        if (x < 0) {
            throw new IndexOutOfBoundsException("The x-coordinate is: " + x + ". It must be larger than: 0");
        }
    }

    private void ensureWithinYBounds(int y) throws IndexOutOfBoundsException {
        if (y >= this.getHeight()) {
            throw new IndexOutOfBoundsException("The y-coordinate is: " + y + ". It must be smaller than: " + this.getHeight());
        }
        if (y < 0) {
            throw new IndexOutOfBoundsException("The x-coordinate is: " + y + ". It must be larger than: 0");
        }
    }

    void startSequence() {
        this.collisionChecker.startSequence();
    }

    Actor getOneObjectAt(Actor object, int dx, int dy, Class cls) {
        return this.collisionChecker.getOneObjectAt(object, dx, dy, cls);
    }

    Actor getOneIntersectingObject(Actor object, Class cls) {
        return this.collisionChecker.getOneIntersectingObject(object, cls);
    }

    TreeActorSet getObjectsListInPaintOrder() {
        if (this.objectsInPaintOrder != null) {
            return this.objectsInPaintOrder;
        }
        return this.objectsDisordered;
    }

    TreeActorSet getObjectsListInActOrder() {
        if (this.objectsInActOrder != null) {
            return this.objectsInActOrder;
        }
        return this.objectsDisordered;
    }

    void paintDebug(Graphics g) {
    }

    static Object getRemoteObjectTracker() {
        return remoteObjectTracker;
    }

    static void setTransportField(Object obj) {
        transportField = obj;
    }
}

