/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import greenfoot.Actor;
import greenfoot.World;
import greenfoot.core.GreenfootMain;
import java.rmi.RemoteException;
import java.util.Hashtable;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RField;
import rmiextension.wrappers.RObject;

public class ObjectTracker {
    private static Object lock = new Object();
    private static Hashtable<Object, RObject> cachedObjects = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RObject getRObject(Object obj) throws ProjectNotOpenException, PackageNotFoundException, RemoteException, ClassNotFoundException {
        Object object = lock;
        synchronized (object) {
            RObject rObject = cachedObjects.get(obj);
            if (rObject != null) {
                return rObject;
            }
            World.setTransportField(obj);
            RClass remoteObjectTracker = null;
            if (obj instanceof Actor) {
                Actor.setTransportField(obj);
                remoteObjectTracker = (RClass)Actor.getRemoteObjectTracker();
            } else if (obj instanceof World) {
                World.setTransportField(obj);
                remoteObjectTracker = (RClass)World.getRemoteObjectTracker();
            } else {
                Debug.reportError((String)("Could not get remote version of object: " + obj), (Exception)new Exception());
                return null;
            }
            RClass rClass = ObjectTracker.getRemoteClass(obj, remoteObjectTracker);
            RField rField = rClass.getField("transportField");
            rObject = rField.getValue(null);
            cachedObjects.put(obj, rObject);
            return rObject;
        }
    }

    private static RClass getRemoteClass(Object obj, RClass remoteObjectTracker) {
        if (remoteObjectTracker == null) {
            String rclassName = obj.getClass().getName();
            remoteObjectTracker = GreenfootMain.getInstance().getProject().getRClass(rclassName);
        }
        return remoteObjectTracker;
    }

    public static Object getRealObject(RObject remoteObj) {
        try {
            return ExecServer.getObject((String)remoteObj.getInstanceName());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forgetRObject(Object obj) {
        Object object = lock;
        synchronized (object) {
            RObject rObject = cachedObjects.remove(obj);
            if (rObject != null) {
                try {
                    rObject.removeFromBench();
                }
                catch (RemoteException re) {
                    throw new Error(re);
                }
                catch (ProjectNotOpenException pnoe) {
                }
                catch (PackageNotFoundException packageNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public static void clearRObjectCache() {
        cachedObjects.clear();
    }
}

