/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.MouseInfo;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.sound.SoundPlayer;
import java.io.IOException;
import java.util.Random;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Greenfoot {
    private static Random randomGenerator = new Random();
    private static boolean lineUnavailableHandled = false;
    private static boolean illegalArgumentHandled;
    private static boolean securityHandled;

    public static String getKey() {
        return WorldHandler.getInstance().getKeyboardManager().getKey();
    }

    public static boolean isKeyDown(String keyName) {
        return WorldHandler.getInstance().getKeyboardManager().isKeyDown(keyName);
    }

    public static void delay(int time) {
        for (int i = 0; i < time; ++i) {
            WorldHandler.getInstance().repaint();
            Simulation.getInstance().sleep();
        }
    }

    public static void setSimulationSpeed(int speed) {
        Simulation.getInstance().setSpeed(speed);
    }

    public static void stopSimulation() {
        Simulation.getInstance().setPaused(true);
    }

    public static void startSimulation() {
        Simulation.getInstance().setPaused(false);
    }

    public static int getRandomNumber(int limit) {
        return randomGenerator.nextInt(limit);
    }

    public static void playSound(String soundFile) {
        block8: {
            try {
                SoundPlayer.getInstance().play(soundFile);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not open sound file: " + soundFile, e);
            }
            catch (UnsupportedAudioFileException e) {
                throw new IllegalArgumentException("Format of sound file not supported: " + soundFile, e);
            }
            catch (SecurityException e) {
                if (!securityHandled) {
                    System.err.println("Could not play sound file due to security restrictions: " + soundFile);
                    System.err.println("If you have a sound card installed, check your system settings.");
                    e.printStackTrace();
                    securityHandled = true;
                }
            }
            catch (IllegalArgumentException e) {
                if (!illegalArgumentHandled) {
                    System.err.println("Could not play sound file: " + soundFile);
                    System.err.println("If you have a sound card installed, check your system settings.");
                    e.printStackTrace();
                    illegalArgumentHandled = true;
                }
            }
            catch (LineUnavailableException e) {
                if (lineUnavailableHandled) break block8;
                System.err.println("Can not get access to the sound card. If you have a sound card installed, check your system settings, and close down any other programs that might be using the sound card.");
                e.printStackTrace();
                lineUnavailableHandled = true;
            }
        }
    }

    public static boolean mousePressed(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMousePressed(obj);
    }

    public static boolean mouseClicked(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMouseClicked(obj);
    }

    public static boolean mouseDragged(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMouseDragged(obj);
    }

    public static boolean mouseDragEnded(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMouseDragEnded(obj);
    }

    public static boolean mouseMoved(Object obj) {
        return WorldHandler.getInstance().getMouseManager().isMouseMoved(obj);
    }

    public static MouseInfo getMouseInfo() {
        return WorldHandler.getInstance().getMouseManager().getMouseInfo();
    }
}

