/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.GreenfootImage;
import greenfoot.World;
import greenfoot.collision.ibsp.Rect;
import greenfoot.core.WorldHandler;
import greenfoot.platforms.ActorDelegate;
import greenfoot.util.Circle;
import greenfoot.util.GreenfootUtil;
import java.util.List;

public abstract class Actor {
    private static final String NO_WORLD = "An actor is trying to access the world, when no world has been instantiated.";
    private static final String ACTOR_NOT_IN_WORLD = "The actor has not been inserted into a world so it has no location yet. You might want to look at the method addedToWorld on the Actor class.";
    static int sequenceNumber = 0;
    int x;
    int y;
    private int mySequenceNumber = sequenceNumber++;
    private int lastPaintSequenceNumber;
    private int rotation = 0;
    World world;
    private GreenfootImage image;
    private Circle boundingCircle;
    private Object data;
    private static GreenfootImage greenfootImage;
    private static ActorDelegate delegate;
    private static Object transportField;
    private static Object remoteObjectTracker;

    public Actor() {
        GreenfootImage image = this.getClassImage();
        if (image == null) {
            image = greenfootImage;
        }
        image = image.getCopyOnWriteClone();
        this.setImage(image);
    }

    public void act() {
    }

    public int getX() throws IllegalStateException {
        this.failIfNotInWorld();
        return this.x;
    }

    public int getY() {
        this.failIfNotInWorld();
        return this.y;
    }

    public int getWidth() {
        if (this.image == null) {
            return -1;
        }
        return this.getXMax() - this.getXMin() + 1;
    }

    public int getHeight() {
        if (this.image == null) {
            return -1;
        }
        return this.getYMax() - this.getYMin() + 1;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        int oldWidth = 0;
        int oldHeight = 0;
        if (this.world != null) {
            oldWidth = this.getWidth();
            oldHeight = this.getHeight();
        }
        this.rotation = rotation;
        if (this.world != null && (oldHeight != this.getHeight() || oldWidth != this.getWidth())) {
            this.sizeChanged();
        }
    }

    public void setLocation(int x, int y) {
        this.failIfNotInWorld();
        int oldX = this.x;
        int oldY = this.y;
        this.x = this.limitValue(x, this.world.getWidth());
        this.y = this.limitValue(y, this.world.getHeight());
        this.locationChanged(oldX, oldY);
    }

    private int limitValue(int v, int limit) {
        if (v < 0) {
            v = 0;
        }
        if (limit <= v) {
            v = limit - 1;
        }
        return v;
    }

    public World getWorld() {
        return this.world;
    }

    protected void addedToWorld(World world) {
    }

    public GreenfootImage getImage() {
        return this.image;
    }

    public void setImage(String filename) throws IllegalArgumentException {
        this.image = new GreenfootImage(filename);
        this.sizeChanged();
    }

    public void setImage(GreenfootImage image) {
        this.image = image;
        this.sizeChanged();
    }

    void setLocationInPixels(int x, int y) {
        this.failIfNotInWorld();
        int xCell = this.world.toCellFloor(x);
        int yCell = this.world.toCellFloor(y);
        if (x == this.getX() && y == this.getY()) {
            return;
        }
        this.setLocation(xCell, yCell);
    }

    void setWorld(World world) {
        this.world = world;
        if (world != null) {
            this.boundingCircle = new Circle(this.x, this.y, this.calcBoundingRadius());
        }
    }

    void addToWorld(int x, int y, World world) {
        this.x = this.limitValue(x, world.getWidth());
        this.y = this.limitValue(y, world.getHeight());
        this.setWorld(world);
        this.setLocation(x, y);
    }

    Circle getBoundingCircle() {
        return this.boundingCircle;
    }

    Rect getBoundingRect() {
        if (this.world == null) {
            return null;
        }
        int x = this.getPaintX();
        int y = this.getPaintY();
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        return new Rect(x, y, width, height);
    }

    void setData(Object o) {
        this.data = o;
    }

    Object getData() {
        return this.data;
    }

    private GreenfootImage getClassImage() {
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            GreenfootImage image = null;
            try {
                image = this.getImage(clazz);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (image == null) continue;
            return image;
        }
        return greenfootImage;
    }

    private int toCellFloor(int i) {
        World aWorld = this.world;
        if (aWorld == null) {
            aWorld = this.getActiveWorld();
        }
        if (aWorld == null) {
            throw new IllegalStateException(NO_WORLD);
        }
        return (int)Math.floor((double)i / (double)aWorld.getCellSize());
    }

    private int getXMin() {
        return this.toCellFloor(this.getPaintX());
    }

    private int getXMax() {
        return this.toCellFloor(this.getPaintX() + this.image.getWidth() - 1);
    }

    private int getYMin() {
        return this.toCellFloor(this.getPaintY());
    }

    private int getYMax() {
        return this.toCellFloor(this.getPaintY() + this.image.getHeight() - 1);
    }

    private final int getPaintX() {
        double cellCenter = this.getCellCenter(this.x);
        double paintX = cellCenter - (double)this.image.getWidth() / 2.0;
        return (int)Math.floor(paintX);
    }

    private final int getPaintY() {
        double cellCenter = this.getCellCenter(this.y);
        double paintY = cellCenter - (double)this.image.getHeight() / 2.0;
        return (int)Math.floor(paintY);
    }

    private double getCellCenter(int cell) throws IllegalStateException {
        World aWorld = this.world;
        if (aWorld == null) {
            aWorld = this.getActiveWorld();
        }
        if (aWorld == null) {
            throw new IllegalStateException(NO_WORLD);
        }
        return aWorld.getCellCenter(cell);
    }

    private void sizeChanged() {
        int newSize = this.calcBoundingRadius();
        if (this.boundingCircle != null && newSize == this.boundingCircle.getRadius()) {
            return;
        }
        if (this.boundingCircle != null) {
            this.boundingCircle.setRadius(newSize);
        }
        if (this.world != null) {
            this.world.updateObjectSize(this);
        }
    }

    private void locationChanged(int oldX, int oldY) {
        if (this.boundingCircle != null) {
            this.boundingCircle.setX(this.x);
            this.boundingCircle.setY(this.y);
        }
        if (this.world != null) {
            this.world.updateObjectLocation(this, oldX, oldY);
        }
    }

    private int calcBoundingRadius() {
        if (this.world == null) {
            return -1;
        }
        int dy = this.getYMax() - this.getYMin() + 3;
        int dx = this.getXMax() - this.getXMin() + 3;
        return (int)(Math.sqrt(dx * dx + dy * dy) / 2.0);
    }

    private void failIfNotInWorld() {
        if (this.world == null) {
            throw new IllegalStateException(ACTOR_NOT_IN_WORLD);
        }
    }

    protected boolean intersects(Actor other) {
        int otherH;
        int thisH;
        int otherY;
        int otherW;
        int thisW;
        int otherX;
        int thisX = this.getXMin();
        if (!this.intersects(thisX, otherX = other.getXMin(), thisW = this.getWidth(), otherW = other.getWidth())) {
            return false;
        }
        int thisY = this.getYMin();
        return this.intersects(thisY, otherY = other.getYMin(), thisH = this.getHeight(), otherH = other.getHeight());
    }

    protected List getNeighbours(int distance, boolean diagonal, Class cls) {
        this.failIfNotInWorld();
        return this.getWorld().getNeighbours(this, distance, diagonal, cls);
    }

    protected List getObjectsAtOffset(int dx, int dy, Class cls) {
        this.failIfNotInWorld();
        return this.world.getObjectsAt(this.getX() + dx, this.getY() + dy, cls);
    }

    protected Actor getOneObjectAtOffset(int dx, int dy, Class cls) {
        this.failIfNotInWorld();
        return this.world.getOneObjectAt(this, this.getX() + dx, this.getY() + dy, cls);
    }

    protected List getObjectsInRange(int r, Class cls) {
        this.failIfNotInWorld();
        List inRange = this.world.getObjectsInRange(this.getX(), this.getY(), r, cls);
        inRange.remove(this);
        return inRange;
    }

    protected List getIntersectingObjects(Class cls) {
        this.failIfNotInWorld();
        List l = this.world.getIntersectingObjects(this, cls);
        l.remove(this);
        return l;
    }

    protected Actor getOneIntersectingObject(Class cls) {
        this.failIfNotInWorld();
        return this.world.getOneIntersectingObject(this, cls);
    }

    boolean contains(int dx, int dy) {
        this.failIfNotInWorld();
        if (this.image != null) {
            int width = this.getXMax() - this.getXMin() + 1;
            int height = this.getYMax() - this.getYMin() + 1;
            int left = this.getXMin() - this.getX();
            int top = this.getYMin() - this.getY();
            return this.intersects(dx, dy, left, top, width, height);
        }
        return false;
    }

    private boolean intersects(int x, int y, int rectX, int rectY, int rectWidth, int rectHeight) {
        return x >= rectX && x < rectX + rectWidth && y >= rectY && y < rectY + rectHeight;
    }

    private boolean intersects(int x1, int x2, int w1, int w2) {
        if (x1 <= x2 && x2 < x1 + w1) {
            return true;
        }
        if (x1 < x2 + w2 && x2 + w2 <= x1 + w1) {
            return true;
        }
        if (x2 <= x1 && x1 < x2 + w2) {
            return true;
        }
        return x2 < x1 + w1 && x1 + w1 <= x2 + w2;
    }

    final int getSequenceNumber() {
        return this.mySequenceNumber;
    }

    final int getLastPaintSeqNum() {
        return this.lastPaintSequenceNumber;
    }

    final void setLastPaintSeqNum(int num) {
        this.lastPaintSequenceNumber = num;
    }

    static void setDelegate(ActorDelegate d) {
        delegate = d;
    }

    static ActorDelegate getDelegate() {
        return delegate;
    }

    GreenfootImage getImage(Class clazz) {
        return delegate.getImage(clazz.getName());
    }

    World getActiveWorld() {
        return WorldHandler.getInstance().getWorld();
    }

    static Object getRemoteObjectTracker() {
        return remoteObjectTracker;
    }

    static void setTransportField(Object obj) {
        transportField = obj;
    }

    static {
        try {
            greenfootImage = new GreenfootImage(GreenfootUtil.getGreenfootLogoPath().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Greenfoot installation is broken - reinstalling Greenfoot might help.");
        }
    }
}

