/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.InvocationArgumentException;
import bluej.extensions.InvocationErrorException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.View;

public class ConstructorInvoker {
    private PkgMgrFrame pkgFrame;
    private BProject prj;
    private View view;

    public ConstructorInvoker(BPackage bPackage, String className) throws ProjectNotOpenException, PackageNotFoundException {
        this.pkgFrame = (PkgMgrFrame)bPackage.getFrame();
        this.prj = bPackage.getProject();
        Class launcherClass = null;
        try {
            launcherClass = this.getClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.view = View.getView((Class)launcherClass);
    }

    public ObjectWrapper invokeConstructor(String instanceNameOnObjectBench, String[] args) throws InvocationArgumentException, InvocationErrorException {
        ObjectBench objBench = this.pkgFrame.getObjectBench();
        Package pkg = this.pkgFrame.getPackage();
        Debugger debugger = this.pkgFrame.getProject().getDebugger();
        String[] argTypes = new String[args.length];
        DebuggerObject[] argObjects = new DebuggerObject[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = "java.lang.String";
            argObjects[i] = debugger.getMirror(args[i]);
        }
        DebuggerObject debugObject = debugger.instantiateClass(this.view.getQualifiedName(), argTypes, argObjects).getResultObject();
        ObjectWrapper wrapper = ObjectWrapper.getWrapper((PkgMgrFrame)this.pkgFrame, (ObjectBench)objBench, (DebuggerObject)debugObject, (GenTypeClass)debugObject.getGenType(), (String)instanceNameOnObjectBench);
        objBench.addObject(wrapper);
        pkg.getDebugger().addObject(pkg.getQualifiedName(), wrapper.getName(), debugObject);
        return wrapper;
    }

    private Class getClass(String fullClassname) throws ClassNotFoundException {
        Class<?> cls = null;
        try {
            cls = this.prj.getClassLoader().loadClass(fullClassname);
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        return cls;
    }
}

