/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.tokenmarker.SQLTokenMarker;

public class TSQLTokenMarker
extends SQLTokenMarker {
    private static KeywordMap tsqlKeywords;

    public TSQLTokenMarker() {
        super(TSQLTokenMarker.getKeywordMap(), true);
    }

    public static KeywordMap getKeywordMap() {
        if (tsqlKeywords == null) {
            tsqlKeywords = new KeywordMap(true);
            TSQLTokenMarker.addKeywords();
            TSQLTokenMarker.addDataTypes();
            TSQLTokenMarker.addSystemFunctions();
            TSQLTokenMarker.addOperators();
            TSQLTokenMarker.addSystemStoredProcedures();
            TSQLTokenMarker.addSystemTables();
        }
        return tsqlKeywords;
    }

    private static void addKeywords() {
        tsqlKeywords.add("ADD", (byte)7);
        tsqlKeywords.add("ALTER", (byte)7);
        tsqlKeywords.add("ANSI_NULLS", (byte)7);
        tsqlKeywords.add("AS", (byte)7);
        tsqlKeywords.add("ASC", (byte)7);
        tsqlKeywords.add("AUTHORIZATION", (byte)7);
        tsqlKeywords.add("BACKUP", (byte)7);
        tsqlKeywords.add("BEGIN", (byte)7);
        tsqlKeywords.add("BREAK", (byte)7);
        tsqlKeywords.add("BROWSE", (byte)7);
        tsqlKeywords.add("BULK", (byte)7);
        tsqlKeywords.add("BY", (byte)7);
        tsqlKeywords.add("CASCADE", (byte)7);
        tsqlKeywords.add("CHECK", (byte)7);
        tsqlKeywords.add("CHECKPOINT", (byte)7);
        tsqlKeywords.add("CLOSE", (byte)7);
        tsqlKeywords.add("CLUSTERED", (byte)7);
        tsqlKeywords.add("COLUMN", (byte)7);
        tsqlKeywords.add("COMMIT", (byte)7);
        tsqlKeywords.add("COMMITTED", (byte)7);
        tsqlKeywords.add("COMPUTE", (byte)7);
        tsqlKeywords.add("CONFIRM", (byte)7);
        tsqlKeywords.add("CONSTRAINT", (byte)7);
        tsqlKeywords.add("CONTAINS", (byte)7);
        tsqlKeywords.add("CONTAINSTABLE", (byte)7);
        tsqlKeywords.add("CONTINUE", (byte)7);
        tsqlKeywords.add("CONTROLROW", (byte)7);
        tsqlKeywords.add("CREATE", (byte)7);
        tsqlKeywords.add("CURRENT", (byte)7);
        tsqlKeywords.add("CURRENT_DATE", (byte)7);
        tsqlKeywords.add("CURRENT_TIME", (byte)7);
        tsqlKeywords.add("CURSOR", (byte)7);
        tsqlKeywords.add("DATABASE", (byte)7);
        tsqlKeywords.add("DBCC", (byte)7);
        tsqlKeywords.add("DEALLOCATE", (byte)7);
        tsqlKeywords.add("DECLARE", (byte)7);
        tsqlKeywords.add("DEFAULT", (byte)7);
        tsqlKeywords.add("DELETE", (byte)7);
        tsqlKeywords.add("DENY", (byte)7);
        tsqlKeywords.add("DESC", (byte)7);
        tsqlKeywords.add("DISK", (byte)7);
        tsqlKeywords.add("DISTINCT", (byte)7);
        tsqlKeywords.add("DISTRIBUTED", (byte)7);
        tsqlKeywords.add("DOUBLE", (byte)7);
        tsqlKeywords.add("DROP", (byte)7);
        tsqlKeywords.add("DUMMY", (byte)7);
        tsqlKeywords.add("DUMP", (byte)7);
        tsqlKeywords.add("ELSE", (byte)7);
        tsqlKeywords.add("END", (byte)7);
        tsqlKeywords.add("ERRLVL", (byte)7);
        tsqlKeywords.add("ERROREXIT", (byte)7);
        tsqlKeywords.add("ESCAPE", (byte)7);
        tsqlKeywords.add("EXCEPT", (byte)7);
        tsqlKeywords.add("EXEC", (byte)7);
        tsqlKeywords.add("EXECUTE", (byte)7);
        tsqlKeywords.add("EXIT", (byte)7);
        tsqlKeywords.add("FETCH", (byte)7);
        tsqlKeywords.add("FILE", (byte)7);
        tsqlKeywords.add("FILLFACTOR", (byte)7);
        tsqlKeywords.add("FLOPPY", (byte)7);
        tsqlKeywords.add("FOR", (byte)7);
        tsqlKeywords.add("FOREIGN", (byte)7);
        tsqlKeywords.add("FREETEXT", (byte)7);
        tsqlKeywords.add("FREETEXTTABLE", (byte)7);
        tsqlKeywords.add("FROM", (byte)7);
        tsqlKeywords.add("FULL", (byte)7);
        tsqlKeywords.add("GOTO", (byte)7);
        tsqlKeywords.add("GRANT", (byte)7);
        tsqlKeywords.add("GROUP", (byte)7);
        tsqlKeywords.add("HAVING", (byte)7);
        tsqlKeywords.add("HOLDLOCK", (byte)7);
        tsqlKeywords.add("IDENTITY_INSERT", (byte)7);
        tsqlKeywords.add("IDENTITYCOL", (byte)7);
        tsqlKeywords.add("ID", (byte)7);
        tsqlKeywords.add("IF", (byte)7);
        tsqlKeywords.add("INDEX", (byte)7);
        tsqlKeywords.add("INNER", (byte)7);
        tsqlKeywords.add("INSERT", (byte)7);
        tsqlKeywords.add("INTO", (byte)7);
        tsqlKeywords.add("IS", (byte)7);
        tsqlKeywords.add("ISOLATION", (byte)7);
        tsqlKeywords.add("KEY", (byte)7);
        tsqlKeywords.add("KILL", (byte)7);
        tsqlKeywords.add("LEVEL", (byte)7);
        tsqlKeywords.add("LINENO", (byte)7);
        tsqlKeywords.add("LOAD", (byte)7);
        tsqlKeywords.add("MAX", (byte)7);
        tsqlKeywords.add("MIN", (byte)7);
        tsqlKeywords.add("MIRROREXIT", (byte)7);
        tsqlKeywords.add("NATIONAL", (byte)7);
        tsqlKeywords.add("NOCHECK", (byte)7);
        tsqlKeywords.add("NONCLUSTERED", (byte)7);
        tsqlKeywords.add("OF", (byte)7);
        tsqlKeywords.add("OFF", (byte)7);
        tsqlKeywords.add("OFFSETS", (byte)7);
        tsqlKeywords.add("ON", (byte)7);
        tsqlKeywords.add("ONCE", (byte)7);
        tsqlKeywords.add("ONLY", (byte)7);
        tsqlKeywords.add("OPEN", (byte)7);
        tsqlKeywords.add("OPENDATASOURCE", (byte)7);
        tsqlKeywords.add("OPENQUERY", (byte)7);
        tsqlKeywords.add("OPENROWSET", (byte)7);
        tsqlKeywords.add("OPTION", (byte)7);
        tsqlKeywords.add("ORDER", (byte)7);
        tsqlKeywords.add("OVER", (byte)7);
        tsqlKeywords.add("PERCENT", (byte)7);
        tsqlKeywords.add("PERM", (byte)7);
        tsqlKeywords.add("PERMANENT", (byte)7);
        tsqlKeywords.add("PIPE", (byte)7);
        tsqlKeywords.add("PLAN", (byte)7);
        tsqlKeywords.add("PRECISION", (byte)7);
        tsqlKeywords.add("PREPARE", (byte)7);
        tsqlKeywords.add("PRIMARY", (byte)7);
        tsqlKeywords.add("PRINT", (byte)7);
        tsqlKeywords.add("PRIVILEGES", (byte)7);
        tsqlKeywords.add("PROC", (byte)7);
        tsqlKeywords.add("PROCEDURE", (byte)7);
        tsqlKeywords.add("PROCESSEXIT", (byte)7);
        tsqlKeywords.add("PUBLIC", (byte)7);
        tsqlKeywords.add("QUOTED_IDENTIFIER", (byte)7);
        tsqlKeywords.add("RAISERROR", (byte)7);
        tsqlKeywords.add("READ", (byte)7);
        tsqlKeywords.add("READTEXT", (byte)7);
        tsqlKeywords.add("RECONFIGURE", (byte)7);
        tsqlKeywords.add("REFERENCES", (byte)7);
        tsqlKeywords.add("REPEATABLE", (byte)7);
        tsqlKeywords.add("REPLICATION", (byte)7);
        tsqlKeywords.add("RESTORE", (byte)7);
        tsqlKeywords.add("RESTRICT", (byte)7);
        tsqlKeywords.add("RETURN", (byte)7);
        tsqlKeywords.add("REVOKE", (byte)7);
        tsqlKeywords.add("ROLLBACK", (byte)7);
        tsqlKeywords.add("ROWGUIDCOL", (byte)7);
        tsqlKeywords.add("RULE", (byte)7);
        tsqlKeywords.add("SAVE", (byte)7);
        tsqlKeywords.add("SCHEMA", (byte)7);
        tsqlKeywords.add("SELECT", (byte)7);
        tsqlKeywords.add("SERIALIZABLE", (byte)7);
        tsqlKeywords.add("SET", (byte)7);
        tsqlKeywords.add("SETUSER", (byte)7);
        tsqlKeywords.add("SHUTDOWN", (byte)7);
        tsqlKeywords.add("STATISTICS", (byte)7);
        tsqlKeywords.add("TABLE", (byte)7);
        tsqlKeywords.add("TAPE", (byte)7);
        tsqlKeywords.add("TEMP", (byte)7);
        tsqlKeywords.add("TEMPORARY", (byte)7);
        tsqlKeywords.add("TEXTIMAGE_ON", (byte)7);
        tsqlKeywords.add("THEN", (byte)7);
        tsqlKeywords.add("TO", (byte)7);
        tsqlKeywords.add("TOP", (byte)7);
        tsqlKeywords.add("TRAN", (byte)7);
        tsqlKeywords.add("TRANSACTION", (byte)7);
        tsqlKeywords.add("TRIGGER", (byte)7);
        tsqlKeywords.add("TRUNCATE", (byte)7);
        tsqlKeywords.add("TSEQUAL", (byte)7);
        tsqlKeywords.add("UNCOMMITTED", (byte)7);
        tsqlKeywords.add("UNION", (byte)7);
        tsqlKeywords.add("UNIQUE", (byte)7);
        tsqlKeywords.add("UPDATE", (byte)7);
        tsqlKeywords.add("UPDATETEXT", (byte)7);
        tsqlKeywords.add("USE", (byte)7);
        tsqlKeywords.add("VALUES", (byte)7);
        tsqlKeywords.add("VARYING", (byte)7);
        tsqlKeywords.add("VIEW", (byte)7);
        tsqlKeywords.add("WAITFOR", (byte)7);
        tsqlKeywords.add("WHEN", (byte)7);
        tsqlKeywords.add("WHERE", (byte)7);
        tsqlKeywords.add("WHILE", (byte)7);
        tsqlKeywords.add("WITH", (byte)7);
        tsqlKeywords.add("WORK", (byte)7);
        tsqlKeywords.add("WRITETEXT", (byte)7);
    }

    private static void addDataTypes() {
        tsqlKeywords.add("binary", (byte)7);
        tsqlKeywords.add("bit", (byte)7);
        tsqlKeywords.add("char", (byte)7);
        tsqlKeywords.add("character", (byte)7);
        tsqlKeywords.add("datetime", (byte)7);
        tsqlKeywords.add("decimal", (byte)7);
        tsqlKeywords.add("float", (byte)7);
        tsqlKeywords.add("image", (byte)7);
        tsqlKeywords.add("int", (byte)7);
        tsqlKeywords.add("integer", (byte)7);
        tsqlKeywords.add("money", (byte)7);
        tsqlKeywords.add("name", (byte)7);
        tsqlKeywords.add("numeric", (byte)7);
        tsqlKeywords.add("nchar", (byte)7);
        tsqlKeywords.add("nvarchar", (byte)7);
        tsqlKeywords.add("ntext", (byte)7);
        tsqlKeywords.add("real", (byte)7);
        tsqlKeywords.add("smalldatetime", (byte)7);
        tsqlKeywords.add("smallint", (byte)7);
        tsqlKeywords.add("smallmoney", (byte)7);
        tsqlKeywords.add("text", (byte)7);
        tsqlKeywords.add("timestamp", (byte)7);
        tsqlKeywords.add("tinyint", (byte)7);
        tsqlKeywords.add("uniqueidentifier", (byte)7);
        tsqlKeywords.add("varbinary", (byte)7);
        tsqlKeywords.add("varchar", (byte)7);
    }

    private static void addSystemFunctions() {
        tsqlKeywords.add("@@CONNECTIONS", (byte)8);
        tsqlKeywords.add("@@CPU_BUSY", (byte)8);
        tsqlKeywords.add("@@CURSOR_ROWS", (byte)8);
        tsqlKeywords.add("@@DATEFIRST", (byte)8);
        tsqlKeywords.add("@@DBTS", (byte)8);
        tsqlKeywords.add("@@ERROR", (byte)8);
        tsqlKeywords.add("@@FETCH_STATUS", (byte)8);
        tsqlKeywords.add("@@IDENTITY", (byte)8);
        tsqlKeywords.add("@@IDLE", (byte)8);
        tsqlKeywords.add("@@IO_BUSY", (byte)8);
        tsqlKeywords.add("@@LANGID", (byte)8);
        tsqlKeywords.add("@@LANGUAGE", (byte)8);
        tsqlKeywords.add("@@LOCK_TIMEOUT", (byte)8);
        tsqlKeywords.add("@@MAX_CONNECTIONS", (byte)8);
        tsqlKeywords.add("@@MAX_PRECISION", (byte)8);
        tsqlKeywords.add("@@NESTLEVEL", (byte)8);
        tsqlKeywords.add("@@OPTIONS", (byte)8);
        tsqlKeywords.add("@@PACK_RECEIVED", (byte)8);
        tsqlKeywords.add("@@PACK_SENT", (byte)8);
        tsqlKeywords.add("@@PACKET_ERRORS", (byte)8);
        tsqlKeywords.add("@@PROCID", (byte)8);
        tsqlKeywords.add("@@REMSERVER", (byte)8);
        tsqlKeywords.add("@@ROWCOUNT", (byte)8);
        tsqlKeywords.add("@@SERVERNAME", (byte)8);
        tsqlKeywords.add("@@SERVICENAME", (byte)8);
        tsqlKeywords.add("@@SPID", (byte)8);
        tsqlKeywords.add("@@TEXTSIZE", (byte)8);
        tsqlKeywords.add("@@TIMETICKS", (byte)8);
        tsqlKeywords.add("@@TOTAL_ERRORS", (byte)8);
        tsqlKeywords.add("@@TOTAL_READ", (byte)8);
        tsqlKeywords.add("@@TOTAL_WRITE", (byte)8);
        tsqlKeywords.add("@@TRANCOUNT", (byte)8);
        tsqlKeywords.add("@@VERSION", (byte)8);
        tsqlKeywords.add("ABS", (byte)8);
        tsqlKeywords.add("ACOS", (byte)8);
        tsqlKeywords.add("APP_NAME", (byte)8);
        tsqlKeywords.add("ASCII", (byte)8);
        tsqlKeywords.add("ASIN", (byte)8);
        tsqlKeywords.add("ATAN", (byte)8);
        tsqlKeywords.add("ATN2", (byte)8);
        tsqlKeywords.add("CASE", (byte)8);
        tsqlKeywords.add("CAST", (byte)8);
        tsqlKeywords.add("CEILING", (byte)8);
        tsqlKeywords.add("CHARINDEX", (byte)8);
        tsqlKeywords.add("COALESCE", (byte)8);
        tsqlKeywords.add("COL_LENGTH", (byte)8);
        tsqlKeywords.add("COL_NAME", (byte)8);
        tsqlKeywords.add("COLUMNPROPERTY", (byte)8);
        tsqlKeywords.add("CONVERT", (byte)8);
        tsqlKeywords.add("COS", (byte)8);
        tsqlKeywords.add("COT", (byte)8);
        tsqlKeywords.add("CURRENT_TIME", (byte)8);
        tsqlKeywords.add("CURRENT_DATE", (byte)8);
        tsqlKeywords.add("CURRENT_TIMESTAMP", (byte)8);
        tsqlKeywords.add("CURRENT_USER", (byte)8);
        tsqlKeywords.add("CURSOR_STATUS", (byte)8);
        tsqlKeywords.add("DATABASEPROPERTY", (byte)8);
        tsqlKeywords.add("DATALENGTH", (byte)8);
        tsqlKeywords.add("DATEADD", (byte)8);
        tsqlKeywords.add("DATEDIFF", (byte)8);
        tsqlKeywords.add("DATENAME", (byte)8);
        tsqlKeywords.add("DATEPART", (byte)8);
        tsqlKeywords.add("DAY", (byte)8);
        tsqlKeywords.add("DB_ID", (byte)8);
        tsqlKeywords.add("DB_NAME", (byte)8);
        tsqlKeywords.add("DEGREES", (byte)8);
        tsqlKeywords.add("DIFFERENCE", (byte)8);
        tsqlKeywords.add("EXP", (byte)8);
        tsqlKeywords.add("FILE_ID", (byte)8);
        tsqlKeywords.add("FILE_NAME", (byte)8);
        tsqlKeywords.add("FILEGROUP_ID", (byte)8);
        tsqlKeywords.add("FILEGROUP_NAME", (byte)8);
        tsqlKeywords.add("FILEGROUPPROPERTY", (byte)8);
        tsqlKeywords.add("FILEPROPERTY", (byte)8);
        tsqlKeywords.add("FLOOR", (byte)8);
        tsqlKeywords.add("FORMATMESSAGE", (byte)8);
        tsqlKeywords.add("FULLTEXTCATALOGPROPERTY", (byte)8);
        tsqlKeywords.add("FULLTEXTSERVICEPROPERTY", (byte)8);
        tsqlKeywords.add("GETANSINULL", (byte)8);
        tsqlKeywords.add("GETDATE", (byte)8);
        tsqlKeywords.add("HOST_ID", (byte)8);
        tsqlKeywords.add("HOST_NAME", (byte)8);
        tsqlKeywords.add("IDENT_INCR", (byte)8);
        tsqlKeywords.add("IDENT_SEED", (byte)8);
        tsqlKeywords.add("IDENTITY_INSERT", (byte)8);
        tsqlKeywords.add("INDEX_COL", (byte)8);
        tsqlKeywords.add("INDEXPROPERTY", (byte)8);
        tsqlKeywords.add("IS_MEMBER", (byte)8);
        tsqlKeywords.add("IS_SRVROLEMEMBER", (byte)8);
        tsqlKeywords.add("ISDATE", (byte)8);
        tsqlKeywords.add("ISNULL", (byte)8);
        tsqlKeywords.add("ISNUMERIC", (byte)8);
        tsqlKeywords.add("LEFT", (byte)8);
        tsqlKeywords.add("LEN", (byte)8);
        tsqlKeywords.add("LOG", (byte)8);
        tsqlKeywords.add("LOG10", (byte)8);
        tsqlKeywords.add("LOWER", (byte)8);
        tsqlKeywords.add("LTRIM", (byte)8);
        tsqlKeywords.add("MONTH", (byte)8);
        tsqlKeywords.add("NEWID", (byte)8);
        tsqlKeywords.add("NULLIF", (byte)8);
        tsqlKeywords.add("OBJECT_ID", (byte)8);
        tsqlKeywords.add("OBJECT_NAME", (byte)8);
        tsqlKeywords.add("OBJECTPROPERTY", (byte)8);
        tsqlKeywords.add("PARSENAME", (byte)8);
        tsqlKeywords.add("PATINDEX", (byte)8);
        tsqlKeywords.add("PERMISSIONS", (byte)8);
        tsqlKeywords.add("PI", (byte)8);
        tsqlKeywords.add("POWER", (byte)8);
        tsqlKeywords.add("QUOTENAME", (byte)8);
        tsqlKeywords.add("RADIANS", (byte)8);
        tsqlKeywords.add("RAND", (byte)8);
        tsqlKeywords.add("REPLACE", (byte)8);
        tsqlKeywords.add("REPLICATE", (byte)8);
        tsqlKeywords.add("REVERSE", (byte)8);
        tsqlKeywords.add("RIGHT", (byte)8);
        tsqlKeywords.add("ROUND", (byte)8);
        tsqlKeywords.add("RTRIM", (byte)8);
        tsqlKeywords.add("SESSION_USER", (byte)8);
        tsqlKeywords.add("SIGN", (byte)8);
        tsqlKeywords.add("SIN", (byte)8);
        tsqlKeywords.add("SOUNDEX", (byte)8);
        tsqlKeywords.add("SPACE", (byte)8);
        tsqlKeywords.add("SQRT", (byte)8);
        tsqlKeywords.add("SQUARE", (byte)8);
        tsqlKeywords.add("STATS_DATE", (byte)8);
        tsqlKeywords.add("STR", (byte)8);
        tsqlKeywords.add("STUFF", (byte)8);
        tsqlKeywords.add("SUBSTRING", (byte)8);
        tsqlKeywords.add("SUSER_ID", (byte)8);
        tsqlKeywords.add("SUSER_NAME", (byte)8);
        tsqlKeywords.add("SUSER_SID", (byte)8);
        tsqlKeywords.add("SUSER_SNAME", (byte)8);
        tsqlKeywords.add("SYSTEM_USER", (byte)8);
        tsqlKeywords.add("TAN", (byte)8);
        tsqlKeywords.add("TEXTPTR", (byte)8);
        tsqlKeywords.add("TEXTVALID", (byte)8);
        tsqlKeywords.add("TYPEPROPERTY", (byte)8);
        tsqlKeywords.add("UNICODE", (byte)8);
        tsqlKeywords.add("UPPER", (byte)8);
        tsqlKeywords.add("USER_ID", (byte)8);
        tsqlKeywords.add("USER_NAME", (byte)8);
        tsqlKeywords.add("USER", (byte)8);
        tsqlKeywords.add("YEAR", (byte)8);
    }

    private static void addOperators() {
        tsqlKeywords.add("ALL", (byte)7);
        tsqlKeywords.add("AND", (byte)7);
        tsqlKeywords.add("ANY", (byte)7);
        tsqlKeywords.add("BETWEEN", (byte)7);
        tsqlKeywords.add("CROSS", (byte)7);
        tsqlKeywords.add("EXISTS", (byte)7);
        tsqlKeywords.add("IN", (byte)7);
        tsqlKeywords.add("INTERSECT", (byte)7);
        tsqlKeywords.add("JOIN", (byte)7);
        tsqlKeywords.add("LIKE", (byte)7);
        tsqlKeywords.add("NOT", (byte)7);
        tsqlKeywords.add("NULL", (byte)7);
        tsqlKeywords.add("OR", (byte)7);
        tsqlKeywords.add("OUTER", (byte)7);
        tsqlKeywords.add("SOME", (byte)7);
    }

    private static void addSystemStoredProcedures() {
        tsqlKeywords.add("sp_add_agent_parameter", (byte)9);
        tsqlKeywords.add("sp_add_agent_profile", (byte)9);
        tsqlKeywords.add("sp_add_alert", (byte)9);
        tsqlKeywords.add("sp_add_category", (byte)9);
        tsqlKeywords.add("sp_add_data_file_recover_suspect_db", (byte)9);
        tsqlKeywords.add("sp_add_job", (byte)9);
        tsqlKeywords.add("sp_add_jobschedule", (byte)9);
        tsqlKeywords.add("sp_add_jobserver", (byte)9);
        tsqlKeywords.add("sp_add_jobstep", (byte)9);
        tsqlKeywords.add("sp_add_log_file_recover_suspect_db", (byte)9);
        tsqlKeywords.add("sp_add_notification", (byte)9);
        tsqlKeywords.add("sp_add_operator", (byte)9);
        tsqlKeywords.add("sp_add_targetservergroup", (byte)9);
        tsqlKeywords.add("sp_add_targetsvrgrp_member", (byte)9);
        tsqlKeywords.add("sp_addalias", (byte)9);
        tsqlKeywords.add("sp_addapprole", (byte)9);
        tsqlKeywords.add("sp_addarticle", (byte)9);
        tsqlKeywords.add("sp_adddistpublisher", (byte)9);
        tsqlKeywords.add("sp_adddistributiondb", (byte)9);
        tsqlKeywords.add("sp_adddistributor", (byte)9);
        tsqlKeywords.add("sp_addextendedproc", (byte)9);
        tsqlKeywords.add("sp_addgroup", (byte)9);
        tsqlKeywords.add("sp_addlinkedserver", (byte)9);
        tsqlKeywords.add("sp_addlinkedsrvlogin", (byte)9);
        tsqlKeywords.add("sp_addlinkedsrvlogin", (byte)9);
        tsqlKeywords.add("sp_addlogin", (byte)9);
        tsqlKeywords.add("sp_addmergearticle", (byte)9);
        tsqlKeywords.add("sp_addmergefilter", (byte)9);
        tsqlKeywords.add("sp_addmergepublication", (byte)9);
        tsqlKeywords.add("sp_addmergepullsubscription", (byte)9);
        tsqlKeywords.add("sp_addmergepullsubscription_agent", (byte)9);
        tsqlKeywords.add("sp_addmergesubscription", (byte)9);
        tsqlKeywords.add("sp_addmessage", (byte)9);
        tsqlKeywords.add("sp_addpublication", (byte)9);
        tsqlKeywords.add("sp_addpublication_snapshot", (byte)9);
        tsqlKeywords.add("sp_addpublisher70", (byte)9);
        tsqlKeywords.add("sp_addpullsubscription", (byte)9);
        tsqlKeywords.add("sp_addpullsubscription_agent", (byte)9);
        tsqlKeywords.add("sp_addremotelogin", (byte)9);
        tsqlKeywords.add("sp_addrole", (byte)9);
        tsqlKeywords.add("sp_addrolemember", (byte)9);
        tsqlKeywords.add("sp_addserver", (byte)9);
        tsqlKeywords.add("sp_addsrvrolemember", (byte)9);
        tsqlKeywords.add("sp_addsubscriber", (byte)9);
        tsqlKeywords.add("sp_addsubscriber_schedule", (byte)9);
        tsqlKeywords.add("sp_addsubscription", (byte)9);
        tsqlKeywords.add("sp_addsynctriggers", (byte)9);
        tsqlKeywords.add("sp_addtabletocontents", (byte)9);
        tsqlKeywords.add("sp_addtask", (byte)9);
        tsqlKeywords.add("sp_addtype", (byte)9);
        tsqlKeywords.add("sp_addumpdevice", (byte)9);
        tsqlKeywords.add("sp_adduser", (byte)9);
        tsqlKeywords.add("sp_altermessage", (byte)9);
        tsqlKeywords.add("sp_apply_job_to_targets", (byte)9);
        tsqlKeywords.add("sp_approlepassword", (byte)9);
        tsqlKeywords.add("sp_article_validation", (byte)9);
        tsqlKeywords.add("sp_articlecolumn", (byte)9);
        tsqlKeywords.add("sp_articlefilter", (byte)9);
        tsqlKeywords.add("sp_articlesynctranprocs", (byte)9);
        tsqlKeywords.add("sp_articleview", (byte)9);
        tsqlKeywords.add("sp_attach_db", (byte)9);
        tsqlKeywords.add("sp_attach_single_file_db", (byte)9);
        tsqlKeywords.add("sp_autostats", (byte)9);
        tsqlKeywords.add("sp_bindefault", (byte)9);
        tsqlKeywords.add("sp_bindrule", (byte)9);
        tsqlKeywords.add("sp_bindsession", (byte)9);
        tsqlKeywords.add("sp_browsereplcmds", (byte)9);
        tsqlKeywords.add("sp_catalogs", (byte)9);
        tsqlKeywords.add("sp_certify_removable", (byte)9);
        tsqlKeywords.add("sp_change_agent_parameter", (byte)9);
        tsqlKeywords.add("sp_change_agent_profile", (byte)9);
        tsqlKeywords.add("sp_change_subscription_properties", (byte)9);
        tsqlKeywords.add("sp_change_users_login", (byte)9);
        tsqlKeywords.add("sp_changearticle", (byte)9);
        tsqlKeywords.add("sp_changedbowner", (byte)9);
        tsqlKeywords.add("sp_changedistpublisher", (byte)9);
        tsqlKeywords.add("sp_changedistributiondb", (byte)9);
        tsqlKeywords.add("sp_changedistributor_password", (byte)9);
        tsqlKeywords.add("sp_changedistributor_property", (byte)9);
        tsqlKeywords.add("sp_changegroup", (byte)9);
        tsqlKeywords.add("sp_changemergearticle", (byte)9);
        tsqlKeywords.add("sp_changemergefilter", (byte)9);
        tsqlKeywords.add("sp_changemergepublication", (byte)9);
        tsqlKeywords.add("sp_changemergepullsubscription", (byte)9);
        tsqlKeywords.add("sp_changemergesubscription", (byte)9);
        tsqlKeywords.add("sp_changeobjectowner", (byte)9);
        tsqlKeywords.add("sp_changepublication", (byte)9);
        tsqlKeywords.add("sp_changesubscriber", (byte)9);
        tsqlKeywords.add("sp_changesubscriber_schedule", (byte)9);
        tsqlKeywords.add("sp_changesubstatus", (byte)9);
        tsqlKeywords.add("sp_check_for_sync_trigger", (byte)9);
        tsqlKeywords.add("sp_column_privileges", (byte)9);
        tsqlKeywords.add("sp_column_privileges_ex", (byte)9);
        tsqlKeywords.add("sp_columns", (byte)9);
        tsqlKeywords.add("sp_columns_ex", (byte)9);
        tsqlKeywords.add("sp_configure", (byte)9);
        tsqlKeywords.add("sp_create_removable", (byte)9);
        tsqlKeywords.add("sp_createorphan", (byte)9);
        tsqlKeywords.add("sp_createstats", (byte)9);
        tsqlKeywords.add("sp_cursor", (byte)9);
        tsqlKeywords.add("sp_cursor_list", (byte)9);
        tsqlKeywords.add("sp_cursorclose", (byte)9);
        tsqlKeywords.add("sp_cursorexecute", (byte)9);
        tsqlKeywords.add("sp_cursorfetch", (byte)9);
        tsqlKeywords.add("sp_cursoropen", (byte)9);
        tsqlKeywords.add("sp_cursoroption", (byte)9);
        tsqlKeywords.add("sp_cursorprepare", (byte)9);
        tsqlKeywords.add("sp_cursorunprepare", (byte)9);
        tsqlKeywords.add("sp_cycle_errorlog", (byte)9);
        tsqlKeywords.add("sp_databases", (byte)9);
        tsqlKeywords.add("sp_datatype_info", (byte)9);
        tsqlKeywords.add("sp_dbcmptlevel", (byte)9);
        tsqlKeywords.add("sp_dbfixedrolepermission", (byte)9);
        tsqlKeywords.add("sp_dboption", (byte)9);
        tsqlKeywords.add("sp_defaultdb", (byte)9);
        tsqlKeywords.add("sp_defaultlanguage", (byte)9);
        tsqlKeywords.add("sp_delete_alert", (byte)9);
        tsqlKeywords.add("sp_delete_backuphistory", (byte)9);
        tsqlKeywords.add("sp_delete_category", (byte)9);
        tsqlKeywords.add("sp_delete_job", (byte)9);
        tsqlKeywords.add("sp_delete_jobschedule", (byte)9);
        tsqlKeywords.add("sp_delete_jobserver", (byte)9);
        tsqlKeywords.add("sp_delete_jobstep", (byte)9);
        tsqlKeywords.add("sp_delete_notification", (byte)9);
        tsqlKeywords.add("sp_delete_operator", (byte)9);
        tsqlKeywords.add("sp_delete_targetserver", (byte)9);
        tsqlKeywords.add("sp_delete_targetservergroup", (byte)9);
        tsqlKeywords.add("sp_delete_targetsvrgrp_member", (byte)9);
        tsqlKeywords.add("sp_deletemergeconflictrow", (byte)9);
        tsqlKeywords.add("sp_denylogin", (byte)9);
        tsqlKeywords.add("sp_depends", (byte)9);
        tsqlKeywords.add("sp_describe_cursor", (byte)9);
        tsqlKeywords.add("sp_describe_cursor_columns", (byte)9);
        tsqlKeywords.add("sp_describe_cursor_tables", (byte)9);
        tsqlKeywords.add("sp_detach_db", (byte)9);
        tsqlKeywords.add("sp_drop_agent_parameter", (byte)9);
        tsqlKeywords.add("sp_drop_agent_profile", (byte)9);
        tsqlKeywords.add("sp_dropalias", (byte)9);
        tsqlKeywords.add("sp_dropapprole", (byte)9);
        tsqlKeywords.add("sp_droparticle", (byte)9);
        tsqlKeywords.add("sp_dropdevice", (byte)9);
        tsqlKeywords.add("sp_dropdistpublisher", (byte)9);
        tsqlKeywords.add("sp_dropdistributiondb", (byte)9);
        tsqlKeywords.add("sp_dropdistributor", (byte)9);
        tsqlKeywords.add("sp_dropextendedproc", (byte)9);
        tsqlKeywords.add("sp_dropgroup", (byte)9);
        tsqlKeywords.add("sp_droplinkedsrvlogin", (byte)9);
        tsqlKeywords.add("sp_droplinkedsrvlogin", (byte)9);
        tsqlKeywords.add("sp_droplogin", (byte)9);
        tsqlKeywords.add("sp_dropmergearticle", (byte)9);
        tsqlKeywords.add("sp_dropmergefilter", (byte)9);
        tsqlKeywords.add("sp_dropmergepublication", (byte)9);
        tsqlKeywords.add("sp_dropmergepullsubscription", (byte)9);
        tsqlKeywords.add("sp_dropmergesubscription", (byte)9);
        tsqlKeywords.add("sp_dropmessage", (byte)9);
        tsqlKeywords.add("sp_droporphans", (byte)9);
        tsqlKeywords.add("sp_droppublication", (byte)9);
        tsqlKeywords.add("sp_droppullsubscription", (byte)9);
        tsqlKeywords.add("sp_dropremotelogin", (byte)9);
        tsqlKeywords.add("sp_droprole", (byte)9);
        tsqlKeywords.add("sp_droprolemember", (byte)9);
        tsqlKeywords.add("sp_dropserver", (byte)9);
        tsqlKeywords.add("sp_dropsrvrolemember", (byte)9);
        tsqlKeywords.add("sp_dropsubscriber", (byte)9);
        tsqlKeywords.add("sp_dropsubscription", (byte)9);
        tsqlKeywords.add("sp_droptask", (byte)9);
        tsqlKeywords.add("sp_droptype", (byte)9);
        tsqlKeywords.add("sp_dropuser", (byte)9);
        tsqlKeywords.add("sp_dropwebtask", (byte)9);
        tsqlKeywords.add("sp_dsninfo", (byte)9);
        tsqlKeywords.add("sp_dumpparamcmd", (byte)9);
        tsqlKeywords.add("sp_enumcodepages", (byte)9);
        tsqlKeywords.add("sp_enumcustomresolvers", (byte)9);
        tsqlKeywords.add("sp_enumdsn", (byte)9);
        tsqlKeywords.add("sp_enumfullsubscribers", (byte)9);
        tsqlKeywords.add("sp_execute", (byte)9);
        tsqlKeywords.add("sp_executesql", (byte)9);
        tsqlKeywords.add("sp_expired_subscription_cleanup", (byte)9);
        tsqlKeywords.add("sp_fkeys", (byte)9);
        tsqlKeywords.add("sp_foreignkeys", (byte)9);
        tsqlKeywords.add("sp_fulltext_catalog", (byte)9);
        tsqlKeywords.add("sp_fulltext_column", (byte)9);
        tsqlKeywords.add("sp_fulltext_database", (byte)9);
        tsqlKeywords.add("sp_fulltext_service", (byte)9);
        tsqlKeywords.add("sp_fulltext_table", (byte)9);
        tsqlKeywords.add("sp_generatefilters", (byte)9);
        tsqlKeywords.add("sp_get_distributor", (byte)9);
        tsqlKeywords.add("sp_getbindtoken", (byte)9);
        tsqlKeywords.add("sp_getmergedeletetype", (byte)9);
        tsqlKeywords.add("sp_grant_publication_access", (byte)9);
        tsqlKeywords.add("sp_grantdbaccess", (byte)9);
        tsqlKeywords.add("sp_grantlogin", (byte)9);
        tsqlKeywords.add("sp_help", (byte)9);
        tsqlKeywords.add("sp_help_agent_default", (byte)9);
        tsqlKeywords.add("sp_help_agent_parameter", (byte)9);
        tsqlKeywords.add("sp_help_agent_profile", (byte)9);
        tsqlKeywords.add("sp_help_alert", (byte)9);
        tsqlKeywords.add("sp_help_category", (byte)9);
        tsqlKeywords.add("sp_help_downloadlist", (byte)9);
        tsqlKeywords.add("sp_help_fulltext_catalogs", (byte)9);
        tsqlKeywords.add("sp_help_fulltext_catalogs_cursor", (byte)9);
        tsqlKeywords.add("sp_help_fulltext_columns", (byte)9);
        tsqlKeywords.add("sp_help_fulltext_columns_cursor", (byte)9);
        tsqlKeywords.add("sp_help_fulltext_tables", (byte)9);
        tsqlKeywords.add("sp_help_fulltext_tables_cursor", (byte)9);
        tsqlKeywords.add("sp_help_job", (byte)9);
        tsqlKeywords.add("sp_help_jobhistory", (byte)9);
        tsqlKeywords.add("sp_help_jobschedule", (byte)9);
        tsqlKeywords.add("sp_help_jobserver", (byte)9);
        tsqlKeywords.add("sp_help_jobstep", (byte)9);
        tsqlKeywords.add("sp_help_notification", (byte)9);
        tsqlKeywords.add("sp_help_operator", (byte)9);
        tsqlKeywords.add("sp_help_publication_access", (byte)9);
        tsqlKeywords.add("sp_help_targetserver", (byte)9);
        tsqlKeywords.add("sp_help_targetservergroup", (byte)9);
        tsqlKeywords.add("sp_helparticle", (byte)9);
        tsqlKeywords.add("sp_helparticlecolumns", (byte)9);
        tsqlKeywords.add("sp_helpconstraint", (byte)9);
        tsqlKeywords.add("sp_helpdb", (byte)9);
        tsqlKeywords.add("sp_helpdbfixedrole", (byte)9);
        tsqlKeywords.add("sp_helpdevice", (byte)9);
        tsqlKeywords.add("sp_helpdistpublisher", (byte)9);
        tsqlKeywords.add("sp_helpdistributiondb", (byte)9);
        tsqlKeywords.add("sp_helpdistributor", (byte)9);
        tsqlKeywords.add("sp_helpextendedproc", (byte)9);
        tsqlKeywords.add("sp_helpfile", (byte)9);
        tsqlKeywords.add("sp_helpfilegroup", (byte)9);
        tsqlKeywords.add("sp_helpgroup", (byte)9);
        tsqlKeywords.add("sp_helphistory", (byte)9);
        tsqlKeywords.add("sp_helpindex", (byte)9);
        tsqlKeywords.add("sp_helplanguage", (byte)9);
        tsqlKeywords.add("sp_helplinkedsrvlogin", (byte)9);
        tsqlKeywords.add("sp_helplogins", (byte)9);
        tsqlKeywords.add("sp_helpmergearticle", (byte)9);
        tsqlKeywords.add("sp_helpmergearticleconflicts", (byte)9);
        tsqlKeywords.add("sp_helpmergeconflictrows", (byte)9);
        tsqlKeywords.add("sp_helpmergedeleteconflictrows", (byte)9);
        tsqlKeywords.add("sp_helpmergefilter", (byte)9);
        tsqlKeywords.add("sp_helpmergepublication", (byte)9);
        tsqlKeywords.add("sp_helpmergepullsubscription", (byte)9);
        tsqlKeywords.add("sp_helpmergesubscription", (byte)9);
        tsqlKeywords.add("sp_helpntgroup", (byte)9);
        tsqlKeywords.add("sp_helppublication", (byte)9);
        tsqlKeywords.add("sp_helppullsubscription", (byte)9);
        tsqlKeywords.add("sp_helpremotelogin", (byte)9);
        tsqlKeywords.add("sp_helpreplicationdboption", (byte)9);
        tsqlKeywords.add("sp_helprole", (byte)9);
        tsqlKeywords.add("sp_helprolemember", (byte)9);
        tsqlKeywords.add("sp_helprotect", (byte)9);
        tsqlKeywords.add("sp_helpserver", (byte)9);
        tsqlKeywords.add("sp_helpsort", (byte)9);
        tsqlKeywords.add("sp_helpsrvrole", (byte)9);
        tsqlKeywords.add("sp_helpsrvrolemember", (byte)9);
        tsqlKeywords.add("sp_helpsubscriberinfo", (byte)9);
        tsqlKeywords.add("sp_helpsubscription", (byte)9);
        tsqlKeywords.add("sp_helpsubscription_properties", (byte)9);
        tsqlKeywords.add("sp_helptask", (byte)9);
        tsqlKeywords.add("sp_helptext", (byte)9);
        tsqlKeywords.add("sp_helptrigger", (byte)9);
        tsqlKeywords.add("sp_helpuser", (byte)9);
        tsqlKeywords.add("sp_indexes", (byte)9);
        tsqlKeywords.add("sp_indexoption", (byte)9);
        tsqlKeywords.add("sp_link_publication", (byte)9);
        tsqlKeywords.add("sp_linkedservers", (byte)9);
        tsqlKeywords.add("sp_lock", (byte)9);
        tsqlKeywords.add("sp_makewebtask", (byte)9);
        tsqlKeywords.add("sp_manage_jobs_by_login", (byte)9);
        tsqlKeywords.add("sp_mergedummyupdate", (byte)9);
        tsqlKeywords.add("sp_mergesubscription_cleanup", (byte)9);
        tsqlKeywords.add("sp_monitor", (byte)9);
        tsqlKeywords.add("sp_msx_defect", (byte)9);
        tsqlKeywords.add("sp_msx_enlist", (byte)9);
        tsqlKeywords.add("sp_OACreate", (byte)9);
        tsqlKeywords.add("sp_OADestroy", (byte)9);
        tsqlKeywords.add("sp_OAGetErrorInfo", (byte)9);
        tsqlKeywords.add("sp_OAGetProperty", (byte)9);
        tsqlKeywords.add("sp_OAMethod", (byte)9);
        tsqlKeywords.add("sp_OASetProperty", (byte)9);
        tsqlKeywords.add("sp_OAStop", (byte)9);
        tsqlKeywords.add("sp_password", (byte)9);
        tsqlKeywords.add("sp_pkeys", (byte)9);
        tsqlKeywords.add("sp_post_msx_operation", (byte)9);
        tsqlKeywords.add("sp_prepare", (byte)9);
        tsqlKeywords.add("sp_primarykeys", (byte)9);
        tsqlKeywords.add("sp_processmail", (byte)9);
        tsqlKeywords.add("sp_procoption", (byte)9);
        tsqlKeywords.add("sp_publication_validation", (byte)9);
        tsqlKeywords.add("sp_purge_jobhistory", (byte)9);
        tsqlKeywords.add("sp_purgehistory", (byte)9);
        tsqlKeywords.add("sp_reassigntask", (byte)9);
        tsqlKeywords.add("sp_recompile", (byte)9);
        tsqlKeywords.add("sp_refreshsubscriptions", (byte)9);
        tsqlKeywords.add("sp_refreshview", (byte)9);
        tsqlKeywords.add("sp_reinitmergepullsubscription", (byte)9);
        tsqlKeywords.add("sp_reinitmergesubscription", (byte)9);
        tsqlKeywords.add("sp_reinitpullsubscription", (byte)9);
        tsqlKeywords.add("sp_reinitsubscription", (byte)9);
        tsqlKeywords.add("sp_remoteoption", (byte)9);
        tsqlKeywords.add("sp_remove_job_from_targets", (byte)9);
        tsqlKeywords.add("sp_removedbreplication", (byte)9);
        tsqlKeywords.add("sp_rename", (byte)9);
        tsqlKeywords.add("sp_renamedb", (byte)9);
        tsqlKeywords.add("sp_replcmds", (byte)9);
        tsqlKeywords.add("sp_replcounters", (byte)9);
        tsqlKeywords.add("sp_repldone", (byte)9);
        tsqlKeywords.add("sp_replflush", (byte)9);
        tsqlKeywords.add("sp_replication_agent_checkup", (byte)9);
        tsqlKeywords.add("sp_replicationdboption", (byte)9);
        tsqlKeywords.add("sp_replsetoriginator", (byte)9);
        tsqlKeywords.add("sp_replshowcmds", (byte)9);
        tsqlKeywords.add("sp_repltrans", (byte)9);
        tsqlKeywords.add("sp_reset_connection", (byte)9);
        tsqlKeywords.add("sp_resync_targetserver", (byte)9);
        tsqlKeywords.add("sp_revoke_publication_access", (byte)9);
        tsqlKeywords.add("sp_revokedbaccess", (byte)9);
        tsqlKeywords.add("sp_revokelogin", (byte)9);
        tsqlKeywords.add("sp_runwebtask", (byte)9);
        tsqlKeywords.add("sp_script_synctran_commands", (byte)9);
        tsqlKeywords.add("sp_scriptdelproc", (byte)9);
        tsqlKeywords.add("sp_scriptinsproc", (byte)9);
        tsqlKeywords.add("sp_scriptmappedupdproc", (byte)9);
        tsqlKeywords.add("sp_scriptupdproc", (byte)9);
        tsqlKeywords.add("sp_sdidebug", (byte)9);
        tsqlKeywords.add("sp_server_info", (byte)9);
        tsqlKeywords.add("sp_serveroption", (byte)9);
        tsqlKeywords.add("sp_serveroption", (byte)9);
        tsqlKeywords.add("sp_setapprole", (byte)9);
        tsqlKeywords.add("sp_setnetname", (byte)9);
        tsqlKeywords.add("sp_spaceused", (byte)9);
        tsqlKeywords.add("sp_special_columns", (byte)9);
        tsqlKeywords.add("sp_sproc_columns", (byte)9);
        tsqlKeywords.add("sp_srvrolepermission", (byte)9);
        tsqlKeywords.add("sp_start_job", (byte)9);
        tsqlKeywords.add("sp_statistics", (byte)9);
        tsqlKeywords.add("sp_stop_job", (byte)9);
        tsqlKeywords.add("sp_stored_procedures", (byte)9);
        tsqlKeywords.add("sp_subscription_cleanup", (byte)9);
        tsqlKeywords.add("sp_table_privileges", (byte)9);
        tsqlKeywords.add("sp_table_privileges_ex", (byte)9);
        tsqlKeywords.add("sp_table_validation", (byte)9);
        tsqlKeywords.add("sp_tableoption", (byte)9);
        tsqlKeywords.add("sp_tables", (byte)9);
        tsqlKeywords.add("sp_tables_ex", (byte)9);
        tsqlKeywords.add("sp_unbindefault", (byte)9);
        tsqlKeywords.add("sp_unbindrule", (byte)9);
        tsqlKeywords.add("sp_unprepare", (byte)9);
        tsqlKeywords.add("sp_update_agent_profile", (byte)9);
        tsqlKeywords.add("sp_update_alert", (byte)9);
        tsqlKeywords.add("sp_update_category", (byte)9);
        tsqlKeywords.add("sp_update_job", (byte)9);
        tsqlKeywords.add("sp_update_jobschedule", (byte)9);
        tsqlKeywords.add("sp_update_jobstep", (byte)9);
        tsqlKeywords.add("sp_update_notification", (byte)9);
        tsqlKeywords.add("sp_update_operator", (byte)9);
        tsqlKeywords.add("sp_update_targetservergroup", (byte)9);
        tsqlKeywords.add("sp_updatestats", (byte)9);
        tsqlKeywords.add("sp_updatetask", (byte)9);
        tsqlKeywords.add("sp_validatelogins", (byte)9);
        tsqlKeywords.add("sp_validname", (byte)9);
        tsqlKeywords.add("sp_who", (byte)9);
        tsqlKeywords.add("xp_cmdshell", (byte)9);
        tsqlKeywords.add("xp_deletemail", (byte)9);
        tsqlKeywords.add("xp_enumgroups", (byte)9);
        tsqlKeywords.add("xp_findnextmsg", (byte)9);
        tsqlKeywords.add("xp_findnextmsg", (byte)9);
        tsqlKeywords.add("xp_grantlogin", (byte)9);
        tsqlKeywords.add("xp_logevent", (byte)9);
        tsqlKeywords.add("xp_loginconfig", (byte)9);
        tsqlKeywords.add("xp_logininfo", (byte)9);
        tsqlKeywords.add("xp_msver", (byte)9);
        tsqlKeywords.add("xp_readmail", (byte)9);
        tsqlKeywords.add("xp_revokelogin", (byte)9);
        tsqlKeywords.add("xp_sendmail", (byte)9);
        tsqlKeywords.add("xp_sprintf", (byte)9);
        tsqlKeywords.add("xp_sqlinventory", (byte)9);
        tsqlKeywords.add("xp_sqlmaint", (byte)9);
        tsqlKeywords.add("xp_sqltrace", (byte)9);
        tsqlKeywords.add("xp_sscanf", (byte)9);
        tsqlKeywords.add("xp_startmail", (byte)9);
        tsqlKeywords.add("xp_stopmail", (byte)9);
        tsqlKeywords.add("xp_trace_addnewqueue", (byte)9);
        tsqlKeywords.add("xp_trace_deletequeuedefinition", (byte)9);
        tsqlKeywords.add("xp_trace_destroyqueue", (byte)9);
        tsqlKeywords.add("xp_trace_enumqueuedefname", (byte)9);
        tsqlKeywords.add("xp_trace_enumqueuehandles", (byte)9);
        tsqlKeywords.add("xp_trace_eventclassrequired", (byte)9);
        tsqlKeywords.add("xp_trace_flushqueryhistory", (byte)9);
        tsqlKeywords.add("xp_trace_generate_event", (byte)9);
        tsqlKeywords.add("xp_trace_getappfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getconnectionidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getcpufilter", (byte)9);
        tsqlKeywords.add("xp_trace_getdbidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getdurationfilter", (byte)9);
        tsqlKeywords.add("xp_trace_geteventfilter", (byte)9);
        tsqlKeywords.add("xp_trace_geteventnames", (byte)9);
        tsqlKeywords.add("xp_trace_getevents", (byte)9);
        tsqlKeywords.add("xp_trace_gethostfilter", (byte)9);
        tsqlKeywords.add("xp_trace_gethpidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getindidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getntdmfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getntnmfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getobjidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getqueueautostart", (byte)9);
        tsqlKeywords.add("xp_trace_getqueuedestination", (byte)9);
        tsqlKeywords.add("xp_trace_getqueueproperties", (byte)9);
        tsqlKeywords.add("xp_trace_getreadfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getserverfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getseverityfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getspidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getsysobjectsfilter", (byte)9);
        tsqlKeywords.add("xp_trace_gettextfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getuserfilter", (byte)9);
        tsqlKeywords.add("xp_trace_getwritefilter", (byte)9);
        tsqlKeywords.add("xp_trace_loadqueuedefinition", (byte)9);
        tsqlKeywords.add("xp_trace_pausequeue", (byte)9);
        tsqlKeywords.add("xp_trace_restartqueue", (byte)9);
        tsqlKeywords.add("xp_trace_savequeuedefinition", (byte)9);
        tsqlKeywords.add("xp_trace_setappfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setconnectionidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setcpufilter", (byte)9);
        tsqlKeywords.add("xp_trace_setdbidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setdurationfilter", (byte)9);
        tsqlKeywords.add("xp_trace_seteventclassrequired", (byte)9);
        tsqlKeywords.add("xp_trace_seteventfilter", (byte)9);
        tsqlKeywords.add("xp_trace_sethostfilter", (byte)9);
        tsqlKeywords.add("xp_trace_sethpidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setindidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setntdmfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setntnmfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setobjidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setqueryhistory", (byte)9);
        tsqlKeywords.add("xp_trace_setqueueautostart", (byte)9);
        tsqlKeywords.add("xp_trace_setqueuecreateinfo", (byte)9);
        tsqlKeywords.add("xp_trace_setqueuedestination", (byte)9);
        tsqlKeywords.add("xp_trace_setreadfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setserverfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setseverityfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setspidfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setsysobjectsfilter", (byte)9);
        tsqlKeywords.add("xp_trace_settextfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setuserfilter", (byte)9);
        tsqlKeywords.add("xp_trace_setwritefilter", (byte)9);
    }

    private static void addSystemTables() {
        tsqlKeywords.add("backupfile", (byte)9);
        tsqlKeywords.add("backupmediafamily", (byte)9);
        tsqlKeywords.add("backupmediaset", (byte)9);
        tsqlKeywords.add("backupset", (byte)9);
        tsqlKeywords.add("MSagent_parameters", (byte)9);
        tsqlKeywords.add("MSagent_profiles", (byte)9);
        tsqlKeywords.add("MSarticles", (byte)9);
        tsqlKeywords.add("MSdistpublishers", (byte)9);
        tsqlKeywords.add("MSdistribution_agents", (byte)9);
        tsqlKeywords.add("MSdistribution_history", (byte)9);
        tsqlKeywords.add("MSdistributiondbs", (byte)9);
        tsqlKeywords.add("MSdistributor", (byte)9);
        tsqlKeywords.add("MSlogreader_agents", (byte)9);
        tsqlKeywords.add("MSlogreader_history", (byte)9);
        tsqlKeywords.add("MSmerge_agents", (byte)9);
        tsqlKeywords.add("MSmerge_contents", (byte)9);
        tsqlKeywords.add("MSmerge_delete_conflicts", (byte)9);
        tsqlKeywords.add("MSmerge_genhistory", (byte)9);
        tsqlKeywords.add("MSmerge_history", (byte)9);
        tsqlKeywords.add("MSmerge_replinfo", (byte)9);
        tsqlKeywords.add("MSmerge_subscriptions", (byte)9);
        tsqlKeywords.add("MSmerge_tombstone", (byte)9);
        tsqlKeywords.add("MSpublication_access", (byte)9);
        tsqlKeywords.add("Mspublications", (byte)9);
        tsqlKeywords.add("Mspublisher_databases", (byte)9);
        tsqlKeywords.add("MSrepl_commands", (byte)9);
        tsqlKeywords.add("MSrepl_errors", (byte)9);
        tsqlKeywords.add("Msrepl_originators", (byte)9);
        tsqlKeywords.add("MSrepl_transactions", (byte)9);
        tsqlKeywords.add("MSrepl_version", (byte)9);
        tsqlKeywords.add("MSreplication_objects", (byte)9);
        tsqlKeywords.add("MSreplication_subscriptions", (byte)9);
        tsqlKeywords.add("MSsnapshot_agents", (byte)9);
        tsqlKeywords.add("MSsnapshot_history", (byte)9);
        tsqlKeywords.add("MSsubscriber_info", (byte)9);
        tsqlKeywords.add("MSsubscriber_schedule", (byte)9);
        tsqlKeywords.add("MSsubscription_properties", (byte)9);
        tsqlKeywords.add("MSsubscriptions", (byte)9);
        tsqlKeywords.add("restorefile", (byte)9);
        tsqlKeywords.add("restorefilegroup", (byte)9);
        tsqlKeywords.add("restorehistory", (byte)9);
        tsqlKeywords.add("sysalerts", (byte)9);
        tsqlKeywords.add("sysallocations", (byte)9);
        tsqlKeywords.add("sysaltfiles", (byte)9);
        tsqlKeywords.add("sysarticles", (byte)9);
        tsqlKeywords.add("sysarticleupdates", (byte)9);
        tsqlKeywords.add("syscacheobjects", (byte)9);
        tsqlKeywords.add("syscategories", (byte)9);
        tsqlKeywords.add("syscharsets", (byte)9);
        tsqlKeywords.add("syscolumns", (byte)9);
        tsqlKeywords.add("syscomments", (byte)9);
        tsqlKeywords.add("sysconfigures", (byte)9);
        tsqlKeywords.add("sysconstraints", (byte)9);
        tsqlKeywords.add("syscurconfigs", (byte)9);
        tsqlKeywords.add("sysdatabases", (byte)9);
        tsqlKeywords.add("sysdatabases", (byte)9);
        tsqlKeywords.add("sysdepends", (byte)9);
        tsqlKeywords.add("sysdevices", (byte)9);
        tsqlKeywords.add("sysdownloadlist", (byte)9);
        tsqlKeywords.add("sysfilegroups", (byte)9);
        tsqlKeywords.add("sysfiles", (byte)9);
        tsqlKeywords.add("sysforeignkeys", (byte)9);
        tsqlKeywords.add("sysfulltextcatalogs", (byte)9);
        tsqlKeywords.add("sysindexes", (byte)9);
        tsqlKeywords.add("sysindexkeys", (byte)9);
        tsqlKeywords.add("sysjobhistory", (byte)9);
        tsqlKeywords.add("sysjobs", (byte)9);
        tsqlKeywords.add("sysjobschedules", (byte)9);
        tsqlKeywords.add("sysjobservers", (byte)9);
        tsqlKeywords.add("sysjobsteps", (byte)9);
        tsqlKeywords.add("syslanguages", (byte)9);
        tsqlKeywords.add("syslockinfo", (byte)9);
        tsqlKeywords.add("syslogins", (byte)9);
        tsqlKeywords.add("sysmembers", (byte)9);
        tsqlKeywords.add("sysmergearticles", (byte)9);
        tsqlKeywords.add("sysmergepublications", (byte)9);
        tsqlKeywords.add("sysmergeschemachange", (byte)9);
        tsqlKeywords.add("sysmergesubscriptions", (byte)9);
        tsqlKeywords.add("sysmergesubsetfilters", (byte)9);
        tsqlKeywords.add("sysmessages", (byte)9);
        tsqlKeywords.add("sysnotifications", (byte)9);
        tsqlKeywords.add("sysobjects", (byte)9);
        tsqlKeywords.add("sysobjects", (byte)9);
        tsqlKeywords.add("sysoledbusers", (byte)9);
        tsqlKeywords.add("sysoperators", (byte)9);
        tsqlKeywords.add("sysperfinfo", (byte)9);
        tsqlKeywords.add("syspermissions", (byte)9);
        tsqlKeywords.add("sysprocesses", (byte)9);
        tsqlKeywords.add("sysprotects", (byte)9);
        tsqlKeywords.add("syspublications", (byte)9);
        tsqlKeywords.add("sysreferences", (byte)9);
        tsqlKeywords.add("sysremotelogins", (byte)9);
        tsqlKeywords.add("sysreplicationalerts", (byte)9);
        tsqlKeywords.add("sysservers", (byte)9);
        tsqlKeywords.add("sysservers", (byte)9);
        tsqlKeywords.add("syssubscriptions", (byte)9);
        tsqlKeywords.add("systargetservergroupmembers", (byte)9);
        tsqlKeywords.add("systargetservergroups", (byte)9);
        tsqlKeywords.add("systargetservers", (byte)9);
        tsqlKeywords.add("systaskids", (byte)9);
        tsqlKeywords.add("systypes", (byte)9);
        tsqlKeywords.add("sysusers", (byte)9);
    }
}

