/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import javax.swing.text.Segment;
import org.syntax.jedit.SyntaxUtilities;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class ShellScriptTokenMarker
extends TokenMarker {
    public static final byte LVARIABLE = 100;

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        int cmdState = 0;
        int lastOffset = offset = line.offset;
        int length = line.count + offset;
        if (token == 4 && lineIndex != 0 && this.lineInfo[lineIndex - 1].obj != null) {
            String str = (String)this.lineInfo[lineIndex - 1].obj;
            if (str != null && str.length() == line.count && SyntaxUtilities.regionMatches(false, line, offset, str)) {
                this.addToken(line.count, (byte)4);
                return 0;
            }
            this.addToken(line.count, (byte)4);
            this.lineInfo[lineIndex].obj = str;
            return 4;
        }
        boolean backslash = false;
        block27: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    block7 : switch (c) {
                        case '\t': 
                        case ' ': 
                        case '(': 
                        case ')': {
                            backslash = false;
                            if (cmdState != true) continue block27;
                            this.addToken(i - lastOffset, (byte)7);
                            lastOffset = i;
                            cmdState = 2;
                            break;
                        }
                        case '=': {
                            backslash = false;
                            if (cmdState != true) continue block27;
                            this.addToken(i - lastOffset, token);
                            lastOffset = i;
                            cmdState = 2;
                            break;
                        }
                        case '&': 
                        case ';': 
                        case '|': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            cmdState = 0;
                            break;
                        }
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            lastOffset = length;
                            break block27;
                        }
                        case '$': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - lastOffset, token);
                            cmdState = 2;
                            lastOffset = i;
                            if (length - i >= 2) {
                                switch (array[i1]) {
                                    case '(': {
                                        break block7;
                                    }
                                    case '{': {
                                        token = (byte)100;
                                        break block7;
                                    }
                                }
                                token = (byte)8;
                                break;
                            }
                            token = (byte)8;
                            break;
                        }
                        case '\"': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - lastOffset, token);
                            token = (byte)4;
                            this.lineInfo[lineIndex].obj = null;
                            cmdState = 2;
                            lastOffset = i;
                            break;
                        }
                        case '\'': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - lastOffset, token);
                            token = (byte)13;
                            cmdState = 2;
                            lastOffset = i;
                            break;
                        }
                        case '<': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (length - i <= 1 || array[i1] != '<') continue block27;
                            this.addToken(i - lastOffset, token);
                            token = (byte)4;
                            lastOffset = i;
                            this.lineInfo[lineIndex].obj = new String(array, i + 2, length - (i + 2));
                            break;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetter(c) || cmdState != 0) continue block27;
                            this.addToken(i - lastOffset, token);
                            lastOffset = i;
                            cmdState = (byte)(cmdState + 1);
                            break;
                        }
                    }
                    continue block27;
                }
                case 8: {
                    backslash = false;
                    if (Character.isLetterOrDigit(c) || c == '_') continue block27;
                    if (i != offset && array[i - 1] == '$') {
                        this.addToken(i1 - lastOffset, token);
                        lastOffset = i1;
                        token = 0;
                        continue block27;
                    }
                    this.addToken(i - lastOffset, token);
                    lastOffset = i;
                    token = 0;
                    continue block27;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block27;
                    }
                    if (c == '\"') {
                        this.addToken(i1 - lastOffset, token);
                        cmdState = 2;
                        lastOffset = i1;
                        token = 0;
                        continue block27;
                    }
                    backslash = false;
                    continue block27;
                }
                case 13: {
                    if (backslash) {
                        backslash = false;
                        continue block27;
                    }
                    if (c == '\'') {
                        this.addToken(i1 - lastOffset, (byte)4);
                        cmdState = 2;
                        lastOffset = i1;
                        token = 0;
                        continue block27;
                    }
                    backslash = false;
                    continue block27;
                }
                case 100: {
                    backslash = false;
                    if (c != '}') continue block27;
                    this.addToken(i1 - lastOffset, (byte)8);
                    lastOffset = i1;
                    token = 0;
                    continue block27;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        switch (token) {
            case 0: {
                if (cmdState == 1) {
                    this.addToken(length - lastOffset, (byte)7);
                    break;
                }
                this.addToken(length - lastOffset, token);
                break;
            }
            case 13: {
                this.addToken(length - lastOffset, (byte)4);
                break;
            }
            case 8: {
                this.addToken(length - lastOffset, token);
                token = 0;
                break;
            }
            case 100: {
                this.addToken(length - lastOffset, (byte)11);
                token = 0;
                break;
            }
            default: {
                this.addToken(length - lastOffset, token);
            }
        }
        return token;
    }
}

