/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public final class StatusLabel
extends JLabel {
    public static Font statusFont = new Font("SansSerif", 3, 11);
    static final int READONLY = 0;
    static final int SAVED = 1;
    static final int CHANGED = 2;
    private final String[] stateString = new String[]{Config.getString((String)"editor.state.readOnly"), Config.getString((String)"editor.state.saved"), Config.getString((String)"editor.state.changed")};
    private int state;

    public StatusLabel(int initialState) {
        super("", 0);
        this.setText(this.stateString[initialState]);
        this.setFont(statusFont);
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.state = initialState;
    }

    public boolean isSaved() {
        return this.state != 2;
    }

    public boolean isChanged() {
        return this.state == 2;
    }

    public boolean isReadOnly() {
        return this.state == 0;
    }

    public void setState(int newState) {
        this.state = newState;
        this.setText(this.stateString[this.state]);
    }
}

