/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeEditor;
import java.util.LinkedList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class MoeUndoManager
implements UndoableEditListener {
    LinkedList editStack;
    UndoManager undoManager;
    CompoundEdit currentEdit;
    MoeEditor editor;

    public MoeUndoManager(MoeEditor editor) {
        this.editor = editor;
        this.undoManager = new UndoManager();
        this.currentEdit = this.undoManager;
        this.editStack = new LinkedList();
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.addEdit(e.getEdit());
    }

    public void addEdit(UndoableEdit edit) {
        this.currentEdit.addEdit(edit);
        if (this.currentEdit == this.undoManager) {
            this.editor.updateUndoControls();
            this.editor.updateRedoControls();
        }
    }

    public void beginCompoundEdit() {
        this.editStack.add(this.currentEdit);
        this.currentEdit = new CompoundEdit();
    }

    public void endCompoundEdit() {
        this.currentEdit.end();
        CompoundEdit lastEdit = (CompoundEdit)this.editStack.removeLast();
        lastEdit.addEdit(this.currentEdit);
        this.currentEdit = lastEdit;
        if (this.currentEdit == this.undoManager) {
            this.editor.updateUndoControls();
            this.editor.updateRedoControls();
        }
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }
}

