/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import java.awt.Color;
import java.util.Properties;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import org.syntax.jedit.SyntaxDocument;

public class MoeSyntaxDocument
extends SyntaxDocument {
    public static final String OUTPUT = "output";
    public static final String ERROR = "error";
    private static Color[] colors = null;
    private static Color defaultColour = null;
    private static Color backgroundColour = null;

    public MoeSyntaxDocument() {
        super(MoeSyntaxDocument.getUserColors());
        int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
        this.putProperty("tabSize", new Integer(tabSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParagraphAttributes(int offset, AttributeSet s) {
        try {
            this.writeLock();
            Element paragraph = this.getParagraphElement(offset);
            MutableAttributeSet attr = (MutableAttributeSet)paragraph.getAttributes();
            attr.addAttributes(s);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    public static Color getDefaultColor() {
        return defaultColour;
    }

    public static Color getBackgroundColor() {
        return backgroundColour;
    }

    private static Color[] getUserColors() {
        if (colors == null) {
            int colorInt = MoeSyntaxDocument.getPropHexInt("other", 0);
            defaultColour = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("background", 0);
            backgroundColour = new Color(colorInt);
            colors = new Color[12];
            colorInt = MoeSyntaxDocument.getPropHexInt("comment", 1710720);
            MoeSyntaxDocument.colors[1] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("javadoc", 1710720);
            MoeSyntaxDocument.colors[2] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("stand-out", 0xEE00BB);
            MoeSyntaxDocument.colors[3] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("keyword1", 0x660033);
            MoeSyntaxDocument.colors[7] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("keyword2", 13402163);
            MoeSyntaxDocument.colors[8] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("keyword3", 26265);
            MoeSyntaxDocument.colors[9] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("primitive", 0xCC0000);
            MoeSyntaxDocument.colors[5] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("string", 0x339933);
            MoeSyntaxDocument.colors[4] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("label", 0x999999);
            MoeSyntaxDocument.colors[6] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("invalid", 0xFF3300);
            MoeSyntaxDocument.colors[11] = new Color(colorInt);
            MoeSyntaxDocument.colors[10] = new Color(0xCC9900);
        }
        return colors;
    }

    private static int getPropHexInt(String propName, int def) {
        String strVal = Config.getPropString((String)propName, null, (Properties)Config.moeUserProps);
        try {
            return Integer.parseInt(strVal, 16);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }
}

